/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.mana;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import vazkii.botania.api.mana.ILens;
import vazkii.botania.common.block.BlockModWaterloggable;
import vazkii.botania.common.block.tile.ModTiles;
import vazkii.botania.common.block.tile.mana.TileSpreader;
import vazkii.botania.common.handler.ModSounds;
import vazkii.botania.common.helper.ColorHelper;
import vazkii.botania.common.item.ModItems;

public class BlockSpreader
extends BlockModWaterloggable
implements EntityBlock {
    private static final VoxelShape SHAPE = BlockSpreader.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape RENDER_SHAPE = BlockSpreader.m_49796_((double)2.0, (double)2.0, (double)2.0, (double)14.0, (double)14.0, (double)14.0);
    public final Variant variant;

    public BlockSpreader(Variant v, BlockBehaviour.Properties builder) {
        super(builder);
        this.variant = v;
    }

    @Nonnull
    public VoxelShape m_5940_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return SHAPE;
    }

    @Nonnull
    public VoxelShape m_7952_(BlockState state, @Nonnull BlockGetter world, @Nonnull BlockPos pos) {
        return RENDER_SHAPE;
    }

    public float m_7749_(BlockState state, BlockGetter level, BlockPos pos) {
        return 1.0f;
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        Direction orientation = placer == null ? Direction.WEST : Direction.m_122382_((Entity)placer)[0].m_122424_();
        TileSpreader spreader = (TileSpreader)world.m_7702_(pos);
        switch (orientation) {
            case DOWN: {
                spreader.rotationY = -90.0f;
                break;
            }
            case UP: {
                spreader.rotationY = 90.0f;
                break;
            }
            case NORTH: {
                spreader.rotationX = 270.0f;
                break;
            }
            case SOUTH: {
                spreader.rotationX = 90.0f;
                break;
            }
            case WEST: {
                break;
            }
            case EAST: {
                spreader.rotationX = 180.0f;
            }
        }
    }

    @Nonnull
    public RenderShape m_7514_(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        boolean wool;
        BlockEntity tile = world.m_7702_(pos);
        if (!(tile instanceof TileSpreader)) {
            return InteractionResult.PASS;
        }
        TileSpreader spreader = (TileSpreader)tile;
        ItemStack lens = spreader.getItemHandler().m_8020_(0);
        ItemStack heldItem = player.m_21120_(hand);
        boolean isHeldItemLens = !heldItem.m_41619_() && heldItem.m_41720_() instanceof ILens;
        boolean bl = wool = !heldItem.m_41619_() && ColorHelper.isWool(Block.m_49814_((Item)heldItem.m_41720_()));
        if (!heldItem.m_41619_() && heldItem.m_150930_(ModItems.twigWand)) {
            return InteractionResult.PASS;
        }
        if (lens.m_41619_() && isHeldItemLens) {
            ItemStack toInsert;
            if (!player.m_150110_().f_35937_) {
                toInsert = heldItem.m_41620_(1);
            } else {
                toInsert = heldItem.m_41777_();
                toInsert.m_41764_(1);
            }
            spreader.getItemHandler().m_6836_(0, toInsert);
            return InteractionResult.SUCCESS;
        }
        if (!lens.m_41619_() && !wool) {
            player.m_150109_().m_150079_(lens);
            spreader.getItemHandler().m_6836_(0, ItemStack.f_41583_);
            return InteractionResult.SUCCESS;
        }
        if (wool && spreader.paddingColor == null) {
            Block block = Block.m_49814_((Item)heldItem.m_41720_());
            spreader.paddingColor = ColorHelper.getWoolColor(block);
            if (!player.m_150110_().f_35937_) {
                heldItem.m_41774_(1);
                if (heldItem.m_41619_()) {
                    player.m_21008_(hand, ItemStack.f_41583_);
                }
            }
            world.m_5594_(player, pos, ModSounds.spreaderCover, SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        if (wool || heldItem.m_41619_() && spreader.paddingColor != null && lens.m_41619_()) {
            ItemStack pad = new ItemStack((ItemLike)ColorHelper.WOOL_MAP.apply(spreader.paddingColor));
            player.m_150109_().m_150079_(pad);
            spreader.paddingColor = null;
            spreader.m_6596_();
            world.m_5594_(player, pos, ModSounds.spreaderUncover, SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void m_6810_(@Nonnull BlockState state, @Nonnull Level world, @Nonnull BlockPos pos, @Nonnull BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            BlockEntity tile = world.m_7702_(pos);
            if (!(tile instanceof TileSpreader)) {
                return;
            }
            TileSpreader inv = (TileSpreader)tile;
            if (inv.paddingColor != null) {
                ItemStack padding = new ItemStack((ItemLike)ColorHelper.WOOL_MAP.apply(inv.paddingColor));
                world.m_7967_((Entity)new ItemEntity(world, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), padding));
            }
            Containers.m_19002_((Level)world, (BlockPos)pos, (Container)inv.getItemHandler());
            super.m_6810_(state, world, pos, newState, isMoving);
        }
    }

    @Nonnull
    public BlockEntity m_142194_(@Nonnull BlockPos pos, @Nonnull BlockState state) {
        return new TileSpreader(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return BlockSpreader.createTickerHelper(type, ModTiles.SPREADER, TileSpreader::commonTick);
    }

    public static enum Variant {
        MANA(160, 1000, 0x20FF20, 65280, 60, 4.0f, 1.0f),
        REDSTONE(160, 1000, 0xFF2020, 0xFF0000, 60, 4.0f, 1.0f),
        ELVEN(240, 1000, 16729540, 16711854, 80, 4.0f, 1.25f),
        GAIA(640, 6400, 0x20FF20, 65280, 120, 20.0f, 2.0f);

        public final int burstMana;
        public final int manaCapacity;
        public final int color;
        public final int hudColor;
        public final int preLossTicks;
        public final float lossPerTick;
        public final float motionModifier;

        private Variant(int bm, int mc, int c, int hc, int plt, float lpt, float mm) {
            this.burstMana = bm;
            this.manaCapacity = mc;
            this.color = c;
            this.hudColor = hc;
            this.preLossTicks = plt;
            this.lossPerTick = lpt;
            this.motionModifier = mm;
        }
    }
}

