/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.decor;

import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.block.BlockMod;
import vazkii.botania.common.block.tile.TileManaFlame;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.xplat.IXplatAbstractions;

public class BlockManaFlame
extends BlockMod
implements EntityBlock {
    private static final VoxelShape SHAPE = BlockManaFlame.m_49796_((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0);

    public BlockManaFlame(BlockBehaviour.Properties builder) {
        super(builder);
    }

    @Nonnull
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext ctx) {
        return SHAPE;
    }

    @Nonnull
    public RenderShape m_7514_(BlockState state) {
        return RenderShape.INVISIBLE;
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack stack;
        if (IXplatAbstractions.INSTANCE.gogLoaded() && !(stack = player.m_21120_(hand)).m_41619_() && ItemTags.f_13180_.m_8110_((Object)stack.m_41720_()) && !player.m_150109_().m_36063_(new ItemStack((ItemLike)ModItems.lexicon))) {
            if (!world.f_46443_) {
                stack.m_41774_(1);
                player.m_150109_().m_150079_(new ItemStack((ItemLike)ModItems.lexicon));
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void m_7100_(BlockState state, Level world, BlockPos pos, Random rand) {
        BlockEntity te = world.m_7702_(pos);
        if (te instanceof TileManaFlame) {
            float v;
            float b;
            float g;
            TileManaFlame flame = (TileManaFlame)te;
            int color = flame.getColor();
            float r = (float)(color >> 16 & 0xFF) / 255.0f;
            double luminance = 0.2126 * (double)r + 0.7152 * (double)(g = (float)(color >> 8 & 0xFF) / 255.0f) + 0.0722 * (double)(b = (float)(color & 0xFF) / 255.0f);
            if (luminance < (double)(v = 0.1f)) {
                r += (float)Math.random() * 0.125f;
                g += (float)Math.random() * 0.125f;
                b += (float)Math.random() * 0.125f;
            }
            float w = 0.15f;
            float h = 0.05f;
            double x = (double)pos.m_123341_() + 0.5 + (Math.random() - 0.5) * (double)w;
            double y = (double)pos.m_123342_() + 0.25 + (Math.random() - 0.5) * (double)h;
            double z = (double)pos.m_123343_() + 0.5 + (Math.random() - 0.5) * (double)w;
            float s = 0.2f + (float)Math.random() * 0.1f;
            float m = 0.03f + (float)Math.random() * 0.015f;
            WispParticleData data = WispParticleData.wisp(s, r, g, b, 1.0f);
            world.m_7106_((ParticleOptions)data, x, y, z, 0.0, (double)m, 0.0);
        }
    }

    @Nonnull
    public BlockEntity m_142194_(@Nonnull BlockPos pos, @Nonnull BlockState state) {
        return new TileManaFlame(pos, state);
    }
}

