/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.block.BlockModWaterloggable;
import vazkii.botania.common.block.tile.ModTiles;
import vazkii.botania.common.block.tile.TileCocoon;
import vazkii.botania.common.item.ModItems;

public class BlockCocoon
extends BlockModWaterloggable
implements EntityBlock {
    private static final VoxelShape SHAPE = BlockCocoon.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)14.0, (double)13.0);

    protected BlockCocoon(BlockBehaviour.Properties builder) {
        super(builder);
    }

    @Nonnull
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext ctx) {
        return SHAPE;
    }

    @Nonnull
    public RenderShape m_7514_(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public void m_7892_(BlockState state, Level world, BlockPos pos, Entity e) {
        if (!world.f_46443_ && e instanceof ItemEntity) {
            ItemEntity item = (ItemEntity)e;
            ItemStack stack = item.m_32055_();
            this.addStack(world, pos, stack, false);
            if (stack.m_41619_()) {
                item.m_146870_();
            }
        }
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack stack = player.m_21120_(hand);
        return this.addStack(world, pos, stack, player.m_150110_().f_35937_);
    }

    private InteractionResult addStack(Level world, BlockPos pos, ItemStack stack, boolean creative) {
        TileCocoon cocoon = (TileCocoon)world.m_7702_(pos);
        Item item = stack.m_41720_();
        if (cocoon != null && (stack.m_150930_(Items.f_42616_) || stack.m_150930_(Items.f_42730_) || stack.m_150930_(ModItems.lifeEssence))) {
            if (!world.f_46443_) {
                if (stack.m_150930_(Items.f_42616_) && cocoon.emeraldsGiven < 20) {
                    if (!creative) {
                        stack.m_41774_(1);
                    }
                    ++cocoon.emeraldsGiven;
                    ((ServerLevel)world).m_8767_((ParticleOptions)ParticleTypes.f_123748_, (double)pos.m_123341_() + 0.5, (double)(pos.m_123342_() + 1), (double)pos.m_123343_() + 0.5, 1, 0.1, 0.05, 0.1, 0.5);
                } else if (stack.m_150930_(Items.f_42730_) && cocoon.chorusFruitGiven < 20) {
                    if (!creative) {
                        stack.m_41774_(1);
                    }
                    ++cocoon.chorusFruitGiven;
                    ((ServerLevel)world).m_8767_((ParticleOptions)ParticleTypes.f_123760_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5, 32, 0.0, 0.0, 0.0, 0.5);
                } else if (stack.m_150930_(ModItems.lifeEssence) && !cocoon.gaiaSpiritGiven) {
                    if (!creative) {
                        stack.m_41774_(1);
                    }
                    cocoon.forceRare();
                    WispParticleData data = WispParticleData.wisp(0.6f, 0.0f, 1.0f, 0.0f);
                    ((ServerLevel)world).m_8767_((ParticleOptions)data, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.7, (double)pos.m_123343_() + 0.5, 8, 0.1, 0.1, 0.1, 0.04);
                }
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Nonnull
    public BlockEntity m_142194_(@Nonnull BlockPos pos, @Nonnull BlockState state) {
        return new TileCocoon(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return BlockCocoon.createTickerHelper(type, ModTiles.COCOON, TileCocoon::commonTick);
    }
}

