/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.render.tile;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.util.Mth;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.client.core.handler.MiscellaneousModels;
import vazkii.botania.common.block.mana.BlockSpreader;
import vazkii.botania.common.block.tile.mana.TileSpreader;

public class RenderTileSpreader
implements BlockEntityRenderer<TileSpreader> {
    public RenderTileSpreader(BlockEntityRendererProvider.Context ctx) {
    }

    public void render(@Nonnull TileSpreader spreader, float partialTicks, PoseStack ms, MultiBufferSource buffers, int light, int overlay) {
        ms.m_85836_();
        ms.m_85837_(0.5, 0.5, 0.5);
        Quaternion transform = Vector3f.f_122225_.m_122240_(spreader.rotationX + 90.0f);
        transform.m_80148_(Vector3f.f_122223_.m_122240_(spreader.rotationY));
        ms.m_85845_(transform);
        ms.m_85837_(-0.5, -0.5, -0.5);
        double time = (float)ClientTickHandler.ticksInGame + partialTicks;
        float r = 1.0f;
        float g = 1.0f;
        float b = 1.0f;
        if (spreader.getVariant() == BlockSpreader.Variant.GAIA) {
            int color = Mth.m_14169_((float)((float)((time * 2.0 + (double)new Random(spreader.m_58899_().hashCode()).nextInt(10000)) % 360.0) / 360.0f), (float)0.4f, (float)0.9f);
            r = (float)(color >> 16 & 0xFF) / 255.0f;
            g = (float)(color >> 8 & 0xFF) / 255.0f;
            b = (float)(color & 0xFF) / 255.0f;
        }
        VertexConsumer buffer = buffers.m_6299_(ItemBlockRenderTypes.m_109284_((BlockState)spreader.m_58900_(), (boolean)false));
        BakedModel spreaderModel = Minecraft.m_91087_().m_91289_().m_110910_(spreader.m_58900_());
        Minecraft.m_91087_().m_91289_().m_110937_().m_111067_(ms.m_85850_(), buffer, spreader.m_58900_(), spreaderModel, r, g, b, light, overlay);
        ms.m_85836_();
        ms.m_85837_(0.5, 0.5, 0.5);
        ms.m_85845_(Vector3f.f_122225_.m_122240_((float)time % 360.0f));
        ms.m_85837_(-0.5, -0.5, -0.5);
        ms.m_85837_(0.0, (double)((float)Math.sin(time / 20.0) * 0.05f), 0.0);
        BakedModel core = this.getCoreModel(spreader);
        Minecraft.m_91087_().m_91289_().m_110937_().m_111067_(ms.m_85850_(), buffer, spreader.m_58900_(), core, 1.0f, 1.0f, 1.0f, light, overlay);
        ms.m_85849_();
        ItemStack stack = spreader.getItemHandler().m_8020_(0);
        if (!stack.m_41619_()) {
            ms.m_85836_();
            ms.m_85837_(0.5, 0.5, (double)0.094f);
            ms.m_85845_(Vector3f.f_122227_.m_122240_(180.0f));
            ms.m_85845_(Vector3f.f_122223_.m_122240_(180.0f));
            ms.m_85841_(0.999f, 0.999f, 1.0f);
            Minecraft.m_91087_().m_91291_().m_174269_(stack, ItemTransforms.TransformType.NONE, light, overlay, ms, buffers, 0);
            ms.m_85849_();
        }
        if (spreader.paddingColor != null) {
            BakedModel model = this.getPaddingModel(spreader.paddingColor);
            Minecraft.m_91087_().m_91289_().m_110937_().m_111067_(ms.m_85850_(), buffer, spreader.m_58900_(), model, r, g, b, light, overlay);
        }
        ms.m_85849_();
    }

    private BakedModel getCoreModel(TileSpreader tile) {
        return switch (tile.getVariant()) {
            default -> throw new IncompatibleClassChangeError();
            case BlockSpreader.Variant.GAIA -> MiscellaneousModels.INSTANCE.gaiaSpreaderCore;
            case BlockSpreader.Variant.REDSTONE -> MiscellaneousModels.INSTANCE.redstoneSpreaderCore;
            case BlockSpreader.Variant.ELVEN -> MiscellaneousModels.INSTANCE.elvenSpreaderCore;
            case BlockSpreader.Variant.MANA -> MiscellaneousModels.INSTANCE.manaSpreaderCore;
        };
    }

    private BakedModel getPaddingModel(DyeColor color) {
        return MiscellaneousModels.INSTANCE.spreaderPaddings.get(color);
    }
}

