/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.render.tile;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.common.block.tile.string.TileRedString;
import vazkii.botania.common.helper.PlayerHelper;
import vazkii.botania.common.item.ModItems;

public class RenderTileRedString<T extends TileRedString>
implements BlockEntityRenderer<T> {
    private static int transparency = 0;

    public static void tick() {
        boolean hasWand;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        boolean bl = hasWand = player != null && PlayerHelper.hasHeldItem((Player)player, ModItems.twigWand);
        if (transparency > 0 && !hasWand) {
            --transparency;
        } else if (transparency < 10 && hasWand) {
            ++transparency;
        }
    }

    public RenderTileRedString(BlockEntityRendererProvider.Context ctx) {
    }

    public void render(TileRedString tile, float partialTicks, PoseStack ms, MultiBufferSource buffers, int light, int overlay) {
        if (transparency <= 0) {
            return;
        }
        float sizeAlpha = (float)transparency / 10.0f;
        int color = 0xFF0000 | (int)(sizeAlpha * 255.0f) << 24;
        Direction dir = tile.getOrientation();
        BlockPos bind = tile.getBinding();
        if (bind != null) {
            Vec3 step;
            ms.m_85836_();
            ms.m_85837_(0.5, 0.5, 0.5);
            Vec3 span = new Vec3((double)(bind.m_123341_() - tile.m_58899_().m_123341_()), (double)(bind.m_123342_() - tile.m_58899_().m_123342_()), (double)(bind.m_123343_() - tile.m_58899_().m_123343_()));
            Vec3 cur = step = span.m_82541_().m_82490_(0.025);
            int stepCount = (int)(span.m_82553_() / step.m_82553_());
            double len = (double)(-ClientTickHandler.ticksInGame) / 100.0 + (double)new Random(dir.ordinal() ^ tile.m_58899_().hashCode()).nextInt(10000);
            double add = step.m_82553_();
            double rand = Math.random() - 0.5;
            VertexConsumer buffer = buffers.m_6299_(RenderHelper.RED_STRING);
            for (int i = 0; i < stepCount; ++i) {
                RenderTileRedString.vertex(ms, buffer, color, dir, cur.f_82479_, cur.f_82480_, cur.f_82481_, rand, len);
                rand = Math.random() - 0.5;
                cur = cur.m_82549_(step);
                RenderTileRedString.vertex(ms, buffer, color, dir, cur.f_82479_, cur.f_82480_, cur.f_82481_, rand, len += add);
            }
            ms.m_85849_();
        }
    }

    private static void vertex(PoseStack ms, VertexConsumer buffer, int color, Direction dir, double xpos, double ypos, double zpos, double rand, double l) {
        float sizeAlpha = (float)transparency / 10.0f;
        float ampl = (float)(0.15 * ((double)Mth.m_14031_((float)((float)l * 2.0f)) * 0.5 + 0.5) + 0.1) * sizeAlpha;
        float trigInput = (float)(l * 20.0);
        float sin = Mth.m_14031_((float)trigInput);
        float cos = Mth.m_14089_((float)trigInput);
        float lastTerm = (float)(rand * 0.05);
        float x = (float)xpos + sin * ampl * (float)RenderTileRedString.killNonZero(dir.m_122429_()) + lastTerm;
        float y = (float)ypos + cos * ampl * (float)RenderTileRedString.killNonZero(dir.m_122430_()) + lastTerm;
        float z = (float)zpos + (dir.m_122430_() == 0 ? sin : cos) * ampl * (float)RenderTileRedString.killNonZero(dir.m_122431_()) + lastTerm;
        int a = color >> 24 & 0xFF;
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        buffer.m_85982_(ms.m_85850_().m_85861_(), x, y, z).m_6122_(r, g, b, a);
        switch (dir.m_122434_().m_122480_()) {
            case HORIZONTAL: {
                buffer.m_85977_(ms.m_85850_().m_85864_(), 0.0f, 1.0f, 0.0f);
                break;
            }
            case VERTICAL: {
                buffer.m_85977_(ms.m_85850_().m_85864_(), 1.0f, 0.0f, 0.0f);
            }
        }
        buffer.m_5752_();
    }

    private static int killNonZero(int diff) {
        if (diff != 0) {
            return 0;
        }
        return 1;
    }
}

