/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.integration.jei;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiFluidStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.fluids.FluidStack;
import vazkii.botania.api.recipe.IPureDaisyRecipe;
import vazkii.botania.api.recipe.StateIngredient;
import vazkii.botania.common.block.ModSubtiles;
import vazkii.botania.common.lib.ResourceLocationHelper;

public class PureDaisyRecipeCategory
implements IRecipeCategory<IPureDaisyRecipe> {
    public static final ResourceLocation UID = ResourceLocationHelper.prefix("pure_daisy");
    private final IDrawable background;
    private final Component localizedName;
    private final IDrawable overlay;
    private final IDrawable icon;

    public PureDaisyRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createBlankDrawable(96, 44);
        this.localizedName = new TranslatableComponent("botania.nei.pureDaisy");
        this.overlay = guiHelper.createDrawable(ResourceLocationHelper.prefix("textures/gui/pure_daisy_overlay.png"), 0, 0, 64, 44);
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((ItemLike)ModSubtiles.pureDaisy));
    }

    @Nonnull
    public ResourceLocation getUid() {
        return UID;
    }

    @Nonnull
    public Class<? extends IPureDaisyRecipe> getRecipeClass() {
        return IPureDaisyRecipe.class;
    }

    @Nonnull
    public Component getTitle() {
        return this.localizedName;
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    @Nonnull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(IPureDaisyRecipe recipe, IIngredients iIngredients) {
        StateIngredient input = recipe.getInput();
        if (input.getDisplayedStacks().size() > 1) {
            iIngredients.setInputLists(VanillaTypes.ITEM, Collections.singletonList(input.getDisplayedStacks()));
        } else {
            BlockState state = input.getDisplayed().get(0);
            Block b = state.m_60734_();
            if (!state.m_60819_().m_76178_()) {
                iIngredients.setInput(VanillaTypes.FLUID, (Object)new FluidStack(state.m_60819_().m_76152_(), 1000));
            } else if (b.m_5456_() != Items.f_41852_) {
                iIngredients.setInput(VanillaTypes.ITEM, (Object)new ItemStack((ItemLike)b));
            }
        }
        Block outBlock = recipe.getOutputState().m_60734_();
        FluidState outFluid = outBlock.m_49966_().m_60819_();
        if (!outFluid.m_76178_()) {
            iIngredients.setOutput(VanillaTypes.FLUID, (Object)new FluidStack(outFluid.m_76152_(), 1000));
        } else if (outBlock.m_5456_() != Items.f_41852_) {
            iIngredients.setOutput(VanillaTypes.ITEM, (Object)new ItemStack((ItemLike)outBlock));
        }
    }

    public void draw(IPureDaisyRecipe recipe, PoseStack ms, double mouseX, double mouseY) {
        RenderSystem.m_69478_();
        this.overlay.draw(ms, 17, 0);
        RenderSystem.m_69461_();
    }

    public void setRecipe(@Nonnull IRecipeLayout recipeLayout, @Nonnull IPureDaisyRecipe recipe, @Nonnull IIngredients ingredients) {
        List<Component> description;
        boolean outputFluid;
        boolean inputFluid = !ingredients.getInputs(VanillaTypes.FLUID).isEmpty();
        boolean bl = outputFluid = !ingredients.getOutputs(VanillaTypes.FLUID).isEmpty();
        if (inputFluid) {
            recipeLayout.getFluidStacks().init(0, true, 9, 12, 16, 16, 1000, false, null);
            recipeLayout.getFluidStacks().set(0, (List)ingredients.getInputs(VanillaTypes.FLUID).get(0));
        } else {
            recipeLayout.getItemStacks().init(0, true, 9, 12);
            recipeLayout.getItemStacks().set(0, (List)ingredients.getInputs(VanillaTypes.ITEM).get(0));
        }
        recipeLayout.getItemStacks().init(1, true, 39, 12);
        recipeLayout.getItemStacks().set(1, new ItemStack((ItemLike)ModSubtiles.pureDaisy));
        if (outputFluid) {
            recipeLayout.getFluidStacks().init(2, false, 68, 12, 16, 16, 1000, false, null);
            recipeLayout.getFluidStacks().set(2, (List)ingredients.getOutputs(VanillaTypes.FLUID).get(0));
        } else {
            recipeLayout.getItemStacks().init(2, false, 68, 12);
            recipeLayout.getItemStacks().set(2, (List)ingredients.getOutputs(VanillaTypes.ITEM).get(0));
        }
        IGuiFluidStackGroup group = outputFluid ? recipeLayout.getFluidStacks() : recipeLayout.getItemStacks();
        StateIngredient catalyst = recipe.getInput();
        if (catalyst != null && !(description = catalyst.descriptionTooltip()).isEmpty()) {
            group.addTooltipCallback((slotIndex, input, ingredient, tooltip) -> {
                if (slotIndex == 0) {
                    tooltip.addAll(description);
                }
            });
        }
    }
}

