/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.integration.jei;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import vazkii.botania.api.recipe.IManaInfusionRecipe;
import vazkii.botania.api.recipe.StateIngredient;
import vazkii.botania.client.gui.HUDHandler;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.common.lib.ResourceLocationHelper;

public class ManaPoolRecipeCategory
implements IRecipeCategory<IManaInfusionRecipe> {
    public static final ResourceLocation UID = ResourceLocationHelper.prefix("mana_pool");
    private final IDrawable background;
    private final Component localizedName;
    private final IDrawable overlay;
    private final IDrawable icon;
    private final ItemStack renderStack = new ItemStack((ItemLike)ModBlocks.manaPool);

    public ManaPoolRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createBlankDrawable(142, 55);
        this.localizedName = new TranslatableComponent("botania.nei.manaPool");
        this.overlay = guiHelper.createDrawable(ResourceLocationHelper.prefix("textures/gui/pure_daisy_overlay.png"), 0, 0, 64, 46);
        ItemNBTHelper.setBoolean(this.renderStack, "RenderFull", true);
        this.icon = guiHelper.createDrawableIngredient((Object)this.renderStack.m_41777_());
    }

    @Nonnull
    public ResourceLocation getUid() {
        return UID;
    }

    @Nonnull
    public Class<? extends IManaInfusionRecipe> getRecipeClass() {
        return IManaInfusionRecipe.class;
    }

    @Nonnull
    public Component getTitle() {
        return this.localizedName;
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    @Nonnull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(IManaInfusionRecipe recipe, IIngredients iIngredients) {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add(Arrays.asList(((Ingredient)recipe.m_7527_().get(0)).m_43908_()));
        if (recipe.getRecipeCatalyst() != null) {
            builder.add((Object)ImmutableList.copyOf(recipe.getRecipeCatalyst().getDisplayedStacks()));
        }
        iIngredients.setInputLists(VanillaTypes.ITEM, (List)builder.build());
        iIngredients.setOutput(VanillaTypes.ITEM, (Object)recipe.m_8043_());
    }

    public void draw(IManaInfusionRecipe recipe, PoseStack ms, double mouseX, double mouseY) {
        RenderSystem.m_69478_();
        this.overlay.draw(ms, 40, 0);
        HUDHandler.renderManaBar(ms, 20, 50, 255, 0.75f, recipe.getManaToConsume(), 100000);
        RenderSystem.m_69461_();
    }

    public void setRecipe(@Nonnull IRecipeLayout recipeLayout, @Nonnull IManaInfusionRecipe recipe, @Nonnull IIngredients ingredients) {
        List<Component> description;
        int index = 0;
        recipeLayout.getItemStacks().init(index, true, 32, 12);
        recipeLayout.getItemStacks().set(index, (List)ingredients.getInputs(VanillaTypes.ITEM).get(0));
        ++index;
        if (ingredients.getInputs(VanillaTypes.ITEM).size() > 1) {
            recipeLayout.getItemStacks().init(index, true, 12, 12);
            recipeLayout.getItemStacks().set(index, (List)ingredients.getInputs(VanillaTypes.ITEM).get(1));
            ++index;
        }
        recipeLayout.getItemStacks().init(index, true, 62, 12);
        recipeLayout.getItemStacks().set(index, this.renderStack);
        recipeLayout.getItemStacks().init(++index, false, 93, 12);
        recipeLayout.getItemStacks().set(index, (List)ingredients.getOutputs(VanillaTypes.ITEM).get(0));
        StateIngredient catalyst = recipe.getRecipeCatalyst();
        if (catalyst != null && !(description = catalyst.descriptionTooltip()).isEmpty()) {
            recipeLayout.getItemStacks().addTooltipCallback((slotIndex, input, ingredient, tooltip) -> {
                if (slotIndex == 1) {
                    tooltip.addAll(description);
                }
            });
        }
    }
}

