/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.fx;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.tuple.Pair;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.client.fx.BoltParticleOptions;

public class BoltRenderer {
    public static final BoltRenderer INSTANCE = new BoltRenderer();
    private static final float REFRESH_TIME = 3.0f;
    private static final double MAX_OWNER_TRACK_TIME = 100.0;
    private Timestamp refreshTimestamp = Timestamp.ZERO;
    private final Random random = new Random();
    private final Minecraft minecraft = Minecraft.m_91087_();
    private final List<BoltOwnerData> boltOwners = new LinkedList<BoltOwnerData>();

    public static void onWorldRenderLast(float partialTicks, PoseStack ps) {
        ps.m_85836_();
        Vec3 camVec = BoltRenderer.INSTANCE.minecraft.f_91063_.m_109153_().m_90583_();
        ps.m_85837_(-camVec.f_82479_, -camVec.f_82480_, -camVec.f_82481_);
        MultiBufferSource.BufferSource buffers = BoltRenderer.INSTANCE.minecraft.m_91269_().m_110104_();
        INSTANCE.render(partialTicks, ps, (MultiBufferSource)buffers);
        buffers.m_109912_(RenderHelper.LIGHTNING);
        ps.m_85849_();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(float partialTicks, PoseStack matrixStack, MultiBufferSource buffers) {
        VertexConsumer buffer = buffers.m_6299_(RenderHelper.LIGHTNING);
        Matrix4f matrix = matrixStack.m_85850_().m_85861_();
        Timestamp timestamp = new Timestamp(this.minecraft.f_91073_.m_46467_(), partialTicks);
        boolean refresh = timestamp.isPassed(this.refreshTimestamp, 0.3333333432674408);
        if (refresh) {
            this.refreshTimestamp = timestamp;
        }
        List<BoltOwnerData> list = this.boltOwners;
        synchronized (list) {
            Iterator<BoltOwnerData> iter = this.boltOwners.iterator();
            while (iter.hasNext()) {
                BoltOwnerData data = iter.next();
                data.renderTick(timestamp, refresh, matrix, buffer);
                if (!data.shouldRemove(timestamp)) continue;
                iter.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(BoltParticleOptions newBoltData, float partialTicks) {
        if (this.minecraft.f_91073_ == null) {
            return;
        }
        BoltOwnerData data = new BoltOwnerData();
        data.lastBolt = newBoltData;
        Timestamp timestamp = new Timestamp(this.minecraft.f_91073_.m_46467_(), partialTicks);
        if ((!data.lastBolt.getSpawnFunction().isConsecutive() || data.bolts.isEmpty()) && timestamp.isPassed(data.lastBoltTimestamp, data.lastBoltDelay)) {
            data.addBolt(new BoltInstance(newBoltData, timestamp), timestamp);
        }
        data.lastUpdateTimestamp = timestamp;
        List<BoltOwnerData> list = this.boltOwners;
        synchronized (list) {
            this.boltOwners.add(data);
        }
    }

    private static class Timestamp {
        public static final Timestamp ZERO = new Timestamp(0L, 0.0f);
        private final long ticks;
        private final float partial;

        public Timestamp(long ticks, float partial) {
            this.ticks = ticks;
            this.partial = partial;
        }

        public Timestamp subtract(Timestamp other) {
            long newTicks = this.ticks - other.ticks;
            float newPartial = this.partial - other.partial;
            if (newPartial < 0.0f) {
                newPartial += 1.0f;
                --newTicks;
            }
            return new Timestamp(newTicks, newPartial);
        }

        public float value() {
            return (float)this.ticks + this.partial;
        }

        public boolean isPassed(Timestamp prev, double duration) {
            long ticksPassed = this.ticks - prev.ticks;
            if ((double)ticksPassed > duration) {
                return true;
            }
            if ((duration -= (double)ticksPassed) >= 1.0) {
                return false;
            }
            return (double)(this.partial - prev.partial) >= duration;
        }
    }

    public class BoltOwnerData {
        private final Set<BoltInstance> bolts = new ObjectOpenHashSet();
        private BoltParticleOptions lastBolt;
        private Timestamp lastBoltTimestamp = Timestamp.ZERO;
        private Timestamp lastUpdateTimestamp = Timestamp.ZERO;
        private double lastBoltDelay;

        private void addBolt(BoltInstance instance, Timestamp timestamp) {
            this.bolts.add(instance);
            this.lastBoltDelay = instance.bolt.getSpawnFunction().getSpawnDelay(BoltRenderer.this.random);
            this.lastBoltTimestamp = timestamp;
        }

        public void renderTick(Timestamp timestamp, boolean refresh, Matrix4f matrix, VertexConsumer buffer) {
            if (refresh) {
                this.bolts.removeIf(bolt -> bolt.tick(timestamp));
            }
            if (this.bolts.isEmpty() && this.lastBolt != null && this.lastBolt.getSpawnFunction().isConsecutive()) {
                this.addBolt(new BoltInstance(this.lastBolt, timestamp), timestamp);
            }
            this.bolts.forEach(bolt -> bolt.render(matrix, buffer, timestamp));
        }

        public boolean shouldRemove(Timestamp timestamp) {
            return this.bolts.isEmpty() && timestamp.isPassed(this.lastUpdateTimestamp, 100.0);
        }
    }

    private static class BoltInstance {
        private final BoltParticleOptions bolt;
        private final List<BoltParticleOptions.BoltQuads> renderQuads;
        private final Timestamp createdTimestamp;

        public BoltInstance(BoltParticleOptions bolt, Timestamp timestamp) {
            this.bolt = bolt;
            this.renderQuads = bolt.generate();
            this.createdTimestamp = timestamp;
        }

        public void render(Matrix4f matrix, VertexConsumer buffer, Timestamp timestamp) {
            float lifeScale = timestamp.subtract(this.createdTimestamp).value() / (float)this.bolt.getLifespan();
            Pair<Integer, Integer> bounds = this.bolt.getFadeFunction().getRenderBounds(this.renderQuads.size(), lifeScale);
            for (int i = ((Integer)bounds.getLeft()).intValue(); i < (Integer)bounds.getRight(); ++i) {
                this.renderQuads.get(i).getVecs().forEach(v -> buffer.m_85982_(matrix, (float)v.f_82479_, (float)v.f_82480_, (float)v.f_82481_).m_85950_(this.bolt.getColor().m_123601_(), this.bolt.getColor().m_123615_(), this.bolt.getColor().m_123616_(), this.bolt.getColor().m_123617_()).m_5752_());
            }
        }

        public boolean tick(Timestamp timestamp) {
            return timestamp.isPassed(this.createdTimestamp, this.bolt.getLifespan());
        }
    }
}

