/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.api.mana;

import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import vazkii.botania.api.mana.IManaItem;

public class ManaBarTooltip
implements TooltipComponent {
    private final float percentageFull;
    private final int pickLevel;

    public static ManaBarTooltip fromManaItem(ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof IManaItem) {
            IManaItem item2 = (IManaItem)item;
            return new ManaBarTooltip(ManaBarTooltip.getFractionForDisplay(item2, stack));
        }
        throw new IllegalArgumentException("Item is not an instance of " + IManaItem.class.getName());
    }

    public static float getFractionForDisplay(IManaItem item, ItemStack stack) {
        return (float)item.getMana(stack) / (float)item.getMaxMana(stack);
    }

    public ManaBarTooltip(float percentageFull) {
        this(percentageFull, -1);
    }

    public ManaBarTooltip(float percentageFull, int pickLevel) {
        this.percentageFull = percentageFull;
        this.pickLevel = pickLevel;
    }

    public float getPercentageFull() {
        return this.percentageFull;
    }

    public int getPickLevel() {
        return this.pickLevel;
    }
}

