/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.data.recipes;

import com.google.gson.JsonObject;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.data.RecipeProvider;
import net.minecraft.data.SingleItemRecipeBuilder;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.DefaultedRegistry;
import net.minecraft.util.registry.Registry;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.ModFluffBlocks;
import vazkii.botania.common.lib.LibBlockNames;
import vazkii.botania.common.lib.ResourceLocationHelper;

public class StonecuttingProvider
extends RecipeProvider {
    public StonecuttingProvider(DataGenerator generator) {
        super(generator);
    }

    protected void func_200404_a(Consumer<IFinishedRecipe> consumer) {
        for (String variant : LibBlockNames.METAMORPHIC_VARIANTS) {
            StonecuttingProvider.registerForMetamorphic(variant, consumer);
        }
        for (String color : LibBlockNames.PAVEMENT_VARIANTS) {
            StonecuttingProvider.registerForPavement(color, consumer);
        }
        for (String variant : LibBlockNames.QUARTZ_VARIANTS) {
            StonecuttingProvider.registerForQuartz(variant, consumer);
        }
        consumer.accept(StonecuttingProvider.stonecutting((IItemProvider)ModBlocks.shimmerrock, (IItemProvider)ModFluffBlocks.shimmerrockSlab, 2));
        consumer.accept(StonecuttingProvider.stonecutting((IItemProvider)ModBlocks.shimmerrock, (IItemProvider)ModFluffBlocks.shimmerrockStairs));
        consumer.accept(StonecuttingProvider.stonecutting((IItemProvider)ModBlocks.livingrock, (IItemProvider)ModFluffBlocks.livingrockSlab, 2));
        consumer.accept(StonecuttingProvider.stonecutting((IItemProvider)ModBlocks.livingrock, (IItemProvider)ModFluffBlocks.livingrockStairs));
        consumer.accept(StonecuttingProvider.stonecutting((IItemProvider)ModBlocks.livingrock, (IItemProvider)ModFluffBlocks.livingrockWall));
        consumer.accept(StonecuttingProvider.stonecutting((IItemProvider)ModBlocks.livingrock, (IItemProvider)ModBlocks.livingrockBrick));
        consumer.accept(StonecuttingProvider.stonecutting((IItemProvider)ModBlocks.livingrock, (IItemProvider)ModFluffBlocks.livingrockBrickSlab, 2));
        consumer.accept(StonecuttingProvider.stonecutting((IItemProvider)ModBlocks.livingrock, (IItemProvider)ModFluffBlocks.livingrockBrickStairs));
        consumer.accept(StonecuttingProvider.stonecutting((IItemProvider)ModBlocks.livingrock, (IItemProvider)ModFluffBlocks.livingrockBrickWall));
        consumer.accept(StonecuttingProvider.stonecutting((IItemProvider)ModBlocks.livingrock, (IItemProvider)ModBlocks.livingrockBrickChiseled));
        consumer.accept(StonecuttingProvider.stonecutting((IItemProvider)ModBlocks.livingrockBrick, (IItemProvider)ModFluffBlocks.livingrockBrickSlab, 2));
        consumer.accept(StonecuttingProvider.stonecutting((IItemProvider)ModBlocks.livingrockBrick, (IItemProvider)ModFluffBlocks.livingrockBrickStairs));
        consumer.accept(StonecuttingProvider.stonecutting((IItemProvider)ModBlocks.livingrockBrick, (IItemProvider)ModFluffBlocks.livingrockBrickWall));
        consumer.accept(StonecuttingProvider.stonecutting((IItemProvider)ModBlocks.livingrockBrick, (IItemProvider)ModBlocks.livingrockBrickChiseled));
        consumer.accept(StonecuttingProvider.stonecutting((IItemProvider)ModBlocks.livingrockBrickMossy, (IItemProvider)ModFluffBlocks.livingrockBrickMossySlab, 2));
        consumer.accept(StonecuttingProvider.stonecutting((IItemProvider)ModBlocks.livingrockBrickMossy, (IItemProvider)ModFluffBlocks.livingrockBrickMossyStairs));
        consumer.accept(StonecuttingProvider.stonecutting((IItemProvider)ModBlocks.livingrockBrickMossy, (IItemProvider)ModFluffBlocks.livingrockBrickMossyWall));
        consumer.accept(StonecuttingProvider.stonecutting((IItemProvider)ModBlocks.corporeaBlock, (IItemProvider)ModBlocks.corporeaSlab, 2));
        consumer.accept(StonecuttingProvider.stonecutting((IItemProvider)ModBlocks.corporeaBlock, (IItemProvider)ModBlocks.corporeaStairs));
        consumer.accept(StonecuttingProvider.stonecutting((IItemProvider)ModBlocks.corporeaBlock, (IItemProvider)ModBlocks.corporeaBrick));
        consumer.accept(StonecuttingProvider.stonecutting((IItemProvider)ModBlocks.corporeaBlock, (IItemProvider)ModBlocks.corporeaBrickSlab, 2));
        consumer.accept(StonecuttingProvider.stonecutting((IItemProvider)ModBlocks.corporeaBlock, (IItemProvider)ModBlocks.corporeaBrickStairs));
        consumer.accept(StonecuttingProvider.stonecutting((IItemProvider)ModBlocks.corporeaBlock, (IItemProvider)ModBlocks.corporeaBrickWall));
        consumer.accept(StonecuttingProvider.stonecutting((IItemProvider)ModBlocks.corporeaBrick, (IItemProvider)ModBlocks.corporeaBrickSlab, 2));
        consumer.accept(StonecuttingProvider.stonecutting((IItemProvider)ModBlocks.corporeaBrick, (IItemProvider)ModBlocks.corporeaBrickStairs));
        consumer.accept(StonecuttingProvider.stonecutting((IItemProvider)ModBlocks.corporeaBrick, (IItemProvider)ModBlocks.corporeaBrickWall));
        List allAzulejos = IntStream.range(0, 16).mapToObj(i -> "azulejo_" + i).map(ResourceLocationHelper::prefix).map(arg_0 -> ((DefaultedRegistry)Registry.field_212630_s).func_241873_b(arg_0)).map(Optional::get).collect(Collectors.toList());
        for (Item azulejo : allAzulejos) {
            consumer.accept(StonecuttingProvider.azulejoStonecutting(allAzulejos, (IItemProvider)azulejo));
        }
    }

    private static void registerForQuartz(String variant, Consumer<IFinishedRecipe> consumer) {
        Block base = (Block)Registry.field_212618_g.func_241873_b(ResourceLocationHelper.prefix(variant)).get();
        Block slab = (Block)Registry.field_212618_g.func_241873_b(ResourceLocationHelper.prefix(variant + "_slab")).get();
        Block stairs = (Block)Registry.field_212618_g.func_241873_b(ResourceLocationHelper.prefix(variant + "_stairs")).get();
        Block chiseled = (Block)Registry.field_212618_g.func_241873_b(ResourceLocationHelper.prefix("chiseled_" + variant)).get();
        Block pillar = (Block)Registry.field_212618_g.func_241873_b(ResourceLocationHelper.prefix(variant + "_pillar")).get();
        consumer.accept(StonecuttingProvider.stonecutting((IItemProvider)base, (IItemProvider)slab, 2));
        consumer.accept(StonecuttingProvider.stonecutting((IItemProvider)base, (IItemProvider)stairs));
        consumer.accept(StonecuttingProvider.stonecutting((IItemProvider)base, (IItemProvider)chiseled));
        consumer.accept(StonecuttingProvider.stonecutting((IItemProvider)base, (IItemProvider)pillar));
    }

    private static void registerForPavement(String color, Consumer<IFinishedRecipe> consumer) {
        Block base = (Block)Registry.field_212618_g.func_241873_b(ResourceLocationHelper.prefix(color + "_pavement")).get();
        Block slab = (Block)Registry.field_212618_g.func_241873_b(ResourceLocationHelper.prefix(color + "_pavement" + "_slab")).get();
        Block stair = (Block)Registry.field_212618_g.func_241873_b(ResourceLocationHelper.prefix(color + "_pavement" + "_stairs")).get();
        consumer.accept(StonecuttingProvider.stonecutting((IItemProvider)base, (IItemProvider)slab, 2));
        consumer.accept(StonecuttingProvider.stonecutting((IItemProvider)base, (IItemProvider)stair));
    }

    private static void registerForMetamorphic(String variant, Consumer<IFinishedRecipe> consumer) {
        Block base = (Block)Registry.field_212618_g.func_241873_b(ResourceLocationHelper.prefix("metamorphic_" + variant + "_stone")).get();
        Block slab = (Block)Registry.field_212618_g.func_241873_b(ResourceLocationHelper.prefix("metamorphic_" + variant + "_stone" + "_slab")).get();
        Block stair = (Block)Registry.field_212618_g.func_241873_b(ResourceLocationHelper.prefix("metamorphic_" + variant + "_stone" + "_stairs")).get();
        Block brick = (Block)Registry.field_212618_g.func_241873_b(ResourceLocationHelper.prefix("metamorphic_" + variant + "_bricks")).get();
        Block brickSlab = (Block)Registry.field_212618_g.func_241873_b(ResourceLocationHelper.prefix("metamorphic_" + variant + "_bricks" + "_slab")).get();
        Block brickStair = (Block)Registry.field_212618_g.func_241873_b(ResourceLocationHelper.prefix("metamorphic_" + variant + "_bricks" + "_stairs")).get();
        Block brickWall = (Block)Registry.field_212618_g.func_241873_b(ResourceLocationHelper.prefix("metamorphic_" + variant + "_bricks" + "_wall")).get();
        Block chiseledBrick = (Block)Registry.field_212618_g.func_241873_b(ResourceLocationHelper.prefix("chiseled_metamorphic_" + variant + "_bricks")).get();
        Block cobble = (Block)Registry.field_212618_g.func_241873_b(ResourceLocationHelper.prefix("metamorphic_" + variant + "_cobblestone")).get();
        Block cobbleSlab = (Block)Registry.field_212618_g.func_241873_b(ResourceLocationHelper.prefix("metamorphic_" + variant + "_cobblestone" + "_slab")).get();
        Block cobbleStair = (Block)Registry.field_212618_g.func_241873_b(ResourceLocationHelper.prefix("metamorphic_" + variant + "_cobblestone" + "_stairs")).get();
        Block cobbleWall = (Block)Registry.field_212618_g.func_241873_b(ResourceLocationHelper.prefix("metamorphic_" + variant + "_cobblestone" + "_wall")).get();
        consumer.accept(StonecuttingProvider.stonecutting((IItemProvider)base, (IItemProvider)slab, 2));
        consumer.accept(StonecuttingProvider.stonecutting((IItemProvider)base, (IItemProvider)stair));
        consumer.accept(StonecuttingProvider.stonecutting((IItemProvider)base, (IItemProvider)brick));
        consumer.accept(StonecuttingProvider.stonecutting((IItemProvider)base, (IItemProvider)brickSlab, 2));
        consumer.accept(StonecuttingProvider.stonecutting((IItemProvider)base, (IItemProvider)brickStair));
        consumer.accept(StonecuttingProvider.stonecutting((IItemProvider)base, (IItemProvider)brickWall));
        consumer.accept(StonecuttingProvider.stonecutting((IItemProvider)base, (IItemProvider)chiseledBrick));
        consumer.accept(StonecuttingProvider.stonecutting((IItemProvider)brick, (IItemProvider)brickSlab, 2));
        consumer.accept(StonecuttingProvider.stonecutting((IItemProvider)brick, (IItemProvider)brickStair));
        consumer.accept(StonecuttingProvider.stonecutting((IItemProvider)brick, (IItemProvider)brickWall));
        consumer.accept(StonecuttingProvider.stonecutting((IItemProvider)brick, (IItemProvider)chiseledBrick));
        consumer.accept(StonecuttingProvider.stonecutting((IItemProvider)cobble, (IItemProvider)cobbleSlab, 2));
        consumer.accept(StonecuttingProvider.stonecutting((IItemProvider)cobble, (IItemProvider)cobbleStair));
        consumer.accept(StonecuttingProvider.stonecutting((IItemProvider)cobble, (IItemProvider)cobbleWall));
    }

    @Nonnull
    public String func_200397_b() {
        return "Botania stonecutting recipes";
    }

    private static ResourceLocation idFor(IItemProvider a, IItemProvider b) {
        ResourceLocation aId = Registry.field_212630_s.func_177774_c((Object)a.func_199767_j());
        ResourceLocation bId = Registry.field_212630_s.func_177774_c((Object)b.func_199767_j());
        return ResourceLocationHelper.prefix("stonecutting/" + aId.func_110623_a() + "_to_" + bId.func_110623_a());
    }

    private static IFinishedRecipe stonecutting(IItemProvider input, IItemProvider output) {
        return StonecuttingProvider.stonecutting(input, output, 1);
    }

    private static IFinishedRecipe stonecutting(IItemProvider input, IItemProvider output, int count) {
        return new Result(StonecuttingProvider.idFor(input, output), IRecipeSerializer.field_222175_s, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{input}), output.func_199767_j(), count);
    }

    private static IFinishedRecipe azulejoStonecutting(List<? extends IItemProvider> inputs, IItemProvider output) {
        Ingredient input = Ingredient.func_199804_a((IItemProvider[])((IItemProvider[])inputs.stream().filter(obj -> output != obj).toArray(IItemProvider[]::new)));
        return new Result(ResourceLocationHelper.prefix("stonecutting/" + Registry.field_212630_s.func_177774_c((Object)output.func_199767_j()).func_110623_a()), IRecipeSerializer.field_222175_s, input, output.func_199767_j(), 1);
    }

    public static class Result
    extends SingleItemRecipeBuilder.Result {
        public Result(ResourceLocation id, IRecipeSerializer<?> serializer, Ingredient input, Item result, int count) {
            super(id, serializer, "", input, result, count, null, null);
        }

        @Nullable
        public JsonObject func_200440_c() {
            return null;
        }

        @Nullable
        public ResourceLocation func_200443_d() {
            return null;
        }
    }
}

