/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.integration.crafttweaker.actions;

import com.blamejared.crafttweaker.api.exceptions.ScriptException;
import com.blamejared.crafttweaker.api.logger.ILogger;
import com.blamejared.crafttweaker.api.managers.IRecipeManager;
import com.blamejared.crafttweaker.impl.actions.recipes.ActionRecipeBase;
import java.util.Iterator;
import net.minecraft.block.BlockState;
import net.minecraft.util.registry.Registry;
import vazkii.botania.api.recipe.IPureDaisyRecipe;
import vazkii.botania.api.recipe.StateIngredient;
import vazkii.botania.common.crafting.StateIngredientHelper;

public class ActionRemovePureDaisyRecipe
extends ActionRecipeBase {
    private final BlockState output;

    public ActionRemovePureDaisyRecipe(IRecipeManager manager, BlockState output) {
        super(manager);
        this.output = output;
    }

    public void apply() {
        StateIngredient state = StateIngredientHelper.of(this.output);
        Iterator iter = this.getManager().getRecipes().entrySet().iterator();
        while (iter.hasNext()) {
            IPureDaisyRecipe recipe = (IPureDaisyRecipe)iter.next().getValue();
            if (!state.test(recipe.getOutputState())) continue;
            iter.remove();
        }
    }

    public String describe() {
        return "Removing \"" + Registry.field_218367_H.func_177774_c((Object)this.getManager().getRecipeType()) + "\" recipes with output: " + this.output + "\"";
    }

    public boolean validate(ILogger logger) {
        if (this.output == null) {
            logger.throwingWarn("output cannot be null!", (Throwable)new ScriptException("output MCBlockState cannot be null!"));
            return false;
        }
        return true;
    }
}

