/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.render.entity;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Atlases;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3f;
import vazkii.botania.client.core.handler.MiscellaneousIcons;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.common.entity.EntityBabylonWeapon;

public class RenderBabylonWeapon
extends EntityRenderer<EntityBabylonWeapon> {
    public RenderBabylonWeapon(EntityRendererManager renderManager) {
        super(renderManager);
    }

    public void render(@Nonnull EntityBabylonWeapon weapon, float yaw, float partialTicks, MatrixStack ms, IRenderTypeBuffer buffers, int light) {
        ms.func_227860_a_();
        ms.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(weapon.getRotation()));
        int live = weapon.getLiveTicks();
        int delay = weapon.getDelay();
        float charge = Math.min(10.0f, (float)Math.max(live, weapon.getChargeTicks()) + partialTicks);
        float chargeMul = charge / 10.0f;
        ms.func_227860_a_();
        ms.func_227861_a_(-0.75, 0.0, 1.0);
        float s = 1.5f;
        ms.func_227862_a_(s, s, s);
        ms.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(90.0f));
        ms.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(-45.0f));
        IBakedModel model = MiscellaneousIcons.INSTANCE.kingKeyWeaponModels[weapon.getVariety()];
        Minecraft.func_71410_x().func_175602_ab().func_175019_b().func_228804_a_(ms.func_227866_c_(), buffers.getBuffer(Atlases.func_239280_i_()), null, model, 1.0f, 1.0f, 1.0f, 0xF000F0, OverlayTexture.field_229196_a_);
        ms.func_227865_b_();
        Random rand = new Random(weapon.func_110124_au().getMostSignificantBits());
        ms.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(-90.0f));
        ms.func_227861_a_(0.0, (double)(-0.3f + rand.nextFloat() * 0.1f), 0.0);
        s = chargeMul;
        if (live > delay) {
            s -= Math.min(1.0f, ((float)(live - delay) + partialTicks) * 0.2f);
        }
        ms.func_227862_a_(s *= 2.0f, s, s);
        ms.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(charge * 9.0f + ((float)weapon.field_70173_aa + partialTicks) * 0.5f + rand.nextFloat() * 360.0f));
        IVertexBuilder buffer = buffers.getBuffer(RenderHelper.BABYLON_ICON);
        Matrix4f mat = ms.func_227866_c_().func_227870_a_();
        buffer.func_227888_a_(mat, -1.0f, 0.0f, -1.0f).func_227885_a_(1.0f, 1.0f, 1.0f, chargeMul).func_225583_a_(0.0f, 0.0f).func_181675_d();
        buffer.func_227888_a_(mat, -1.0f, 0.0f, 1.0f).func_227885_a_(1.0f, 1.0f, 1.0f, chargeMul).func_225583_a_(0.0f, 1.0f).func_181675_d();
        buffer.func_227888_a_(mat, 1.0f, 0.0f, 1.0f).func_227885_a_(1.0f, 1.0f, 1.0f, chargeMul).func_225583_a_(1.0f, 1.0f).func_181675_d();
        buffer.func_227888_a_(mat, 1.0f, 0.0f, -1.0f).func_227885_a_(1.0f, 1.0f, 1.0f, chargeMul).func_225583_a_(1.0f, 0.0f).func_181675_d();
        ms.func_227865_b_();
    }

    @Nonnull
    public ResourceLocation getEntityTexture(@Nonnull EntityBabylonWeapon entity) {
        return AtlasTexture.field_110575_b;
    }
}

