/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.rod;

import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import vazkii.botania.api.item.IAvatarTile;
import vazkii.botania.api.item.IAvatarWieldable;
import vazkii.botania.api.item.IManaProficiencyArmor;
import vazkii.botania.api.mana.IManaUsingItem;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.common.entity.EntityFlameRing;
import vazkii.botania.common.entity.ModEntities;

public class ItemFireRod
extends Item
implements IManaUsingItem,
IAvatarWieldable {
    private static final ResourceLocation avatarOverlay = new ResourceLocation("botania:textures/model/avatar_fire.png");
    private static final int COST = 900;
    private static final int COOLDOWN = 1200;

    public ItemFireRod(Item.Properties props) {
        super(props);
    }

    @Nonnull
    public ActionResultType func_195939_a(ItemUseContext ctx) {
        World world = ctx.func_195991_k();
        PlayerEntity player = ctx.func_195999_j();
        ItemStack stack = ctx.func_195996_i();
        BlockPos pos = ctx.func_195995_a();
        if (!world.field_72995_K && player != null && ManaItemHandler.instance().requestManaExactForTool(stack, player, 900, false)) {
            EntityFlameRing entity = (EntityFlameRing)ModEntities.FLAME_RING.func_200721_a(world);
            entity.func_70107_b((double)pos.func_177958_n() + 0.5, pos.func_177956_o() + 1, (double)pos.func_177952_p() + 0.5);
            world.func_217376_c((Entity)entity);
            player.func_184811_cZ().func_185145_a((Item)this, IManaProficiencyArmor.hasProficiency(player, stack) ? 600 : 1200);
            ManaItemHandler.instance().requestManaExactForTool(stack, player, 900, true);
            ctx.func_195991_k().func_184148_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_187594_A, player != null ? SoundCategory.PLAYERS : SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
        return ActionResultType.SUCCESS;
    }

    @Override
    public boolean usesMana(ItemStack stack) {
        return true;
    }

    @Override
    public void onAvatarUpdate(IAvatarTile tile, ItemStack stack) {
        TileEntity te = tile.tileEntity();
        World world = te.func_145831_w();
        if (!world.field_72995_K && tile.getCurrentMana() >= 900 && tile.getElapsedFunctionalTicks() % 300 == 0 && tile.isEnabled()) {
            EntityFlameRing entity = (EntityFlameRing)ModEntities.FLAME_RING.func_200721_a(world);
            entity.func_70107_b((double)te.func_174877_v().func_177958_n() + 0.5, te.func_174877_v().func_177956_o(), (double)te.func_174877_v().func_177952_p() + 0.5);
            world.func_217376_c((Entity)entity);
            tile.receiveMana(-900);
        }
    }

    @Override
    public ResourceLocation getOverlayResource(IAvatarTile tile, ItemStack stack) {
        return avatarOverlay;
    }
}

