/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FallingBlock;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vazkii.botania.api.internal.IManaBurst;
import vazkii.botania.api.mana.BurstProperties;
import vazkii.botania.api.mana.ILaputaImmobile;
import vazkii.botania.api.mana.ILensEffect;
import vazkii.botania.api.mana.ITinyPlanetExcempt;
import vazkii.botania.common.advancements.UseItemSuccessTrigger;
import vazkii.botania.common.core.handler.ModSounds;
import vazkii.botania.common.core.helper.ItemNBTHelper;
import vazkii.botania.common.core.helper.MathHelper;
import vazkii.botania.common.entity.EntityManaBurst;
import vazkii.botania.common.entity.ModEntities;

public class ItemLaputaShard
extends Item
implements ILensEffect,
ITinyPlanetExcempt {
    private static final String TAG_STATE = "_state";
    private static final String TAG_TILE = "_tile";
    private static final String TAG_X = "_x";
    private static final String TAG_Y = "_y";
    private static final String TAG_Y_START = "_yStart";
    private static final String TAG_Z = "_z";
    private static final String TAG_POINTY = "_pointy";
    private static final String TAG_HEIGHTSCALE = "_heightscale";
    private static final String TAG_ITERATION_I = "iterationI";
    private static final String TAG_ITERATION_J = "iterationJ";
    private static final String TAG_ITERATION_K = "iterationK";
    public static final String TAG_LEVEL = "level";
    private static final int BASE_RANGE = 14;
    private static final int BASE_OFFSET = 42;

    public ItemLaputaShard(Item.Properties props) {
        super(props);
    }

    public void func_150895_a(@Nonnull ItemGroup tab, @Nonnull NonNullList<ItemStack> list) {
        if (this.func_194125_a(tab)) {
            for (int i = 0; i <= 20; i += 5) {
                ItemStack s = new ItemStack((IItemProvider)this);
                if (i != 0) {
                    s.func_196082_o().func_74768_a(TAG_LEVEL, i - 1);
                }
                list.add((Object)s);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> list, ITooltipFlag flags) {
        int level = ItemLaputaShard.getShardLevel(stack);
        TranslationTextComponent levelLoc = new TranslationTextComponent("botania.roman" + (level + 1));
        list.add((ITextComponent)new TranslationTextComponent("botaniamisc.shardLevel", new Object[]{levelLoc}).func_240699_a_(TextFormatting.GRAY));
        list.add((ITextComponent)new TranslationTextComponent("botaniamisc.shardRange", new Object[]{this.getRange(stack)}).func_240699_a_(TextFormatting.GRAY));
    }

    @Nonnull
    public ActionResultType func_195939_a(ItemUseContext ctx) {
        World world = ctx.func_195991_k();
        BlockPos pos = ctx.func_195995_a();
        if (!world.field_72995_K && pos.func_177956_o() < 160 && !world.func_230315_m_().func_236040_e_()) {
            world.func_184133_a(null, pos, ModSounds.laputaStart, SoundCategory.BLOCKS, 1.0f + world.field_73012_v.nextFloat(), world.field_73012_v.nextFloat() * 0.7f + 1.3f);
            ItemStack stack = ctx.func_195996_i();
            this.spawnFirstBurst(world, pos, stack);
            if (ctx.func_195999_j() != null) {
                UseItemSuccessTrigger.INSTANCE.trigger((ServerPlayerEntity)ctx.func_195999_j(), stack, (ServerWorld)world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            }
            stack.func_190918_g(1);
        }
        return ActionResultType.SUCCESS;
    }

    private int getRange(ItemStack shard) {
        return 14 + ItemLaputaShard.getShardLevel(shard);
    }

    protected void spawnFirstBurst(World world, BlockPos pos, ItemStack shard) {
        int range = this.getRange(shard);
        boolean pointy = world.field_73012_v.nextDouble() < 0.25;
        double heightscale = (world.field_73012_v.nextDouble() + 0.5) * (14.0 / (double)range);
        this.spawnNextBurst(world, pos, shard, pointy, heightscale);
    }

    protected void spawnNextBurst(World world, BlockPos pos, ItemStack lens) {
        boolean pointy = ItemNBTHelper.getBoolean(lens, TAG_POINTY, false);
        double heightscale = ItemNBTHelper.getDouble(lens, TAG_HEIGHTSCALE, 1.0);
        this.spawnNextBurst(world, pos, lens, pointy, heightscale);
    }

    private static boolean canMove(BlockState state, World world, BlockPos pos) {
        FluidState fluidState = state.func_204520_s();
        boolean isFlowingFluid = !fluidState.func_206888_e() && !fluidState.func_206889_d();
        Block block = state.func_177230_c();
        return !state.isAir((IBlockReader)world, pos) && !isFlowingFluid && !(block instanceof FallingBlock) && (!(block instanceof ILaputaImmobile) || ((ILaputaImmobile)block).canMove(world, pos)) && state.func_185887_b((IBlockReader)world, pos) != -1.0f;
    }

    private void spawnNextBurst(World world, BlockPos pos, ItemStack shard, boolean pointy, double heightscale) {
        int range = this.getRange(shard);
        int i = ItemNBTHelper.getInt(shard, TAG_ITERATION_I, 0);
        int j = ItemNBTHelper.getInt(shard, TAG_ITERATION_J, 35);
        int k = ItemNBTHelper.getInt(shard, TAG_ITERATION_K, 0);
        if (j <= -28) {
            j = 35;
        }
        if (k >= range * 2 + 1) {
            k = 0;
        }
        while (i < range * 2 + 1) {
            while (j > -28) {
                while (k < range * 2 + 1) {
                    BlockPos pos_ = pos.func_177982_a(-range + i, -14 + j, -range + k);
                    if (this.inRange(pos_, pos, range, heightscale, pointy)) {
                        BlockState state = world.func_180495_p(pos_);
                        Block block = state.func_177230_c();
                        if (ItemLaputaShard.canMove(state, world, pos_)) {
                            TileEntity tile = world.func_175625_s(pos_);
                            CompoundNBT cmp = new CompoundNBT();
                            if (tile != null) {
                                cmp = tile.func_189515_b(cmp);
                                world.func_175690_a(pos_, block.createTileEntity(state, (IBlockReader)world));
                            }
                            if (!world.func_175656_a(pos_, Blocks.field_150350_a.func_176223_P())) {
                                if (tile != null) {
                                    world.func_175690_a(pos_, tile);
                                }
                            } else {
                                world.func_217379_c(2001, pos_, Block.func_196246_j((BlockState)state));
                                ItemStack copyLens = new ItemStack((IItemProvider)this);
                                copyLens.func_196082_o().func_74768_a(TAG_LEVEL, ItemLaputaShard.getShardLevel(shard));
                                copyLens.func_77978_p().func_218657_a(TAG_STATE, (INBT)NBTUtil.func_190009_a((BlockState)state));
                                ItemNBTHelper.setCompound(copyLens, TAG_TILE, cmp);
                                ItemNBTHelper.setInt(copyLens, TAG_X, pos.func_177958_n());
                                ItemNBTHelper.setInt(copyLens, TAG_Y, pos.func_177956_o());
                                ItemNBTHelper.setInt(copyLens, TAG_Y_START, pos_.func_177956_o());
                                ItemNBTHelper.setInt(copyLens, TAG_Z, pos.func_177952_p());
                                ItemNBTHelper.setBoolean(copyLens, TAG_POINTY, pointy);
                                ItemNBTHelper.setDouble(copyLens, TAG_HEIGHTSCALE, heightscale);
                                ItemNBTHelper.setInt(copyLens, TAG_ITERATION_I, i);
                                ItemNBTHelper.setInt(copyLens, TAG_ITERATION_J, j);
                                ItemNBTHelper.setInt(copyLens, TAG_ITERATION_K, k);
                                EntityManaBurst burst = this.getBurst(world, pos_, copyLens);
                                world.func_217376_c((Entity)burst);
                                return;
                            }
                        }
                    }
                    ++k;
                }
                k = 0;
                --j;
            }
            j = 35;
            ++i;
        }
    }

    public static int getShardLevel(ItemStack shard) {
        if (!shard.func_77942_o()) {
            return 0;
        }
        return shard.func_196082_o().func_74762_e(TAG_LEVEL);
    }

    private boolean inRange(BlockPos pos, BlockPos srcPos, int range, double heightscale, boolean pointy) {
        if (pos.func_177956_o() >= srcPos.func_177956_o()) {
            return MathHelper.pointDistanceSpace(pos.func_177958_n(), 0.0, pos.func_177952_p(), srcPos.func_177958_n(), 0.0, srcPos.func_177952_p()) < (float)range;
        }
        if (!pointy) {
            return MathHelper.pointDistanceSpace(pos.func_177958_n(), (double)pos.func_177956_o() / heightscale, pos.func_177952_p(), srcPos.func_177958_n(), (double)srcPos.func_177956_o() / heightscale, srcPos.func_177952_p()) < (float)range;
        }
        return (double)MathHelper.pointDistanceSpace(pos.func_177958_n(), 0.0, pos.func_177952_p(), srcPos.func_177958_n(), 0.0, srcPos.func_177952_p()) < (double)range - (double)(srcPos.func_177956_o() - pos.func_177956_o()) / heightscale;
    }

    public EntityManaBurst getBurst(World world, BlockPos pos, ItemStack stack) {
        EntityManaBurst burst = (EntityManaBurst)ModEntities.MANA_BURST.func_200721_a(world);
        burst.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
        burst.setColor(60159);
        burst.setMana(1);
        burst.setStartingMana(1);
        burst.setMinManaLoss(0);
        burst.setManaLossPerTick(0.0f);
        burst.setGravity(0.0f);
        burst.setBurstMotion(0.0, 0.5, 0.0);
        burst.setSourceLens(stack);
        return burst;
    }

    @Override
    public void apply(ItemStack stack, BurstProperties props) {
    }

    @Override
    public boolean collideBurst(IManaBurst burst, RayTraceResult pos, boolean isManaBlock, boolean dead, ItemStack stack) {
        return false;
    }

    @Override
    public void updateBurst(IManaBurst burst, ItemStack stack) {
        double speed = 0.35;
        int targetDistance = 42;
        ThrowableEntity entity = burst.entity();
        if (!entity.field_70170_p.field_72995_K) {
            entity.func_213293_j(0.0, speed, 0.0);
            int spawnTicks = 2;
            int placeTicks = net.minecraft.util.math.MathHelper.func_76128_c((double)((double)targetDistance / speed));
            ItemStack lens = burst.getSourceLens();
            if (burst.getTicksExisted() == 2) {
                int x = ItemNBTHelper.getInt(lens, TAG_X, 0);
                int y = ItemNBTHelper.getInt(lens, TAG_Y, -1);
                int z = ItemNBTHelper.getInt(lens, TAG_Z, 0);
                if (y != -1) {
                    this.spawnNextBurst(entity.field_70170_p, new BlockPos(x, y, z), lens);
                }
            } else if (burst.getTicksExisted() == placeTicks) {
                int x = net.minecraft.util.math.MathHelper.func_76128_c((double)entity.func_226277_ct_());
                int y = ItemNBTHelper.getInt(lens, TAG_Y_START, -1) + targetDistance;
                int z = net.minecraft.util.math.MathHelper.func_76128_c((double)entity.func_226281_cx_());
                BlockPos pos = new BlockPos(x, y, z);
                BlockState placeState = Blocks.field_150350_a.func_176223_P();
                if (lens.func_77942_o() && lens.func_77978_p().func_74764_b(TAG_STATE)) {
                    placeState = NBTUtil.func_190008_d((CompoundNBT)lens.func_77978_p().func_74775_l(TAG_STATE));
                }
                if (entity.field_70170_p.func_230315_m_().func_236040_e_() && placeState.func_235901_b_((Property)BlockStateProperties.field_208198_y)) {
                    placeState = (BlockState)placeState.func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(false));
                }
                if (entity.field_70170_p.func_180495_p(pos).func_185904_a().func_76222_j()) {
                    TileEntity tile = null;
                    CompoundNBT tilecmp = ItemNBTHelper.getCompound(lens, TAG_TILE, false);
                    if (tilecmp.func_74764_b("id")) {
                        tile = TileEntity.func_235657_b_((BlockState)placeState, (CompoundNBT)tilecmp);
                    }
                    entity.field_70170_p.func_175656_a(pos, placeState);
                    entity.field_70170_p.func_217379_c(2001, pos, Block.func_196246_j((BlockState)placeState));
                    if (tile != null) {
                        tile.func_174878_a(pos);
                        entity.field_70170_p.func_175690_a(pos, tile);
                    }
                } else {
                    int ox = ItemNBTHelper.getInt(lens, TAG_X, 0);
                    int oy = ItemNBTHelper.getInt(lens, TAG_Y_START, -1);
                    int oz = ItemNBTHelper.getInt(lens, TAG_Z, 0);
                    Block.func_220075_c((BlockState)placeState, (World)entity.field_70170_p, (BlockPos)new BlockPos(ox, oy, oz));
                }
                entity.func_70106_y();
            }
        }
    }

    @Override
    public boolean doParticles(IManaBurst burst, ItemStack stack) {
        ThrowableEntity entity = burst.entity();
        ItemStack lens = burst.getSourceLens();
        BlockState state = NBTUtil.func_190008_d((CompoundNBT)lens.func_196082_o().func_74775_l(TAG_STATE));
        entity.field_70170_p.func_195594_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, state), entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), entity.func_213322_ci().func_82615_a(), entity.func_213322_ci().func_82617_b(), entity.func_213322_ci().func_82616_c());
        return true;
    }

    @Override
    public boolean shouldPull(ItemStack stack) {
        return false;
    }
}

