/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.entity;

import com.google.common.base.Predicates;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.DyeItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ItemParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkHooks;
import vazkii.botania.api.corporea.ICorporeaNode;
import vazkii.botania.api.corporea.ICorporeaSpark;
import vazkii.botania.common.entity.EntitySpark;
import vazkii.botania.common.entity.EntitySparkBase;
import vazkii.botania.common.impl.corporea.DummyCorporeaNode;
import vazkii.botania.common.integration.corporea.CorporeaNodeDetectors;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.lib.ModTags;

public class EntityCorporeaSpark
extends EntitySparkBase
implements ICorporeaSpark {
    private static final int SCAN_RANGE = 8;
    private static final String TAG_MASTER = "master";
    private static final DataParameter<Boolean> MASTER = EntityDataManager.func_187226_a(EntityCorporeaSpark.class, (IDataSerializer)DataSerializers.field_187198_h);
    private ICorporeaSpark master;
    private List<ICorporeaSpark> connections = new ArrayList<ICorporeaSpark>();
    private List<ICorporeaSpark> relatives = new ArrayList<ICorporeaSpark>();
    private boolean firstTick = true;

    public EntityCorporeaSpark(EntityType<EntityCorporeaSpark> type, World world) {
        super(type, world);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(MASTER, (Object)false);
    }

    @Nonnull
    public ItemStack getPickedResult(RayTraceResult target) {
        return this.isMaster() ? new ItemStack((IItemProvider)ModItems.corporeaSparkMaster) : new ItemStack((IItemProvider)ModItems.corporeaSpark);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        ICorporeaNode node = this.getSparkNode();
        if (node instanceof DummyCorporeaNode && !this.field_70170_p.func_180495_p(this.getAttachPos()).func_235714_a_(ModTags.Blocks.CORPOREA_SPARK_OVERRIDE)) {
            this.dropAndKill();
            return;
        }
        if (this.isMaster()) {
            this.master = this;
        }
        if (this.firstTick) {
            if (this.isMaster()) {
                this.restartNetwork();
            } else {
                this.findNetwork();
            }
            this.firstTick = false;
        }
        if (this.master != null && (((Entity)this.master).field_70128_L || this.master.getNetwork() != this.getNetwork())) {
            this.master = null;
        }
    }

    private void dropAndKill() {
        this.func_70099_a(new ItemStack((IItemProvider)(this.isMaster() ? ModItems.corporeaSparkMaster : ModItems.corporeaSpark)), 0.0f);
        this.func_70106_y();
    }

    public void func_70106_y() {
        super.func_70106_y();
        this.connections.remove(this);
        this.restartNetwork();
    }

    @Override
    public void registerConnections(ICorporeaSpark master, ICorporeaSpark referrer, List<ICorporeaSpark> connections) {
        this.relatives.clear();
        for (ICorporeaSpark spark : this.getNearbySparks()) {
            if (spark == null || connections.contains(spark) || spark.getNetwork() != this.getNetwork() || spark.isMaster() || ((Entity)spark).field_70128_L) continue;
            connections.add(spark);
            this.relatives.add(spark);
            spark.registerConnections(master, this, connections);
        }
        this.master = master;
        this.connections = connections;
    }

    private List<ICorporeaSpark> getNearbySparks() {
        return this.field_70170_p.func_175647_a(Entity.class, new AxisAlignedBB(this.func_226277_ct_() - 8.0, this.func_226278_cu_() - 8.0, this.func_226281_cx_() - 8.0, this.func_226277_ct_() + 8.0, this.func_226278_cu_() + 8.0, this.func_226281_cx_() + 8.0), (Predicate)Predicates.instanceOf(ICorporeaSpark.class));
    }

    private void restartNetwork() {
        this.connections = new ArrayList<ICorporeaSpark>();
        this.relatives = new ArrayList<ICorporeaSpark>();
        if (this.master != null) {
            ICorporeaSpark oldMaster = this.master;
            this.master = null;
            oldMaster.registerConnections(oldMaster, this, new ArrayList<ICorporeaSpark>());
        }
    }

    private void findNetwork() {
        for (ICorporeaSpark spark : this.getNearbySparks()) {
            ICorporeaSpark master;
            if (spark.getNetwork() != this.getNetwork() || ((Entity)spark).field_70128_L || (master = spark.getMaster()) == null) continue;
            this.master = master;
            this.restartNetwork();
            break;
        }
    }

    private static void displayRelatives(PlayerEntity player, List<ICorporeaSpark> checked, ICorporeaSpark spark) {
        if (spark == null) {
            return;
        }
        List<ICorporeaSpark> sparks = spark.getRelatives();
        if (sparks.isEmpty()) {
            EntitySpark.particleBeam(player, (Entity)spark, (Entity)spark.getMaster());
        } else {
            for (ICorporeaSpark endSpark : sparks) {
                if (checked.contains(endSpark)) continue;
                EntitySpark.particleBeam(player, (Entity)spark, (Entity)endSpark);
                checked.add(endSpark);
                EntityCorporeaSpark.displayRelatives(player, checked, endSpark);
            }
        }
    }

    @Override
    public BlockPos getAttachPos() {
        int x = MathHelper.func_76128_c((double)this.func_226277_ct_());
        int y = MathHelper.func_76128_c((double)(this.func_226278_cu_() - 1.0));
        int z = MathHelper.func_76128_c((double)this.func_226281_cx_());
        return new BlockPos(x, y, z);
    }

    @Override
    public ICorporeaNode getSparkNode() {
        return CorporeaNodeDetectors.findNode(this.field_70170_p, this);
    }

    @Override
    public List<ICorporeaSpark> getConnections() {
        return this.connections;
    }

    @Override
    public List<ICorporeaSpark> getRelatives() {
        return this.relatives;
    }

    @Override
    public void onItemExtracted(ItemStack stack) {
        ((ServerWorld)this.field_70170_p).func_195598_a((IParticleData)new ItemParticleData(ParticleTypes.field_197591_B, stack), this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 10, 0.125, 0.125, 0.125, 0.05);
    }

    @Override
    public void onItemsRequested(List<ItemStack> stacks) {
        ArrayList<Item> shownItems = new ArrayList<Item>();
        for (ItemStack stack : stacks) {
            if (shownItems.contains(stack.func_77973_b())) continue;
            shownItems.add(stack.func_77973_b());
            ((ServerWorld)this.field_70170_p).func_195598_a((IParticleData)new ItemParticleData(ParticleTypes.field_197591_B, stack), this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 10, 0.125, 0.125, 0.125, 0.05);
        }
    }

    @Override
    public ICorporeaSpark getMaster() {
        return this.master;
    }

    public void setMaster(boolean master) {
        this.field_70180_af.func_187227_b(MASTER, (Object)master);
    }

    @Override
    public boolean isMaster() {
        return (Boolean)this.field_70180_af.func_187225_a(MASTER);
    }

    public ActionResultType func_184230_a(PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!this.field_70128_L && !stack.func_190926_b()) {
            if (stack.func_77973_b() == ModItems.twigWand) {
                if (!this.field_70170_p.field_72995_K) {
                    if (player.func_225608_bj_()) {
                        this.dropAndKill();
                        if (this.isMaster()) {
                            this.restartNetwork();
                        }
                    } else {
                        EntityCorporeaSpark.displayRelatives(player, new ArrayList<ICorporeaSpark>(), this.master);
                    }
                }
                return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
            }
            if (stack.func_77973_b() instanceof DyeItem) {
                DyeColor color = ((DyeItem)stack.func_77973_b()).func_195962_g();
                if (color != this.getNetwork()) {
                    if (!this.field_70170_p.field_72995_K) {
                        this.setNetwork(color);
                        stack.func_190918_g(1);
                    }
                    return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
                }
            } else if (stack.func_77973_b() == ModItems.phantomInk) {
                if (!this.field_70170_p.field_72995_K) {
                    this.func_82142_c(true);
                }
                return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
            }
        }
        return ActionResultType.PASS;
    }

    @Override
    public void setNetwork(DyeColor color) {
        if (color == this.getNetwork()) {
            return;
        }
        super.setNetwork(color);
        if (!this.firstTick) {
            if (this.isMaster()) {
                this.restartNetwork();
            } else {
                this.findNetwork();
            }
        }
    }

    @Nonnull
    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    @Override
    protected void func_70037_a(@Nonnull CompoundNBT cmp) {
        super.func_70037_a(cmp);
        this.setMaster(cmp.func_74767_n(TAG_MASTER));
    }

    @Override
    protected void func_213281_b(@Nonnull CompoundNBT cmp) {
        super.func_213281_b(cmp);
        cmp.func_74757_a(TAG_MASTER, this.isMaster());
    }
}

