/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.tile.mana;

import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.common.block.tile.ModTiles;
import vazkii.botania.common.block.tile.TileMod;
import vazkii.botania.common.block.tile.mana.TileSpreader;

public class TileTurntable
extends TileMod
implements ITickableTileEntity {
    private static final String TAG_SPEED = "speed";
    private static final String TAG_BACKWARDS = "backwards";
    private int speed = 1;
    private boolean backwards = false;

    public TileTurntable() {
        super(ModTiles.TURNTABLE);
    }

    public void func_73660_a() {
        TileEntity tile;
        boolean redstone = false;
        for (Direction dir : Direction.values()) {
            int redstoneSide = this.field_145850_b.func_175651_c(this.field_174879_c.func_177972_a(dir), dir);
            if (redstoneSide <= 0) continue;
            redstone = true;
        }
        if (!redstone && (tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177984_a())) instanceof TileSpreader) {
            TileSpreader spreader = (TileSpreader)tile;
            spreader.rotationX = spreader.rotationX + (float)(this.speed * (this.backwards ? -1 : 1));
            if (spreader.rotationX >= 360.0f) {
                spreader.rotationX -= 360.0f;
            }
            if (!this.field_145850_b.field_72995_K) {
                spreader.checkForReceiver();
            }
        }
    }

    @Override
    public void writePacketNBT(CompoundNBT cmp) {
        cmp.func_74768_a(TAG_SPEED, this.speed);
        cmp.func_74757_a(TAG_BACKWARDS, this.backwards);
    }

    @Override
    public void readPacketNBT(CompoundNBT cmp) {
        this.speed = cmp.func_74762_e(TAG_SPEED);
        this.backwards = cmp.func_74767_n(TAG_BACKWARDS);
    }

    public void onWanded(PlayerEntity player, ItemStack wand, Direction side) {
        if (player != null && player.func_225608_bj_() || player == null && side == Direction.DOWN) {
            this.backwards = !this.backwards;
        } else {
            this.speed = this.speed == 6 ? 1 : this.speed + 1;
        }
        VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderHUD(MatrixStack ms, Minecraft mc) {
        int color = -1442814464;
        char motion = this.backwards ? (char)'<' : '>';
        String speed = TextFormatting.BOLD + "";
        for (int i = 0; i < this.speed; ++i) {
            speed = speed + motion;
        }
        int x = mc.func_228018_at_().func_198107_o() / 2 - mc.field_71466_p.func_78256_a(speed) / 2;
        int y = mc.func_228018_at_().func_198087_p() / 2 - 15;
        mc.field_71466_p.func_238405_a_(ms, speed, (float)x, (float)y, color);
    }
}

