/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.tile;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.client.model.data.ModelProperty;
import vazkii.botania.common.block.tile.ModTiles;
import vazkii.botania.common.block.tile.TileMod;

public class TilePlatform
extends TileMod {
    public static final ModelProperty<BlockState> HELD_STATE = new ModelProperty();
    public static final ModelProperty<BlockPos> HELD_POS = new ModelProperty();
    private static final String TAG_CAMO = "camo";
    @Nullable
    private BlockState camoState;

    public TilePlatform() {
        super(ModTiles.PLATFORM);
    }

    public boolean onWanded(PlayerEntity player) {
        if (player != null) {
            if (this.getCamoState() == null || player.func_225608_bj_()) {
                this.swapSelfAndPass(this, true);
            } else {
                this.swapSurroudings(this, false);
            }
            return true;
        }
        return false;
    }

    @Nullable
    public BlockState getCamoState() {
        return this.camoState;
    }

    public void setCamoState(@Nullable BlockState state) {
        this.camoState = state;
        if (this.field_145850_b != null) {
            this.field_145850_b.func_184138_a(this.func_174877_v(), this.func_195044_w(), this.func_195044_w(), 3);
            if (!this.field_145850_b.field_72995_K) {
                this.field_145850_b.func_230547_a_(this.field_174879_c, this.func_195044_w().func_177230_c());
            }
        }
    }

    private void swapSelfAndPass(TilePlatform tile, boolean empty) {
        this.swap(tile, empty);
        this.swapSurroudings(tile, empty);
    }

    private void swapSurroudings(TilePlatform tile, boolean empty) {
        for (Direction dir : Direction.values()) {
            TilePlatform platform;
            BlockPos pos = tile.func_174877_v().func_177972_a(dir);
            TileEntity tileAt = this.field_145850_b.func_175625_s(pos);
            if (!(tileAt instanceof TilePlatform) || empty != ((platform = (TilePlatform)tileAt).getCamoState() != null)) continue;
            this.swapSelfAndPass(platform, empty);
        }
    }

    private void swap(TilePlatform tile, boolean empty) {
        tile.setCamoState(empty ? null : this.getCamoState());
    }

    @Override
    public void writePacketNBT(CompoundNBT cmp) {
        if (this.getCamoState() != null) {
            cmp.func_218657_a(TAG_CAMO, (INBT)NBTUtil.func_190009_a((BlockState)this.getCamoState()));
        }
    }

    @Override
    public void readPacketNBT(CompoundNBT cmp) {
        BlockState state = NBTUtil.func_190008_d((CompoundNBT)cmp.func_74775_l(TAG_CAMO));
        if (state.func_196958_f()) {
            state = null;
        }
        this.setCamoState(state);
    }

    @Override
    public void onDataPacket(NetworkManager manager, SUpdateTileEntityPacket packet) {
        super.onDataPacket(manager, packet);
        this.requestModelDataUpdate();
        if (this.field_145850_b instanceof ClientWorld) {
            this.field_145850_b.func_184138_a(this.func_174877_v(), this.func_195044_w(), this.func_195044_w(), 0);
        }
    }

    @Nonnull
    public IModelData getModelData() {
        return new ModelDataMap.Builder().withInitial(HELD_POS, (Object)this.func_174877_v()).withInitial(HELD_STATE, (Object)this.getCamoState()).build();
    }
}

