/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.mixin;

import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import vazkii.botania.common.core.handler.ConfigHandler;

import java.util.List;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4008;

@Mixin(class_4008.class)
public class MixinSplashes {
	@Shadow
	@Final
	private List<String> splashTexts;

	/**
	 * Adds splash texts if enabled
	 */
	@Inject(at = @At("RETURN"), method = "apply")
	public void addSplashes(List<String> splashes, class_3300 resourceManager, class_3695 profiler, CallbackInfo ci) {
		if (ConfigHandler.CLIENT.splashesEnabled.getValue()) {
			splashTexts.add("Do not feed bread to elves!");
		}
	}
}
