/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.mixin;

import net.minecraft.class_1113;
import net.minecraft.class_1140;
import net.minecraft.class_3419;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import vazkii.botania.common.block.subtile.functional.SubTileBergamute;

@Mixin(class_1140.class)
public class MixinSoundEngine {
	@Unique
	private class_1113 tmpSound;

	@Inject(at = @At("HEAD"), method = "getAdjustedVolume")
	private void captureSound(class_1113 sound, CallbackInfoReturnable<Float> cir) {
		tmpSound = sound;
	}

	@Unique
	private static boolean shouldSilence(class_1113 sound) {
		return sound.method_4774() != class_3419.field_15246
				&& sound.method_4774() != class_3419.field_15253
				&& sound.method_4774() != class_3419.field_15247
				&& sound.method_4774() != class_3419.field_15256;
	}

	@ModifyArg(index = 0, at = @At(value = "INVOKE", target = "Lnet/minecraft/util/math/MathHelper;clamp(FFF)F"), method = "getAdjustedVolume")
	private float bergamuateAttenuate(float volume) {
		if (shouldSilence(tmpSound) && SubTileBergamute.muteSound(tmpSound)) {
			return volume * 0.15F;
		}
		return volume;
	}

	@Inject(at = @At("RETURN"), method = "getAdjustedVolume")
	private void clearSound(class_1113 sound, CallbackInfoReturnable<Float> cir) {
		tmpSound = null;
	}
}
