/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.mixin;

import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_3222;
import net.minecraft.class_3225;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.item.equipment.tool.ItemGlassPick;
import vazkii.botania.common.item.equipment.tool.elementium.ItemElementiumShovel;
import vazkii.botania.common.item.equipment.tool.terrasteel.ItemTerraAxe;
import vazkii.botania.common.item.equipment.tool.terrasteel.ItemTerraPick;

@Mixin(class_3225.class)
public class MixinServerPlayerInteractionManager {
	@Shadow
	public class_3222 player;

	@Inject(method = "tryBreakBlock", at = @At(value = "INVOKE", target = "Lnet/minecraft/block/Block;onBreak(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/BlockState;Lnet/minecraft/entity/player/PlayerEntity;)V"))
	private void onStartBreak(class_2338 pos, CallbackInfoReturnable<Boolean> cir) {
		class_3222 player = this.player;
		class_1799 stack = player.method_6047();
		if (stack.method_7909() == ModItems.terraAxe) {
			((ItemTerraAxe) ModItems.terraAxe).onBlockStartBreak(stack, pos, player);
		} else if (stack.method_7909() == ModItems.terraPick) {
			((ItemTerraPick) ModItems.terraPick).onBlockStartBreak(stack, pos, player);
		} else if (stack.method_7909() == ModItems.elementiumShovel) {
			((ItemElementiumShovel) ModItems.elementiumShovel).onBlockStartBreak(stack, pos, player);
		} else if (stack.method_7909() == ModItems.glassPick) {
			((ItemGlassPick) ModItems.glassPick).onBlockStartBreak(stack, pos, player);
		}
	}
}
