/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.mixin;

import com.mojang.datafixers.util.Either;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_3222;
import net.minecraft.class_3902;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import vazkii.botania.common.Botania;
import vazkii.botania.common.block.subtile.functional.SubTileDaffomill;
import vazkii.botania.common.core.handler.EquipmentHandler;
import vazkii.botania.common.core.handler.SleepingHandler;
import vazkii.botania.common.world.SkyblockWorldEvents;

@Mixin(class_3222.class)
public class MixinServerPlayerEntity {
	/**
	 * Setups up a player when spawning into a GoG world for the first time
	 */
	@Inject(at = @At("RETURN"), method = "onSpawn")
	private void onLogin(CallbackInfo ci) {
		if (Botania.gardenOfGlassLoaded) {
			SkyblockWorldEvents.onPlayerJoin((class_3222) (Object) this);
		}
	}

	/**
	 * Sends any item entity ages to the client when they start being tracked
	 */
	@Inject(at = @At("RETURN"), method = "onStartedTracking")
	private void sendItemAge(class_1297 entity, CallbackInfo ci) {
		SubTileDaffomill.onItemTrack((class_3222) (Object) this, entity);
	}

	@Inject(at = @At("HEAD"), method = "trySleep", cancellable = true)
	private void preventGaiaSleep(class_2338 pos, CallbackInfoReturnable<Either<class_1657.class_1658, class_3902>> cir) {
		class_1657.class_1658 fail = SleepingHandler.trySleep((class_1657) (Object) this);
		if (fail != null) {
			cir.setReturnValue(Either.left(fail));
		}
	}

	@Inject(at = @At("RETURN"), method = "tick")
	private void onTick(CallbackInfo ci) {
		if (EquipmentHandler.instance instanceof EquipmentHandler.InventoryEquipmentHandler) {
			((EquipmentHandler.InventoryEquipmentHandler) EquipmentHandler.instance).onPlayerTick((class_1657) (Object) this);
		}
	}

}
