/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.mixin;

import net.minecraft.class_1263;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_5132;
import org.apache.commons.lang3.mutable.MutableFloat;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.ModifyArgs;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import org.spongepowered.asm.mixin.injection.invoke.arg.Args;

import vazkii.botania.common.core.ModStats;
import vazkii.botania.common.core.handler.EquipmentHandler;
import vazkii.botania.common.core.handler.PixieHandler;
import vazkii.botania.common.entity.ModEntities;
import vazkii.botania.common.item.ItemKeepIvy;
import vazkii.botania.common.item.equipment.armor.manasteel.ItemManasteelArmor;
import vazkii.botania.common.item.equipment.bauble.*;
import vazkii.botania.common.item.relic.ItemOdinRing;

@Mixin(class_1657.class)
public abstract class MixinPlayerEntity extends class_1309 {

	protected MixinPlayerEntity(class_1299<? extends class_1309> entityType, class_1937 world) {
		super(entityType, world);
	}

	@Shadow
	public abstract void increaseStat(class_2960 stat, int amount);

	@Shadow
	@Final
	public class_1661 inventory;

	/**
	 * Registers the pixie spawn chance attribute on players
	 */
	@Inject(at = @At("RETURN"), method = "createPlayerAttributes")
	private static void addPixieAttribute(CallbackInfoReturnable<class_5132.class_5133> cir) {
		cir.getReturnValue().method_26867(PixieHandler.PIXIE_SPAWN_CHANCE);
	}

	/**
	 * Makes the player invulnerable to certain damage when wearing an Odin Ring
	 */
	@Inject(at = @At("HEAD"), method = "isInvulnerableTo", cancellable = true)
	private void odinRing(class_1282 src, CallbackInfoReturnable<Boolean> cir) {
		if (ItemOdinRing.onPlayerAttacked((class_1657) (Object) this, src)) {
			cir.setReturnValue(true);
		}
	}

	/**
	 * Updates the distance by luminizer stat
	 */
	@Inject(
		at = @At(value = "INVOKE_ASSIGN", target = "Lnet/minecraft/entity/player/PlayerEntity;getVehicle()Lnet/minecraft/entity/Entity;"),
		method = "increaseRidingMotionStats", locals = LocalCapture.CAPTURE_FAILSOFT
	)
	private void trackLuminizerTravel(double dx, double dy, double dz, CallbackInfo ci, int cm, class_1297 mount) {
		if (mount.method_5864() == ModEntities.PLAYER_MOVER) {
			increaseStat(ModStats.LUMINIZER_ONE_CM, cm);
		}
	}

	/**
	 * Performs many reactions when being hit
	 */
	@ModifyArgs(method = "damage", at = @At(value = "INVOKE", target = "Lnet/minecraft/entity/LivingEntity;damage(Lnet/minecraft/entity/damage/DamageSource;F)Z"))
	private void onHurt(Args args) {
		class_1657 self = (class_1657) (Object) this;
		class_1282 src = args.get(0);
		MutableFloat amount = new MutableFloat((float) args.get(1));
		class_1263 worn = EquipmentHandler.getAllWorn(self);
		for (int i = 0; i < worn.method_5439(); i++) {
			class_1799 stack = worn.method_5438(i);
			if (stack.method_7909() instanceof ItemHolyCloak) {
				((ItemHolyCloak) stack.method_7909()).effectOnDamage(src, amount, self, stack);
			}
		}

		// Should really make a separate inject for this, but putting it here works too
		PixieHandler.onDamageTaken(self, src);

		args.set(1, amount.getValue());
	}

	/**
	 * Tells the magnet ring about item drops
	 */
	@Inject(at = @At("HEAD"), method = "dropItem(Lnet/minecraft/item/ItemStack;ZZ)Lnet/minecraft/entity/ItemEntity;")
	public void onDrop(class_1799 stack, boolean throwRandomly, boolean retainOwnership, CallbackInfoReturnable<class_1542> cir) {
		class_1937 world = this.field_6002;
		if (!stack.method_7960() && !world.field_9236) {
			ItemMagnetRing.onTossItem((class_1657) (Object) this);
		}
	}

	@Inject(at = @At("RETURN"), method = "tick")
	private void tickBeltTiara(CallbackInfo ci) {
		ItemFlightTiara.updatePlayerFlyStatus((class_1657) (Object) this);
		ItemTravelBelt.updatePlayerStepStatus((class_1657) (Object) this);
	}

	@ModifyArg(index = 0, method = "handleFallDamage", at = @At(value = "INVOKE", target = "Lnet/minecraft/entity/LivingEntity;handleFallDamage(FF)Z"))
	private float cushionFall(float originalDist) {
		return ItemTravelBelt.onPlayerFall((class_1657) (Object) this, originalDist);
	}

	@Inject(at = @At(value = "INVOKE", target = "Lnet/minecraft/entity/player/PlayerInventory;updateItems()V"), method = "tickMovement")
	private void tickArmor(CallbackInfo ci) {
		class_1657 self = (class_1657) (Object) this;
		for (class_1799 stack : inventory.field_7548) {
			if (stack.method_7909() instanceof ItemManasteelArmor) {
				((ItemManasteelArmor) stack.method_7909()).onArmorTick(stack, self.field_6002, self);
			}
		}
	}

	@Inject(at = @At(value = "INVOKE", target = "Lnet/minecraft/entity/player/PlayerEntity;onAttacking(Lnet/minecraft/entity/Entity;)V"), method = "attack")
	private void onAttack(class_1297 target, CallbackInfo ci) {
		ItemDivaCharm.onEntityDamaged((class_1657) (Object) this, target);
	}

	@Inject(at = @At(value = "INVOKE", target = "Lnet/minecraft/entity/player/PlayerInventory;dropAll()V"), method = "dropInventory")
	private void keepIvy(CallbackInfo ci) {
		ItemKeepIvy.onPlayerDrops((class_1657) (Object) this);
	}
}
