/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.mixin;

import net.minecraft.class_1922;
import net.minecraft.class_2261;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import vazkii.botania.common.block.BlockAltGrass;
import vazkii.botania.common.block.BlockEnchantedSoil;

@Mixin(class_2261.class)
public class MixinPlantBlock {
	@Inject(at = @At("HEAD"), method = "canPlantOnTop", cancellable = true)
	private void canPlant(class_2680 floor, class_1922 world, class_2338 pos, CallbackInfoReturnable<Boolean> cir) {
		if (floor.method_26204() instanceof BlockEnchantedSoil || floor.method_26204() instanceof BlockAltGrass) {
			cir.setReturnValue(true);
		}
	}
}
