/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.mixin;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import vazkii.botania.common.brew.potion.PotionSoulCross;
import vazkii.botania.common.components.EntityComponents;
import vazkii.botania.common.components.LooniumComponent;
import vazkii.botania.common.item.ItemCraftingHalo;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.item.equipment.bauble.ItemTravelBelt;
import vazkii.botania.common.item.equipment.tool.elementium.ItemElementiumAxe;
import vazkii.botania.common.item.rod.ItemGravityRod;

import javax.annotation.Nullable;
import net.minecraft.class_1268;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1937;

@Mixin(class_1309.class)
public abstract class MixinLivingEntity extends class_1297 {

	public MixinLivingEntity(class_1299<?> type, class_1937 world) {
		super(type, world);
	}

	@Shadow
	public abstract class_1799 getStackInHand(class_1268 hand);

	@Shadow
	protected int playerHitTimer;

	@Inject(at = @At("HEAD"), cancellable = true, method = "dropLoot")
	private void dropLoonium(class_1282 source, boolean causedByPlayer, CallbackInfo ci) {
		LooniumComponent comp = EntityComponents.LOONIUM_DROP.getNullable(this);
		if (comp != null && !comp.getDrop().method_7960()) {
			method_5775(comp.getDrop());
			ci.cancel();
		}
	}

	@Inject(at = @At("RETURN"), method = "drop")
	private void dropEnd(class_1282 source, CallbackInfo ci) {
		ItemElementiumAxe.onEntityDrops(playerHitTimer, source, (class_1309) (Object) this);
	}

	/**
	 * Applies soul cross effect when being killed
	 */
	@Inject(at = @At("RETURN"), method = "onKilledBy")
	private void healKiller(@Nullable class_1309 adversary, CallbackInfo ci) {
		if (!field_6002.field_9236 && adversary != null) {
			PotionSoulCross.onEntityKill((class_1309) (Object) this, adversary);
		}

	}

	@Inject(at = @At("HEAD"), method = "swingHand(Lnet/minecraft/util/Hand;Z)V", cancellable = true)
	private void onSwing(class_1268 hand, boolean bl, CallbackInfo ci) {
		class_1799 stack = getStackInHand(hand);
		class_1309 self = (class_1309) (Object) this;
		if (!field_6002.field_9236) {
			if (stack.method_7909() instanceof ItemCraftingHalo && ItemCraftingHalo.onEntitySwing(stack, self)) {
				ci.cancel();
			} else if (stack.method_7909() instanceof ItemGravityRod) {
				ItemGravityRod.onEntitySwing(self);
			}
		}
	}

	@Inject(at = @At("RETURN"), method = "jump")
	private void onJump(CallbackInfo ci) {
		((ItemTravelBelt) ModItems.travelBelt).onPlayerJump((class_1309) (Object) this);
		((ItemTravelBelt) ModItems.superTravelBelt).onPlayerJump((class_1309) (Object) this);
		((ItemTravelBelt) ModItems.speedUpBelt).onPlayerJump((class_1309) (Object) this);
	}
}
