/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.mixin;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import vazkii.botania.common.item.ItemFlowerBag;
import vazkii.botania.common.item.ItemManaTablet;
import vazkii.botania.common.item.equipment.bauble.ItemManaRing;
import vazkii.botania.common.item.equipment.tool.terrasteel.ItemTerraPick;
import vazkii.botania.common.item.relic.ItemRelic;
import vazkii.botania.common.item.relic.ItemRelicBauble;

import java.util.UUID;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1792;

@Mixin(class_1542.class)
public class MixinItemEntity {
	@Shadow
	private int pickupDelay;

	@Shadow
	private UUID owner;

	@Inject(at = @At("HEAD"), method = "onPlayerCollision", cancellable = true)
	private void onPickup(class_1657 player, CallbackInfo ci) {
		class_1542 self = (class_1542) (Object) this;
		if (!player.field_6002.field_9236 && pickupDelay == 0 && (owner == null || owner.equals(player.method_5667()))
				&& ItemFlowerBag.onPickupItem(self, player)) {
			ci.cancel();
		}
	}

	@ModifyConstant(method = "tick", constant = @Constant(intValue = 6000))
	private int disableDespawn(int value) {
		class_1542 self = (class_1542) (Object) this;
		class_1792 item = self.method_6983().method_7909();
		if (item instanceof ItemManaTablet || item instanceof ItemManaRing || item instanceof ItemTerraPick || item instanceof ItemRelic || item instanceof ItemRelicBauble) {
			return Integer.MAX_VALUE;
		}
		return value;
	}
}
