/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.mixin;

import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import vazkii.botania.common.item.equipment.bauble.ItemGoddessCharm;

import java.util.List;
import net.minecraft.class_1927;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;

@Mixin(class_1927.class)
public class MixinExplosion {
	@Shadow
	@Final
	private class_1937 world;

	@Shadow
	@Final
	private double x;

	@Shadow
	@Final
	private double y;

	@Shadow
	@Final
	private double z;

	@Shadow
	@Final
	private List<class_2338> affectedBlocks;

	@Inject(method = "affectWorld", at = @At("HEAD"))
	private void onAffectWorld(boolean particles, CallbackInfo ci) {
		ItemGoddessCharm.onExplosion(world, new class_243(x, y, z), affectedBlocks);
	}
}
