/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.mixin;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import vazkii.botania.common.core.ExtendedShapeContext;

import javax.annotation.Nullable;
import net.minecraft.class_1297;
import net.minecraft.class_3727;

@Mixin(class_3727.class)
public class MixinEntityShapeContext implements ExtendedShapeContext {
	@Nullable
	@Unique
	private class_1297 entity;

	@Inject(at = @At("RETURN"), method = "<init>(Lnet/minecraft/entity/Entity;)V")
	private void captureEntity(class_1297 entity, CallbackInfo ci) {
		this.entity = entity;
	}

	@Nullable
	@Override
	public class_1297 botania_getEntity() {
		return entity;
	}
}
