/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.mixin;

import net.minecraft.class_1688;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import vazkii.botania.common.block.BlockGhostRail;
import vazkii.botania.common.block.ModBlocks;

@Mixin(class_1688.class)
public class MixinAbstractMinecartEntity {
	@Inject(at = @At("RETURN"), method = "tick")
	private void onTick(CallbackInfo ci) {
		class_1688 self = (class_1688) (Object) this;
		((BlockGhostRail) ModBlocks.ghostRail).tickCart(self);

	}

	@Inject(at = @At("HEAD"), method = "moveOnRail")
	private void handleOnRail(class_2338 pos, class_2680 state, CallbackInfo ci) {
		if (state.method_27852(ModBlocks.ghostRail)) {
			class_1688 self = (class_1688) (Object) this;
			((BlockGhostRail) ModBlocks.ghostRail).onMinecartPass(self.field_6002, self);
		}

	}

}
