/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.data.recipes;

import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import net.minecraft.class_1865;
import net.minecraft.class_2378;
import net.minecraft.class_2444;
import net.minecraft.class_2960;
import java.util.function.Consumer;

public class WrapperResult implements class_2444 {
	private final class_2444 delegate;
	@Nullable
	private final class_1865<?> type;
	@Nullable
	private final Consumer<JsonObject> transform;

	/**
	 * Wraps recipe consumer with one that swaps the recipe type to a different one.
	 */
	public static Consumer<class_2444> ofType(class_1865<?> type, Consumer<class_2444> parent) {
		return recipe -> parent.accept(new WrapperResult(recipe, type, null));
	}

	/**
	 * Transforms the resulting recipe json with the specified action, eg. adding NBT to an item result.
	 */
	public static Consumer<class_2444> transformJson(Consumer<class_2444> parent, Consumer<JsonObject> transform) {
		return recipe -> parent.accept(new WrapperResult(recipe, null, transform));
	}

	private WrapperResult(class_2444 delegate, @Nullable class_1865<?> type, @Nullable Consumer<JsonObject> transform) {
		this.delegate = delegate;
		this.type = type;
		this.transform = transform;
	}

	@Override
	public void method_10416(JsonObject json) {
		delegate.method_10416(json);
		if (transform != null) {
			transform.accept(json);
		}
	}

	@Override
	public JsonObject method_17799() {
		if (type == null) {
			return class_2444.super.method_17799();
		}
		JsonObject jsonobject = new JsonObject();
		jsonobject.addProperty("type", class_2378.field_17598.method_10221(this.type).toString());
		this.method_10416(jsonobject);
		return jsonobject;
	}

	@Override
	public class_2960 method_10417() {
		return delegate.method_10417();
	}

	@Override
	public class_1865<?> method_17800() {
		return type != null ? type : delegate.method_17800();
	}

	@Nullable
	@Override
	public JsonObject method_10415() {
		return delegate.method_10415();
	}

	@Nullable
	@Override
	public class_2960 method_10418() {
		return delegate.method_10418();
	}
}
