/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.data.recipes;

import vazkii.botania.common.block.ModFluffBlocks;
import vazkii.botania.mixin.AccessorRecipesProvider;

import java.util.function.Consumer;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2066;
import net.minecraft.class_2403;
import net.minecraft.class_2444;
import net.minecraft.class_2446;
import net.minecraft.class_2454;

public class SmeltingProvider extends class_2446 implements BotaniaRecipeProvider {
	public SmeltingProvider(class_2403 generatorIn) {
		super(generatorIn);
	}

	private static class_2066.class_2068 method_10426(class_1935 item) {
		return AccessorRecipesProvider.botania_condition(item);
	}

	@Override
	public void registerRecipes(Consumer<class_2444> consumer) {
		class_2454.method_17802(class_1856.method_8091(ModFluffBlocks.biomeCobblestoneForest), ModFluffBlocks.biomeStoneForest, 0.1f, 200)
				.method_10469("has_item", method_10426(ModFluffBlocks.biomeCobblestoneForest))
				.method_10472(consumer, "botania:smelting/metamorphic_forest_stone");
		class_2454.method_17802(class_1856.method_8091(ModFluffBlocks.biomeCobblestonePlains), ModFluffBlocks.biomeStonePlains, 0.1f, 200)
				.method_10469("has_item", method_10426(ModFluffBlocks.biomeCobblestonePlains))
				.method_10472(consumer, "botania:smelting/metamorphic_plains_stone");
		class_2454.method_17802(class_1856.method_8091(ModFluffBlocks.biomeCobblestoneMountain), ModFluffBlocks.biomeStoneMountain, 0.1f, 200)
				.method_10469("has_item", method_10426(ModFluffBlocks.biomeCobblestoneMountain))
				.method_10472(consumer, "botania:smelting/metamorphic_mountain_stone");
		class_2454.method_17802(class_1856.method_8091(ModFluffBlocks.biomeCobblestoneFungal), ModFluffBlocks.biomeStoneFungal, 0.1f, 200)
				.method_10469("has_item", method_10426(ModFluffBlocks.biomeCobblestoneFungal))
				.method_10472(consumer, "botania:smelting/metamorphic_fungal_stone");
		class_2454.method_17802(class_1856.method_8091(ModFluffBlocks.biomeCobblestoneSwamp), ModFluffBlocks.biomeStoneSwamp, 0.1f, 200)
				.method_10469("has_item", method_10426(ModFluffBlocks.biomeCobblestoneSwamp))
				.method_10472(consumer, "botania:smelting/metamorphic_swamp_stone");
		class_2454.method_17802(class_1856.method_8091(ModFluffBlocks.biomeCobblestoneDesert), ModFluffBlocks.biomeStoneDesert, 0.1f, 200)
				.method_10469("has_item", method_10426(ModFluffBlocks.biomeCobblestoneDesert))
				.method_10472(consumer, "botania:smelting/metamorphic_desert_stone");
		class_2454.method_17802(class_1856.method_8091(ModFluffBlocks.biomeCobblestoneTaiga), ModFluffBlocks.biomeStoneTaiga, 0.1f, 200)
				.method_10469("has_item", method_10426(ModFluffBlocks.biomeCobblestoneTaiga))
				.method_10472(consumer, "botania:smelting/metamorphic_taiga_stone");
		class_2454.method_17802(class_1856.method_8091(ModFluffBlocks.biomeCobblestoneMesa), ModFluffBlocks.biomeStoneMesa, 0.1f, 200)
				.method_10469("has_item", method_10426(ModFluffBlocks.biomeCobblestoneMesa))
				.method_10472(consumer, "botania:smelting/metamorphic_mesa_stone");
	}

	@Override
	public String method_10321() {
		return "Botania smelting recipes";
	}
}
