/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.data.recipes;

import net.minecraft.class_1767;
import net.minecraft.class_1769;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_184;
import net.minecraft.class_1844;
import net.minecraft.class_1847;
import net.minecraft.class_1856;
import net.minecraft.class_1866;
import net.minecraft.class_1935;
import net.minecraft.class_2066;
import net.minecraft.class_2073;
import net.minecraft.class_2119;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2403;
import net.minecraft.class_2444;
import net.minecraft.class_2447;
import net.minecraft.class_2450;
import net.minecraft.class_2456;
import net.minecraft.class_2960;
import net.minecraft.class_3489;
import net.minecraft.class_3494;
import net.minecraft.item.*;
import vazkii.botania.api.state.enums.CratePattern;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.ModFluffBlocks;
import vazkii.botania.common.block.ModSubtiles;
import vazkii.botania.common.crafting.recipe.*;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.lib.LibBlockNames;
import vazkii.botania.common.lib.LibItemNames;
import vazkii.botania.common.lib.ModTags;
import vazkii.botania.common.lib.ResourceLocationHelper;
import vazkii.botania.mixin.AccessorIngredient;
import vazkii.botania.mixin.AccessorRecipesProvider;

import javax.annotation.Nullable;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;

import static vazkii.botania.common.lib.ResourceLocationHelper.prefix;

public class RecipeProvider extends net.minecraft.class_2446 implements BotaniaRecipeProvider {
	public RecipeProvider(class_2403 generator) {
		super(generator);
	}

	@Override
	public void registerRecipes(Consumer<class_2444> consumer) {
		specialRecipe(consumer, AncientWillRecipe.SERIALIZER);
		specialRecipe(consumer, BannerRecipe.SERIALIZER);
		specialRecipe(consumer, BlackHoleTalismanExtractRecipe.SERIALIZER);
		specialRecipe(consumer, CompositeLensRecipe.SERIALIZER);
		specialRecipe(consumer, CosmeticAttachRecipe.SERIALIZER);
		specialRecipe(consumer, CosmeticRemoveRecipe.SERIALIZER);
		specialRecipe(consumer, KeepIvyRecipe.SERIALIZER);
		specialRecipe(consumer, LaputaShardUpgradeRecipe.SERIALIZER);
		specialRecipe(consumer, LensDyeingRecipe.SERIALIZER);
		specialRecipe(consumer, ManaGunClipRecipe.SERIALIZER);
		specialRecipe(consumer, ManaGunLensRecipe.SERIALIZER);
		specialRecipe(consumer, ManaGunRemoveLensRecipe.SERIALIZER);
		specialRecipe(consumer, PhantomInkRecipe.SERIALIZER);
		specialRecipe(consumer, SpellClothRecipe.SERIALIZER);
		specialRecipe(consumer, TerraPickTippingRecipe.SERIALIZER);

		registerMain(consumer);
		registerMisc(consumer);
		registerTools(consumer);
		registerTrinkets(consumer);
		registerLenses(consumer);
		registerCorporeaAndRedString(consumer);
		registerFloatingFlowers(consumer);
		registerConversions(consumer);
		registerDecor(consumer);
	}

	private static class_2066.class_2068 method_10426(class_1935 item) {
		return AccessorRecipesProvider.botania_condition(item);
	}

	private static class_2066.class_2068 conditionsFromItems(class_1935... items) {
		class_2073[] preds = new class_2073[items.length];
		for (int i = 0; i < items.length; i++) {
			preds[i] = class_2073.class_2074.method_8973().method_8977(items[i]).method_8976();
		}

		return AccessorRecipesProvider.botania_condition(preds);
	}

	private static class_2066.class_2068 method_10420(class_3494<class_1792> tag) {
		return AccessorRecipesProvider.botania_condition(tag);
	}

	private void registerMain(Consumer<class_2444> consumer) {
		class_2066.class_2068 hasAnyDye = conditionsFromItems(
				Arrays.stream(class_1767.values()).map(class_1769::method_7803).toArray(class_1935[]::new)
		);
		class_2447.method_10437(ModBlocks.manaSpreader)
				.method_10433('P', ModTags.Items.PETALS)
				.method_10433('W', ModTags.Items.LIVINGWOOD)
				.method_10434('G', class_1802.field_8695)
				.method_10439("WWW")
				.method_10439("GP ")
				.method_10439("WWW")
				.method_10435("botania:spreader")
				.method_10429("has_item", method_10420(ModTags.Items.LIVINGWOOD))
				.method_10431(consumer);
		class_2450.method_10447(ModBlocks.redstoneSpreader)
				.method_10454(ModBlocks.manaSpreader)
				.method_10454(class_1802.field_8725)
				.method_10452("botania:spreader")
				.method_10442("has_item", method_10426(ModBlocks.manaSpreader))
				.method_10444(consumer);
		class_2447.method_10437(ModBlocks.elvenSpreader)
				.method_10433('P', ModTags.Items.PETALS)
				.method_10433('E', ModTags.Items.INGOTS_ELEMENTIUM)
				.method_10434('W', ModBlocks.dreamwood)
				.method_10439("WWW")
				.method_10439("EP ")
				.method_10439("WWW")
				.method_10435("botania:spreader")
				.method_10429("has_item", method_10420(ModTags.Items.INGOTS_ELEMENTIUM))
				.method_10429("has_alt_item", method_10426(ModBlocks.dreamwood))
				.method_10431(consumer);
		class_2450.method_10447(ModBlocks.gaiaSpreader)
				.method_10454(ModBlocks.elvenSpreader)
				.method_10446(ModTags.Items.GEMS_DRAGONSTONE)
				.method_10454(ModItems.lifeEssence)
				.method_10452("botania:spreader")
				.method_10442("has_item", method_10426(ModItems.lifeEssence))
				.method_10444(consumer);
		class_2447.method_10437(ModBlocks.manaPool)
				.method_10433('R', ModTags.Items.LIVINGROCK)
				.method_10439("R R")
				.method_10439("RRR")
				.method_10429("has_item", method_10420(ModTags.Items.LIVINGROCK))
				.method_10431(consumer);
		class_2447.method_10437(ModBlocks.dilutedPool)
				.method_10434('R', ModFluffBlocks.livingrockSlab)
				.method_10439("R R")
				.method_10439("RRR")
				.method_10429("has_item", method_10420(ModTags.Items.LIVINGROCK))
				.method_10431(consumer);
		class_2447.method_10437(ModBlocks.fabulousPool)
				.method_10434('R', ModBlocks.shimmerrock)
				.method_10439("R R")
				.method_10439("RRR")
				.method_10429("has_item", method_10426(ModBlocks.shimmerrock))
				.method_10429("has_alt_item", method_10426(ModItems.rainbowRod))
				.method_10431(consumer);
		class_2447.method_10437(ModBlocks.runeAltar)
				.method_10428('P', AccessorIngredient.botania_ofEntries(Stream.of(
						new class_1856.class_1857(new class_1799(ModItems.manaPearl)),
						new class_1856.class_1858(ModTags.Items.GEMS_MANA_DIAMOND))))
				.method_10433('S', ModTags.Items.LIVINGROCK)
				.method_10439("SSS")
				.method_10439("SPS")
				.method_10429("has_item", method_10426(ModItems.manaPearl))
				.method_10429("has_alt_item", method_10420(ModTags.Items.GEMS_MANA_DIAMOND))
				.method_10431(consumer);
		class_2447.method_10437(ModBlocks.manaPylon)
				.method_10433('D', ModTags.Items.GEMS_MANA_DIAMOND)
				.method_10434('G', class_1802.field_8695)
				.method_10433('M', ModTags.Items.INGOTS_MANASTEEL)
				.method_10439(" G ")
				.method_10439("MDM")
				.method_10439(" G ")
				.method_10429("has_item", method_10420(ModTags.Items.GEMS_MANA_DIAMOND))
				.method_10431(consumer);
		class_2447.method_10437(ModBlocks.naturaPylon)
				.method_10434('P', ModBlocks.manaPylon)
				.method_10433('T', ModTags.Items.NUGGETS_TERRASTEEL)
				.method_10434('E', class_1802.field_8449)
				.method_10439(" T ")
				.method_10439("TPT")
				.method_10439(" E ")
				.method_10429("has_item", method_10426(ModBlocks.manaPylon))
				.method_10429("has_alt_item", method_10420(ModTags.Items.INGOTS_TERRASTEEL))
				.method_10431(consumer);
		class_2447.method_10437(ModBlocks.gaiaPylon)
				.method_10434('P', ModBlocks.manaPylon)
				.method_10434('D', ModItems.pixieDust)
				.method_10433('E', ModTags.Items.INGOTS_ELEMENTIUM)
				.method_10439(" D ")
				.method_10439("EPE")
				.method_10439(" D ")
				.method_10429("has_item", method_10426(ModItems.pixieDust))
				.method_10429("has_alt_item", method_10420(ModTags.Items.INGOTS_ELEMENTIUM))
				.method_10431(consumer);
		class_2447.method_10437(ModBlocks.distributor)
				.method_10433('R', ModTags.Items.LIVINGROCK)
				.method_10433('S', ModTags.Items.INGOTS_MANASTEEL)
				.method_10439("RRR")
				.method_10439("S S")
				.method_10439("RRR")
				.method_10429("has_item", method_10420(ModTags.Items.INGOTS_MANASTEEL))
				.method_10431(consumer);
		class_2447.method_10437(ModBlocks.manaVoid)
				.method_10433('S', ModTags.Items.LIVINGROCK)
				.method_10434('O', class_1802.field_8281)
				.method_10439("SSS")
				.method_10439("O O")
				.method_10439("SSS")
				.method_10429("has_item", method_10420(ModTags.Items.LIVINGROCK))
				.method_10431(consumer);
		class_2447.method_10437(ModBlocks.manaDetector)
				.method_10434('R', class_1802.field_8725)
				.method_10434('C', class_1802.field_8857)
				.method_10433('S', ModTags.Items.LIVINGROCK)
				.method_10439("RSR")
				.method_10439("SCS")
				.method_10439("RSR")
				.method_10429("has_item", method_10426(class_1802.field_8857))
				.method_10429("has_alt_item", method_10420(ModTags.Items.LIVINGROCK))
				.method_10431(consumer);
		class_2447.method_10437(ModBlocks.turntable)
				.method_10434('P', class_1802.field_8105)
				.method_10433('W', ModTags.Items.LIVINGWOOD)
				.method_10439("WWW")
				.method_10439("WPW")
				.method_10439("WWW")
				.method_10429("has_item", method_10420(ModTags.Items.LIVINGWOOD))
				.method_10429("has_alt_item", method_10426(class_1802.field_8105))
				.method_10431(consumer);
		class_2447.method_10437(ModBlocks.tinyPlanet)
				.method_10434('P', ModItems.tinyPlanet)
				.method_10434('S', class_1802.field_20391)
				.method_10439("SSS")
				.method_10439("SPS")
				.method_10439("SSS")
				.method_10429("has_item", method_10426(ModItems.tinyPlanet))
				.method_10429("has_alt_item", method_10426(ModItems.manaPearl))
				.method_10431(consumer);
		class_2447.method_10437(ModBlocks.alchemyCatalyst)
				.method_10434('P', ModItems.manaPearl)
				.method_10434('B', class_1802.field_8740)
				.method_10433('S', ModTags.Items.LIVINGROCK)
				.method_10434('G', class_1802.field_8695)
				.method_10439("SGS")
				.method_10439("BPB")
				.method_10439("SGS")
				.method_10429("has_item", method_10426(ModItems.manaPearl))
				.method_10429("has_alt_item", method_10426(class_1802.field_8740))
				.method_10431(consumer);
		class_2447.method_10437(ModBlocks.openCrate)
				.method_10434('W', ModBlocks.livingwoodPlanks)
				.method_10439("WWW")
				.method_10439("W W")
				.method_10439("W W")
				.method_10429("has_item", method_10426(ModBlocks.livingwoodPlanks))
				.method_10431(consumer);
		class_2447.method_10437(ModBlocks.craftCrate)
				.method_10434('C', class_1802.field_8465)
				.method_10434('W', ModBlocks.dreamwoodPlanks)
				.method_10439("WCW")
				.method_10439("W W")
				.method_10439("W W")
				.method_10429("has_item", method_10426(ModBlocks.dreamwoodPlanks))
				.method_10431(consumer);
		class_2447.method_10437(ModBlocks.forestEye)
				.method_10433('S', ModTags.Items.LIVINGROCK)
				.method_10434('E', class_1802.field_8449)
				.method_10433('M', ModTags.Items.INGOTS_MANASTEEL)
				.method_10439("MSM")
				.method_10439("SES")
				.method_10439("MSM")
				.method_10429("has_item", method_10420(ModTags.Items.INGOTS_MANASTEEL))
				.method_10431(consumer);
		class_2447.method_10437(ModBlocks.wildDrum)
				.method_10433('W', ModTags.Items.LIVINGWOOD)
				.method_10434('H', ModItems.grassHorn)
				.method_10434('L', class_1802.field_8745)
				.method_10439("WLW")
				.method_10439("WHW")
				.method_10439("WLW")
				.method_10429("has_item", method_10426(ModItems.grassHorn))
				.method_10431(consumer);
		class_2447.method_10437(ModBlocks.gatheringDrum)
				.method_10433('E', ModTags.Items.INGOTS_ELEMENTIUM)
				.method_10434('W', ModBlocks.dreamwood)
				.method_10434('L', class_1802.field_8745)
				.method_10439("WLW")
				.method_10439("WEW")
				.method_10439("WLW")
				.method_10429("has_item", method_10420(ModTags.Items.INGOTS_ELEMENTIUM))
				.method_10429("has_alt_item", method_10426(ModBlocks.dreamwood))
				.method_10431(consumer);
		class_2447.method_10437(ModBlocks.canopyDrum)
				.method_10433('W', ModTags.Items.LIVINGWOOD)
				.method_10434('H', ModItems.leavesHorn)
				.method_10434('L', class_1802.field_8745)
				.method_10439("WLW")
				.method_10439("WHW")
				.method_10439("WLW")
				.method_10429("has_item", method_10426(ModItems.leavesHorn))
				.method_10431(consumer);
		class_2447.method_10436(ModBlocks.abstrusePlatform, 2)
				.method_10434('0', ModBlocks.livingwood)
				.method_10434('P', ModItems.manaPearl)
				.method_10434('3', ModBlocks.livingwoodFramed)
				.method_10434('4', ModBlocks.livingwoodPatternFramed)
				.method_10439("343")
				.method_10439("0P0")
				.method_10429("has_item", method_10426(ModItems.manaPearl))
				.method_10431(consumer);
		class_2447.method_10436(ModBlocks.spectralPlatform, 2)
				.method_10434('0', ModBlocks.dreamwood)
				.method_10434('3', ModBlocks.dreamwoodFramed)
				.method_10434('4', ModBlocks.dreamwoodPatternFramed)
				.method_10434('D', ModItems.pixieDust)
				.method_10439("343")
				.method_10439("0D0")
				.method_10429("has_item", method_10426(ModItems.pixieDust))
				.method_10431(consumer);
		class_2447.method_10437(ModBlocks.alfPortal)
				.method_10433('T', ModTags.Items.NUGGETS_TERRASTEEL)
				.method_10433('W', ModTags.Items.LIVINGWOOD)
				.method_10439("WTW")
				.method_10439("WTW")
				.method_10439("WTW")
				.method_10429("has_item", method_10420(ModTags.Items.INGOTS_TERRASTEEL))
				.method_10431(consumer);
		class_2447.method_10437(ModBlocks.conjurationCatalyst)
				.method_10434('P', ModBlocks.alchemyCatalyst)
				.method_10434('B', ModItems.pixieDust)
				.method_10433('S', ModTags.Items.LIVINGROCK)
				.method_10433('G', ModTags.Items.INGOTS_ELEMENTIUM)
				.method_10439("SBS")
				.method_10439("GPG")
				.method_10439("SGS")
				.method_10429("has_item", method_10426(ModItems.pixieDust))
				.method_10429("has_alt_item", method_10420(ModTags.Items.INGOTS_ELEMENTIUM))
				.method_10431(consumer);
		class_2447.method_10437(ModBlocks.spawnerClaw)
				.method_10434('P', class_1802.field_20405)
				.method_10434('B', class_1802.field_8894)
				.method_10433('S', ModTags.Items.INGOTS_ELEMENTIUM)
				.method_10434('E', ModItems.enderAirBottle)
				.method_10433('M', ModTags.Items.BLOCKS_MANASTEEL)
				.method_10439("BSB")
				.method_10439("PMP")
				.method_10439("PEP")
				.method_10429("has_item", method_10426(ModItems.enderAirBottle))
				.method_10431(consumer);
		class_2447.method_10437(ModBlocks.enderEye)
				.method_10434('R', class_1802.field_8725)
				.method_10434('E', class_1802.field_8449)
				.method_10434('O', class_1802.field_8281)
				.method_10439("RER")
				.method_10439("EOE")
				.method_10439("RER")
				.method_10429("has_item", method_10426(class_1802.field_8449))
				.method_10431(consumer);
		class_2447.method_10437(ModBlocks.starfield)
				.method_10434('P', ModItems.pixieDust)
				.method_10433('E', ModTags.Items.INGOTS_ELEMENTIUM)
				.method_10434('O', class_1802.field_8281)
				.method_10439("EPE")
				.method_10439("EOE")
				.method_10429("has_item", method_10426(ModItems.pixieDust))
				.method_10429("has_alt_item", method_10420(ModTags.Items.INGOTS_ELEMENTIUM))
				.method_10431(consumer);
		class_2447.method_10437(ModBlocks.rfGenerator)
				.method_10434('R', class_1802.field_8793)
				.method_10433('S', ModTags.Items.LIVINGROCK)
				.method_10433('M', ModTags.Items.INGOTS_MANASTEEL)
				.method_10439("SRS")
				.method_10439("RMR")
				.method_10439("SRS")
				.method_10429("has_item", method_10426(class_1802.field_8793))
				.method_10429("has_alt_item", method_10420(ModTags.Items.INGOTS_MANASTEEL))
				.method_10431(/* todo 1.16-fabricWrapperResult.transformJson(consumer, json -> {
							JsonArray array = new JsonArray();
							array.add(FluxfieldCondition.SERIALIZER.getJson(new FluxfieldCondition(true)));
							json.add("conditions", array);
							}
							)*/ consumer);
		class_2447.method_10437(ModBlocks.brewery)
				.method_10433('A', ModTags.Items.RUNES_MANA)
				.method_10433('R', ModTags.Items.LIVINGROCK)
				.method_10434('S', class_1802.field_8740)
				.method_10433('M', ModTags.Items.BLOCKS_MANASTEEL)
				.method_10439("RSR")
				.method_10439("RAR")
				.method_10439("RMR")
				.method_10429("has_item", method_10420(ModTags.Items.RUNES_MANA))
				.method_10429("has_alt_item", method_10426(class_1802.field_8740))
				.method_10431(consumer);
		class_2447.method_10437(ModBlocks.terraPlate)
				.method_10433('0', ModTags.Items.RUNES_WATER)
				.method_10433('1', ModTags.Items.RUNES_FIRE)
				.method_10433('2', ModTags.Items.RUNES_EARTH)
				.method_10433('3', ModTags.Items.RUNES_AIR)
				.method_10433('8', ModTags.Items.RUNES_MANA)
				.method_10434('L', class_2246.field_10441)
				.method_10433('M', ModTags.Items.BLOCKS_MANASTEEL)
				.method_10439("LLL")
				.method_10439("0M1")
				.method_10439("283")
				.method_10429("has_item", method_10420(ModTags.Items.RUNES))
				.method_10431(consumer);
		class_2447.method_10437(ModBlocks.prism)
				.method_10434('P', class_1802.field_8434)
				.method_10434('S', ModBlocks.spectralPlatform)
				.method_10434('G', class_1802.field_8280)
				.method_10439("GPG")
				.method_10439("GSG")
				.method_10439("GPG")
				.method_10429("has_item", method_10426(class_1802.field_8434))
				.method_10429("has_alt_item", method_10426(ModBlocks.spectralPlatform))
				.method_10431(consumer);
		class_2447.method_10437(ModBlocks.pump)
				.method_10434('B', class_1802.field_8550)
				.method_10433('S', ModTags.Items.LIVINGROCK)
				.method_10433('I', ModTags.Items.INGOTS_MANASTEEL)
				.method_10439("SSS")
				.method_10439("IBI")
				.method_10439("SSS")
				.method_10429("has_item", method_10420(ModTags.Items.INGOTS_MANASTEEL))
				.method_10431(consumer);
		class_2447.method_10437(ModBlocks.incensePlate)
				.method_10434('S', ModFluffBlocks.livingwoodSlab)
				.method_10433('W', ModTags.Items.LIVINGWOOD)
				.method_10439("WSS")
				.method_10429("has_item", method_10420(ModTags.Items.LIVINGWOOD))
				.method_10431(consumer);
		class_2447.method_10437(ModBlocks.hourglass)
				.method_10434('R', class_1802.field_8725)
				.method_10433('S', ModTags.Items.INGOTS_MANASTEEL)
				.method_10434('G', class_1802.field_8695)
				.method_10434('M', ModBlocks.manaGlass)
				.method_10439("GMG")
				.method_10439("RSR")
				.method_10439("GMG")
				.method_10429("has_item", method_10426(ModBlocks.manaGlass))
				.method_10431(consumer);
		class_2450.method_10447(ModBlocks.ghostRail)
				.method_10454(class_1802.field_8129)
				.method_10454(ModBlocks.spectralPlatform)
				.method_10442("has_item", method_10426(class_1802.field_8129))
				.method_10442("has_alt_item", method_10426(ModBlocks.spectralPlatform))
				.method_10444(consumer);
		class_2447.method_10437(ModBlocks.sparkChanger)
				.method_10434('R', class_1802.field_8725)
				.method_10433('S', ModTags.Items.LIVINGROCK)
				.method_10433('E', ModTags.Items.INGOTS_ELEMENTIUM)
				.method_10439("ESE")
				.method_10439("SRS")
				.method_10429("has_item", method_10420(ModTags.Items.INGOTS_ELEMENTIUM))
				.method_10431(consumer);
		class_2447.method_10437(ModBlocks.felPumpkin)
				.method_10434('P', class_1802.field_17518)
				.method_10434('B', class_1802.field_8606)
				.method_10434('S', class_1802.field_8276)
				.method_10434('F', class_1802.field_8511)
				.method_10434('G', class_1802.field_8054)
				.method_10439(" S ")
				.method_10439("BPF")
				.method_10439(" G ")
				.method_10429("has_item", method_10426(class_1802.field_17518))
				.method_10431(consumer);
		class_2447.method_10437(ModBlocks.cocoon)
				.method_10434('S', class_1802.field_8276)
				.method_10434('C', ModItems.manaweaveCloth)
				.method_10434('P', ModBlocks.felPumpkin)
				.method_10434('D', ModItems.pixieDust)
				.method_10439("SSS")
				.method_10439("CPC")
				.method_10439("SDS")
				.method_10429("has_item", method_10426(ModBlocks.felPumpkin))
				.method_10431(consumer);
		class_2450.method_10447(ModBlocks.lightRelayDefault)
				.method_10454(ModItems.redString)
				.method_10446(ModTags.Items.GEMS_DRAGONSTONE)
				.method_10454(class_1802.field_8601)
				.method_10454(class_1802.field_8601)
				.method_10442("has_item", method_10420(ModTags.Items.GEMS_DRAGONSTONE))
				.method_10444(consumer);
		class_2450.method_10447(ModBlocks.lightRelayDetector)
				.method_10454(ModBlocks.lightRelayDefault)
				.method_10454(class_1802.field_8725)
				.method_10442("has_item", method_10426(ModBlocks.lightRelayDefault))
				.method_10444(consumer);
		class_2450.method_10447(ModBlocks.lightRelayFork)
				.method_10454(ModBlocks.lightRelayDefault)
				.method_10454(class_1802.field_8530)
				.method_10442("has_item", method_10426(ModBlocks.lightRelayDefault))
				.method_10444(consumer);
		class_2450.method_10447(ModBlocks.lightRelayToggle)
				.method_10454(ModBlocks.lightRelayDefault)
				.method_10454(class_1802.field_8865)
				.method_10442("has_item", method_10426(ModBlocks.lightRelayDefault))
				.method_10444(consumer);
		class_2447.method_10437(ModBlocks.lightLauncher)
				.method_10434('D', ModBlocks.dreamwood)
				.method_10434('L', ModBlocks.lightRelayDefault)
				.method_10439("DDD")
				.method_10439("DLD")
				.method_10429("has_item", method_10426(ModBlocks.lightRelayDefault))
				.method_10431(consumer);
		class_2447.method_10437(ModBlocks.manaBomb)
				.method_10434('T', class_1802.field_8626)
				.method_10434('G', ModItems.lifeEssence)
				.method_10433('L', ModTags.Items.LIVINGWOOD)
				.method_10439("LTL")
				.method_10439("TGT")
				.method_10439("LTL")
				.method_10429("has_item", method_10426(ModItems.lifeEssence))
				.method_10431(consumer);
		class_2447.method_10437(ModBlocks.bellows)
				.method_10433('R', ModTags.Items.RUNES_AIR)
				.method_10434('S', ModFluffBlocks.livingwoodSlab)
				.method_10434('L', class_1802.field_8745)
				.method_10439("SSS")
				.method_10439("RL ")
				.method_10439("SSS")
				.method_10429("has_item", method_10420(ModTags.Items.RUNES_AIR))
				.method_10431(consumer);
		class_2450.method_10447(ModBlocks.bifrostPerm)
				.method_10454(ModItems.rainbowRod)
				.method_10454(ModBlocks.elfGlass)
				.method_10442("has_item", method_10426(ModItems.rainbowRod))
				.method_10444(consumer);
		class_2450.method_10448(ModBlocks.cellBlock, 3)
				.method_10449(class_1802.field_17520, 3)
				.method_10454(class_1802.field_8186)
				.method_10454(class_1802.field_8179)
				.method_10454(class_1802.field_8567)
				.method_10442("has_item", method_10426(ModSubtiles.dandelifeon))
				.method_10444(consumer);
		class_2447.method_10437(ModBlocks.teruTeruBozu)
				.method_10434('C', ModItems.manaweaveCloth)
				.method_10434('S', class_1802.field_17525)
				.method_10439("C")
				.method_10439("C")
				.method_10439("S")
				.method_10429("has_item", method_10426(ModItems.manaweaveCloth))
				.method_10431(consumer);
		class_2447.method_10437(ModBlocks.avatar)
				.method_10433('D', ModTags.Items.GEMS_MANA_DIAMOND)
				.method_10433('W', ModTags.Items.LIVINGWOOD)
				.method_10439(" W ")
				.method_10439("WDW")
				.method_10439("W W")
				.method_10429("has_item", method_10420(ModTags.Items.GEMS_MANA_DIAMOND))
				.method_10431(consumer);
		class_2447.method_10437(ModBlocks.animatedTorch)
				.method_10433('D', ModTags.Items.DUSTS_MANA)
				.method_10434('T', class_1802.field_8530)
				.method_10439("D")
				.method_10439("T")
				.method_10429("has_item", method_10426(class_1802.field_8530))
				.method_10429("has_alt_item", method_10420(ModTags.Items.DUSTS_MANA))
				.method_10431(consumer);
		class_2447.method_10437(ModItems.livingwoodTwig)
				.method_10433('W', ModTags.Items.LIVINGWOOD)
				.method_10439("W")
				.method_10439("W")
				.method_10429("has_item", method_10420(ModTags.Items.LIVINGWOOD))
				.method_10431(consumer);
		class_2450.method_10447(ModItems.redstoneRoot)
				.method_10454(class_1802.field_8725)
				.method_10451(class_1856.method_8091(class_1802.field_8471, class_1802.field_8602))
				.method_10442("has_item", method_10426(class_1802.field_8725))
				.method_10444(consumer);
		class_2447.method_10437(ModItems.dreamwoodTwig)
				.method_10434('W', ModBlocks.dreamwood)
				.method_10439("W")
				.method_10439("W")
				.method_10429("has_item", method_10426(ModBlocks.dreamwood))
				.method_10431(consumer);
		class_2447.method_10437(ModItems.gaiaIngot)
				.method_10434('S', ModItems.lifeEssence)
				.method_10433('I', ModTags.Items.INGOTS_TERRASTEEL)
				.method_10439(" S ")
				.method_10439("SIS")
				.method_10439(" S ")
				.method_10429("has_item", method_10426(ModItems.lifeEssence))
				.method_10431(consumer);
		class_2447.method_10437(ModItems.manaweaveCloth)
				.method_10434('S', ModItems.manaString)
				.method_10439("SS")
				.method_10439("SS")
				.method_10429("has_item", method_10426(ModItems.manaString))
				.method_10431(consumer);
		class_1856 dyes = class_1856.method_8091(class_1802.field_8446, class_1802.field_8492, class_1802.field_8669,
				class_1802.field_8273, class_1802.field_8192, class_1802.field_8131, class_1802.field_8330, class_1802.field_8298,
				class_1802.field_8851, class_1802.field_8632, class_1802.field_8296, class_1802.field_8345, class_1802.field_8099,
				class_1802.field_8408, class_1802.field_8264, class_1802.field_8226);
		class_2450.method_10447(ModItems.fertilizer)
				.method_10454(class_1802.field_8324)
				.method_10453(dyes, 4)
				.method_10442("has_item", hasAnyDye)
				.method_10450(consumer, "botania:fertilizer_dye");
		class_2450.method_10447(ModItems.drySeeds)
				.method_10454(ModItems.grassSeeds)
				.method_10454(class_1802.field_8689)
				.method_10452("botania:seeds")
				.method_10442("has_item", method_10426(ModItems.grassSeeds))
				.method_10444(consumer);
		class_2450.method_10447(ModItems.goldenSeeds)
				.method_10454(ModItems.grassSeeds)
				.method_10454(class_1802.field_8861)
				.method_10452("botania:seeds")
				.method_10442("has_item", method_10426(ModItems.grassSeeds))
				.method_10444(consumer);
		class_2450.method_10447(ModItems.vividSeeds)
				.method_10454(ModItems.grassSeeds)
				.method_10454(class_1802.field_8408)
				.method_10452("botania:seeds")
				.method_10442("has_item", method_10426(ModItems.grassSeeds))
				.method_10444(consumer);
		class_2450.method_10447(ModItems.scorchedSeeds)
				.method_10454(ModItems.grassSeeds)
				.method_10454(class_1802.field_8183)
				.method_10452("botania:seeds")
				.method_10442("has_item", method_10426(ModItems.grassSeeds))
				.method_10444(consumer);
		class_2450.method_10447(ModItems.infusedSeeds)
				.method_10454(ModItems.grassSeeds)
				.method_10454(class_1802.field_8662)
				.method_10452("botania:seeds")
				.method_10442("has_item", method_10426(ModItems.grassSeeds))
				.method_10444(consumer);
		class_2450.method_10447(ModItems.mutatedSeeds)
				.method_10454(ModItems.grassSeeds)
				.method_10454(class_1802.field_8680)
				.method_10452("botania:seeds")
				.method_10442("has_item", method_10426(ModItems.grassSeeds))
				.method_10444(consumer);
		class_2447.method_10436(ModItems.darkQuartz, 8)
				.method_10434('Q', class_1802.field_8155)
				.method_10428('C', class_1856.method_8091(class_1802.field_8713, class_1802.field_8665))
				.method_10439("QQQ")
				.method_10439("QCQ")
				.method_10439("QQQ")
				.method_10429("has_item", method_10426(class_1802.field_8155))
				.method_10431(consumer);
		class_2447.method_10436(ModItems.blazeQuartz, 8)
				.method_10434('Q', class_1802.field_8155)
				.method_10434('C', class_1802.field_8183)
				.method_10439("QQQ")
				.method_10439("QCQ")
				.method_10439("QQQ")
				.method_10429("has_item", method_10426(class_1802.field_8155))
				.method_10431(consumer);
		class_2447.method_10436(ModItems.lavenderQuartz, 8)
				.method_10434('Q', class_1802.field_8155)
				.method_10428('C', class_1856.method_8091(class_1802.field_17500, class_1802.field_17511, class_1802.field_17526, class_1802.field_17529))
				.method_10439("QQQ")
				.method_10439("QCQ")
				.method_10439("QQQ")
				.method_10429("has_item", method_10426(class_1802.field_8155))
				.method_10431(consumer);
		class_2447.method_10436(ModItems.redQuartz, 8)
				.method_10434('Q', class_1802.field_8155)
				.method_10434('C', class_1802.field_8725)
				.method_10439("QQQ")
				.method_10439("QCQ")
				.method_10439("QQQ")
				.method_10429("has_item", method_10426(class_1802.field_8155))
				.method_10431(consumer);
		class_2447.method_10436(ModItems.sunnyQuartz, 8)
				.method_10434('Q', class_1802.field_8155)
				.method_10434('C', class_1802.field_17525)
				.method_10439("QQQ")
				.method_10439("QCQ")
				.method_10439("QQQ")
				.method_10429("has_item", method_10426(class_1802.field_8155))
				.method_10431(consumer);
		class_2447.method_10437(ModItems.vineBall)
				.method_10434('V', class_1802.field_17523)
				.method_10439("VVV")
				.method_10439("VVV")
				.method_10439("VVV")
				.method_10429("has_item", method_10426(class_1802.field_17523))
				.method_10431(consumer);
		class_2450.method_10447(ModItems.necroVirus)
				.method_10454(ModItems.pixieDust)
				.method_10454(ModItems.vineBall)
				.method_10454(class_1802.field_8135)
				.method_10454(class_1802.field_8711)
				.method_10454(class_1802.field_8449)
				.method_10454(class_1802.field_8470)
				.method_10442("has_item", method_10426(ModItems.pixieDust))
				.method_10442("has_alt_item", method_10426(class_1802.field_8470))
				.method_10444(consumer);
		class_2450.method_10447(ModItems.nullVirus)
				.method_10454(ModItems.pixieDust)
				.method_10454(ModItems.vineBall)
				.method_10454(class_1802.field_8135)
				.method_10454(class_1802.field_8711)
				.method_10454(class_1802.field_8449)
				.method_10454(class_1802.field_8398)
				.method_10442("has_item", method_10426(ModItems.pixieDust))
				.method_10442("has_alt_item", method_10426(class_1802.field_8398))
				.method_10444(consumer);
		class_2447.method_10437(ModItems.spark)
				.method_10433('P', ModTags.Items.PETALS)
				.method_10434('B', class_1802.field_8183)
				.method_10434('N', class_1802.field_8397)
				.method_10439(" P ")
				.method_10439("BNB")
				.method_10439(" P ")
				.method_10429("has_item", method_10426(class_1802.field_8183))
				.method_10431(consumer);
		class_2450.method_10447(ModItems.sparkUpgradeDispersive)
				.method_10454(ModItems.pixieDust)
				.method_10446(ModTags.Items.INGOTS_MANASTEEL)
				.method_10446(ModTags.Items.RUNES_WATER)
				.method_10452("botania:spark_upgrade")
				.method_10442("has_item", method_10426(ModItems.pixieDust))
				.method_10442("has_alt_item", method_10426(ModItems.spark))
				.method_10444(consumer);
		class_2450.method_10447(ModItems.sparkUpgradeDominant)
				.method_10454(ModItems.pixieDust)
				.method_10446(ModTags.Items.INGOTS_MANASTEEL)
				.method_10446(ModTags.Items.RUNES_FIRE)
				.method_10452("botania:spark_upgrade")
				.method_10442("has_item", method_10426(ModItems.pixieDust))
				.method_10442("has_alt_item", method_10426(ModItems.spark))
				.method_10444(consumer);
		class_2450.method_10447(ModItems.sparkUpgradeRecessive)
				.method_10454(ModItems.pixieDust)
				.method_10446(ModTags.Items.INGOTS_MANASTEEL)
				.method_10446(ModTags.Items.RUNES_EARTH)
				.method_10452("botania:spark_upgrade")
				.method_10442("has_item", method_10426(ModItems.pixieDust))
				.method_10442("has_alt_item", method_10426(ModItems.spark))
				.method_10444(consumer);
		class_2450.method_10447(ModItems.sparkUpgradeIsolated)
				.method_10454(ModItems.pixieDust)
				.method_10446(ModTags.Items.INGOTS_MANASTEEL)
				.method_10446(ModTags.Items.RUNES_AIR)
				.method_10452("botania:spark_upgrade")
				.method_10442("has_item", method_10426(ModItems.pixieDust))
				.method_10442("has_alt_item", method_10426(ModItems.spark))
				.method_10444(consumer);
		class_2447.method_10436(ModItems.vial, 3)
				.method_10434('G', ModBlocks.manaGlass)
				.method_10439("G G")
				.method_10439(" G ")
				.method_10429("has_item", method_10426(ModBlocks.manaGlass))
				.method_10429("has_alt_item", method_10426(ModBlocks.brewery))
				.method_10431(consumer);
		class_2447.method_10436(ModItems.flask, 3)
				.method_10434('G', ModBlocks.elfGlass)
				.method_10439("G G")
				.method_10439(" G ")
				.method_10429("has_item", method_10426(ModBlocks.elfGlass))
				.method_10431(consumer);
		class_2447.method_10436(ModItems.worldSeed, 4)
				.method_10434('S', class_1802.field_8317)
				.method_10433('D', ModTags.Items.GEMS_DRAGONSTONE)
				.method_10434('G', class_1802.field_8270)
				.method_10439("G")
				.method_10439("S")
				.method_10439("D")
				.method_10429("has_item", method_10420(ModTags.Items.GEMS_DRAGONSTONE))
				.method_10431(consumer);
		class_2447.method_10436(ModItems.thornChakram, 2)
				.method_10433('T', ModTags.Items.INGOTS_TERRASTEEL)
				.method_10434('V', class_1802.field_17523)
				.method_10439("VVV")
				.method_10439("VTV")
				.method_10439("VVV")
				.method_10429("has_item", method_10420(ModTags.Items.INGOTS_TERRASTEEL))
				.method_10431(consumer);
		class_2447.method_10436(ModItems.flareChakram, 2)
				.method_10434('P', ModItems.pixieDust)
				.method_10434('B', class_1802.field_8183)
				.method_10434('C', ModItems.thornChakram)
				.method_10439("BBB")
				.method_10439("CPC")
				.method_10439("BBB")
				.method_10429("has_item", method_10426(ModItems.thornChakram))
				.method_10431(consumer);
		class_2450.method_10448(ModItems.phantomInk, 4)
				.method_10454(ModItems.manaPearl)
				.method_10451(class_1856.method_8091(
						Arrays.stream(class_1767.values()).map(class_1769::method_7803).toArray(class_1935[]::new)
				))
				.method_10451(class_1856.method_8091(class_1802.field_8280, class_1802.field_8483, class_1802.field_8393,
						class_1802.field_8243, class_1802.field_8869, class_1802.field_8095,
						class_1802.field_8340, class_1802.field_8770, class_1802.field_8507,
						class_1802.field_8363, class_1802.field_8685, class_1802.field_8838,
						class_1802.field_8126, class_1802.field_8332, class_1802.field_8734,
						class_1802.field_8636, class_1802.field_8410))
				.method_10449(class_1802.field_8469, 4)
				.method_10442("has_item", method_10426(ModItems.manaPearl))
				.method_10444(consumer);
		class_2450.method_10447(ModItems.keepIvy)
				.method_10454(ModItems.pixieDust)
				.method_10454(class_1802.field_17523)
				.method_10454(ModItems.enderAirBottle)
				.method_10442("has_item", method_10426(ModItems.enderAirBottle))
				.method_10444(consumer);

	}

	private void registerMisc(Consumer<class_2444> consumer) {
		class_1856 mushrooms = class_1856.method_8091(ModBlocks.whiteMushroom, ModBlocks.orangeMushroom,
				ModBlocks.magentaMushroom, ModBlocks.lightBlueMushroom, ModBlocks.yellowMushroom,
				ModBlocks.limeMushroom, ModBlocks.pinkMushroom, ModBlocks.grayMushroom, ModBlocks.lightGrayMushroom,
				ModBlocks.cyanMushroom, ModBlocks.purpleMushroom, ModBlocks.blueMushroom, ModBlocks.brownMushroom,
				ModBlocks.greenMushroom, ModBlocks.redMushroom, ModBlocks.blackMushroom);
		class_2450.method_10447(class_1802.field_8208)
				.method_10453(mushrooms, 2)
				.method_10454(class_1802.field_8428)
				.method_10442("has_item", method_10426(class_1802.field_8428))
				.method_10442("has_orig_recipe", class_2119.method_27847(new class_2960("mushroom_stew")))
				.method_10450(consumer, "botania:mushroom_stew");

		class_2447.method_10437(class_1802.field_8786)
				.method_10434('S', class_1802.field_8276)
				.method_10434('M', ModItems.manaString)
				.method_10439("S S")
				.method_10439(" M ")
				.method_10439("S S")
				.method_10429("has_item", method_10426(ModItems.manaString))
				.method_10430(consumer, prefix("cobweb"));

		class_2447.method_10437(ModBlocks.defaultAltar)
				.method_10433('P', ModTags.Items.PETALS)
				.method_10434('S', class_1802.field_8194)
				.method_10434('C', class_1802.field_20412)
				.method_10439("SPS")
				.method_10439(" C ")
				.method_10439("CCC")
				.method_10429("has_item", method_10420(ModTags.Items.PETALS))
				.method_10431(consumer);
		for (String metamorphicVariant : LibBlockNames.METAMORPHIC_VARIANTS) {
			class_2248 altar = class_2378.field_11146.method_17966(prefix("apothecary_" + metamorphicVariant.replaceAll("_", ""))).get();
			class_2248 cobble = class_2378.field_11146.method_17966(prefix(LibBlockNames.METAMORPHIC_PREFIX + metamorphicVariant + "_cobblestone")).get();
			class_2447.method_10437(altar)
					.method_10434('A', ModBlocks.defaultAltar)
					.method_10434('S', cobble)
					.method_10439("SSS")
					.method_10439("SAS")
					.method_10439("SSS")
					.method_10435("botania:metamorphic_apothecary")
					.method_10429("has_item", method_10426(cobble))
					.method_10429("has_flower_item", method_10426(ModSubtiles.marimorphosis))
					.method_10431(consumer);
		}
		for (class_1767 color : class_1767.values()) {
			class_2450.method_10447(ModBlocks.getShinyFlower(color))
					.method_10454(class_1802.field_8601)
					.method_10454(class_1802.field_8601)
					.method_10454(ModBlocks.getFlower(color))
					.method_10452("botania:shiny_flower")
					.method_10442("has_item", method_10426(ModBlocks.getFlower(color)))
					.method_10444(consumer);
			class_2447.method_10437(ModBlocks.getFloatingFlower(color))
					.method_10434('S', ModItems.grassSeeds)
					.method_10434('D', class_1802.field_8831)
					.method_10434('F', ModBlocks.getShinyFlower(color))
					.method_10439("F")
					.method_10439("S")
					.method_10439("D")
					.method_10435("botania:floating_flowers")
					.method_10429("has_item", method_10426(ModBlocks.getShinyFlower(color)))
					.method_10431(consumer);
			class_2447.method_10437(ModBlocks.getPetalBlock(color))
					.method_10434('P', ModItems.getPetal(color))
					.method_10439("PPP")
					.method_10439("PPP")
					.method_10439("PPP")
					.method_10435("botania:petal_block")
					.method_10429("has_item", method_10426(ModItems.getPetal(color)))
					.method_10431(consumer);
			class_2450.method_10447(ModBlocks.getMushroom(color))
					.method_10451(class_1856.method_8091(class_1802.field_17517, class_1802.field_17516))
					.method_10454(class_1769.method_7803(color))
					.method_10452("botania:mushroom")
					.method_10442("has_item", method_10426(class_1802.field_17517))
					.method_10442("has_alt_item", method_10426(class_1802.field_17516))
					.method_10450(consumer, "botania:mushroom_" + color.ordinal());
			class_2450.method_10448(ModItems.getPetal(color), 4)
					.method_10454(ModBlocks.getDoubleFlower(color))
					.method_10452("botania:petal_double")
					.method_10442("has_item", method_10426(ModBlocks.getDoubleFlower(color)))
					.method_10442("has_alt_item", method_10426(ModItems.getPetal(color)))
					.method_10450(consumer, "botania:petal_" + color.method_7792() + "_double");
			class_2450.method_10448(ModItems.getPetal(color), 2)
					.method_10454(ModBlocks.getFlower(color))
					.method_10452("botania:petal")
					.method_10442("has_item", method_10426(ModBlocks.getFlower(color)))
					.method_10442("has_alt_item", method_10426(ModItems.getPetal(color)))
					.method_10450(consumer, "botania:petal_" + color.method_7792());
			class_2450.method_10447(class_1769.method_7803(color))
					.method_10451(class_1856.method_8106(ModTags.Items.getPetalTag(color)))
					.method_10454(ModItems.pestleAndMortar)
					.method_10452("botania:dye")
					.method_10442("has_item", method_10426(ModItems.getPetal(color)))
					.method_10450(consumer, "botania:dye_" + color.method_7792());
		}
	}

	private void registerTools(Consumer<class_2444> consumer) {
		class_2450.method_10447(ModItems.lexicon)
				.method_10446(class_3489.field_15528)
				.method_10454(class_1802.field_8529)
				.method_10442("has_item", method_10420(class_3489.field_15528))
				.method_10442("has_alt_item", method_10426(class_1802.field_8529))
				.method_10444(consumer);
		class_2447.method_10437(ModItems.twigWand)
				.method_10433('P', ModTags.Items.PETALS)
				.method_10434('S', ModItems.livingwoodTwig)
				.method_10439(" PS")
				.method_10439(" SP")
				.method_10439("S  ")
				.method_10435("botania:twig_wand")
				.method_10429("has_item", method_10420(ModTags.Items.PETALS))
				.method_10431(WrapperResult.ofType(TwigWandRecipe.SERIALIZER, consumer));
		class_2447.method_10437(ModItems.manaTablet)
				.method_10428('P', AccessorIngredient.botania_ofEntries(Stream.of(
						new class_1856.class_1857(new class_1799(ModItems.manaPearl)),
						new class_1856.class_1858(ModTags.Items.GEMS_MANA_DIAMOND))))
				.method_10433('S', ModTags.Items.LIVINGROCK)
				.method_10439("SSS")
				.method_10439("SPS")
				.method_10439("SSS")
				.method_10429("has_item", method_10420(ModTags.Items.GEMS_MANA_DIAMOND))
				.method_10431(consumer);

		class_2447.method_10437(ModItems.cacophonium)
				.method_10434('N', class_1802.field_8643)
				.method_10434('G', class_1802.field_8695)
				.method_10439(" G ")
				.method_10439("GNG")
				.method_10439("GG ")
				.method_10429("has_item", method_10426(class_1802.field_8643))
				.method_10431(consumer);

		class_2447.method_10437(ModItems.grassHorn)
				.method_10434('S', ModItems.grassSeeds)
				.method_10433('W', ModTags.Items.LIVINGWOOD)
				.method_10439(" W ")
				.method_10439("WSW")
				.method_10439("WW ")
				.method_10429("has_item", method_10420(ModTags.Items.LIVINGWOOD))
				.method_10431(consumer);
		class_2450.method_10447(ModItems.leavesHorn)
				.method_10454(ModItems.grassHorn)
				.method_10446(class_3489.field_15558)
				.method_10442("has_item", method_10426(ModItems.grassHorn))
				.method_10444(consumer);
		class_2450.method_10447(ModItems.snowHorn)
				.method_10454(ModItems.grassHorn)
				.method_10454(class_1802.field_8543)
				.method_10442("has_item", method_10426(ModItems.grassHorn))
				.method_10444(consumer);
		class_2447.method_10437(ModItems.manaMirror)
				.method_10434('P', ModItems.manaPearl)
				.method_10433('R', ModTags.Items.LIVINGROCK)
				.method_10434('S', ModItems.livingwoodTwig)
				.method_10434('T', ModItems.manaTablet)
				.method_10433('I', ModTags.Items.INGOTS_TERRASTEEL)
				.method_10439(" PR")
				.method_10439(" SI")
				.method_10439("T  ")
				.method_10429("has_item", method_10426(ModItems.manaTablet))
				.method_10429("has_alt_item", method_10420(ModTags.Items.INGOTS_TERRASTEEL))
				.method_10431(consumer);
		class_2447.method_10437(ModItems.openBucket)
				.method_10433('E', ModTags.Items.INGOTS_ELEMENTIUM)
				.method_10439("E E")
				.method_10439(" E ")
				.method_10429("has_item", method_10420(ModTags.Items.INGOTS_ELEMENTIUM))
				.method_10431(consumer);
		class_2447.method_10437(ModItems.spawnerMover)
				.method_10434('A', ModItems.enderAirBottle)
				.method_10433('D', ModTags.Items.GEMS_DRAGONSTONE)
				.method_10434('E', ModItems.lifeEssence)
				.method_10433('I', ModTags.Items.INGOTS_ELEMENTIUM)
				.method_10439("EIE")
				.method_10439("ADA")
				.method_10439("EIE")
				.method_10429("has_item", method_10426(ModItems.lifeEssence))
				.method_10431(consumer);
		class_2447.method_10437(ModItems.slingshot)
				.method_10433('A', ModTags.Items.RUNES_AIR)
				.method_10434('T', ModItems.livingwoodTwig)
				.method_10439(" TA")
				.method_10439(" TT")
				.method_10439("T  ")
				.method_10429("has_item", method_10420(ModTags.Items.RUNES_AIR))
				.method_10431(consumer);

		registerSimpleArmorSet(consumer, class_1856.method_8106(ModTags.Items.INGOTS_MANASTEEL), "manasteel", method_10420(ModTags.Items.INGOTS_MANASTEEL));
		registerSimpleArmorSet(consumer, class_1856.method_8106(ModTags.Items.INGOTS_ELEMENTIUM), "elementium", method_10420(ModTags.Items.INGOTS_ELEMENTIUM));
		registerSimpleArmorSet(consumer, class_1856.method_8091(ModItems.manaweaveCloth), "manaweave", method_10426(ModItems.manaweaveCloth));

		registerTerrasteelUpgradeRecipe(consumer, ModItems.terrasteelHelm, ModItems.manasteelHelm, ModTags.Items.RUNES_SPRING);
		registerTerrasteelUpgradeRecipe(consumer, ModItems.terrasteelChest, ModItems.manasteelChest, ModTags.Items.RUNES_SUMMER);
		registerTerrasteelUpgradeRecipe(consumer, ModItems.terrasteelLegs, ModItems.manasteelLegs, ModTags.Items.RUNES_AUTUMN);
		registerTerrasteelUpgradeRecipe(consumer, ModItems.terrasteelBoots, ModItems.manasteelBoots, ModTags.Items.RUNES_WINTER);

		registerToolSetRecipes(consumer, class_1856.method_8106(ModTags.Items.INGOTS_MANASTEEL), class_1856.method_8091(ModItems.livingwoodTwig),
				method_10420(ModTags.Items.INGOTS_MANASTEEL), ModItems.manasteelSword, ModItems.manasteelPick, ModItems.manasteelAxe,
				ModItems.manasteelShovel, ModItems.manasteelShears);
		registerToolSetRecipes(consumer, class_1856.method_8106(ModTags.Items.INGOTS_ELEMENTIUM), class_1856.method_8091(ModItems.dreamwoodTwig),
				method_10420(ModTags.Items.INGOTS_ELEMENTIUM), ModItems.elementiumSword, ModItems.elementiumPick, ModItems.elementiumAxe,
				ModItems.elementiumShovel, ModItems.elementiumShears);

		class_2447.method_10437(ModItems.terraSword)
				.method_10434('S', ModItems.livingwoodTwig)
				.method_10433('I', ModTags.Items.INGOTS_TERRASTEEL)
				.method_10439("I")
				.method_10439("I")
				.method_10439("S")
				.method_10429("has_item", method_10420(ModTags.Items.INGOTS_TERRASTEEL))
				.method_10431(consumer);
		class_2447.method_10437(ModItems.terraPick)
				.method_10434('T', ModItems.manaTablet)
				.method_10433('I', ModTags.Items.INGOTS_TERRASTEEL)
				.method_10434('L', ModItems.livingwoodTwig)
				.method_10439("ITI")
				.method_10439("ILI")
				.method_10439(" L ")
				.method_10429("has_item", method_10420(ModTags.Items.INGOTS_TERRASTEEL))
				.method_10431(WrapperResult.ofType(ManaUpgradeRecipe.SERIALIZER, consumer));
		class_2447.method_10437(ModItems.terraAxe)
				.method_10434('S', ModItems.livingwoodTwig)
				.method_10433('T', ModTags.Items.INGOTS_TERRASTEEL)
				.method_10434('G', class_1802.field_8801)
				.method_10439("TTG")
				.method_10439("TST")
				.method_10439(" S ")
				.method_10429("has_item", method_10420(ModTags.Items.INGOTS_TERRASTEEL))
				.method_10431(consumer);
		class_2447.method_10437(ModItems.starSword)
				.method_10434('A', ModItems.enderAirBottle)
				.method_10433('D', ModTags.Items.GEMS_DRAGONSTONE)
				.method_10434('T', ModItems.terraSword)
				.method_10433('I', ModTags.Items.INGOTS_ELEMENTIUM)
				.method_10439("  I")
				.method_10439("AD ")
				.method_10439("TA ")
				.method_10429("has_item", method_10426(ModItems.terraAxe))
				.method_10429("has_terrasteel", method_10420(ModTags.Items.INGOTS_TERRASTEEL))
				.method_10431(consumer);
		class_2447.method_10437(ModItems.thunderSword)
				.method_10434('A', ModItems.enderAirBottle)
				.method_10433('D', ModTags.Items.GEMS_MANA_DIAMOND)
				.method_10434('T', ModItems.terraSword)
				.method_10433('I', ModTags.Items.INGOTS_ELEMENTIUM)
				.method_10439("  I")
				.method_10439("AD ")
				.method_10439("TA ")
				.method_10429("has_item", method_10426(ModItems.terraAxe))
				.method_10429("has_terrasteel", method_10420(ModTags.Items.INGOTS_TERRASTEEL))
				.method_10431(consumer);
		class_2447.method_10437(ModItems.glassPick)
				.method_10434('T', ModItems.livingwoodTwig)
				.method_10434('G', class_1802.field_8280)
				.method_10433('I', ModTags.Items.INGOTS_MANASTEEL)
				.method_10439("GIG")
				.method_10439(" T ")
				.method_10439(" T ")
				.method_10429("has_item", method_10420(ModTags.Items.INGOTS_MANASTEEL))
				.method_10431(consumer);
		class_2447.method_10437(ModItems.livingwoodBow)
				.method_10434('S', ModItems.manaString)
				.method_10434('T', ModItems.livingwoodTwig)
				.method_10439(" TS")
				.method_10439("T S")
				.method_10439(" TS")
				.method_10429("has_item", method_10426(ModItems.manaString))
				.method_10429("has_twig", method_10426(ModItems.livingwoodTwig))
				.method_10431(consumer);
		class_2447.method_10437(ModItems.crystalBow)
				.method_10434('S', ModItems.manaString)
				.method_10434('T', ModItems.livingwoodTwig)
				.method_10433('D', ModTags.Items.GEMS_DRAGONSTONE)
				.method_10439(" DS")
				.method_10439("T S")
				.method_10439(" DS")
				.method_10429("has_item", method_10420(ModTags.Items.GEMS_DRAGONSTONE))
				.method_10431(consumer);

		class_2447.method_10437(ModItems.enderDagger)
				.method_10434('P', ModItems.manaPearl)
				.method_10433('S', ModTags.Items.INGOTS_MANASTEEL)
				.method_10434('T', ModItems.livingwoodTwig)
				.method_10439("P")
				.method_10439("S")
				.method_10439("T")
				.method_10429("has_item", method_10426(ModItems.manaPearl))
				.method_10431(consumer);
		class_2447.method_10437(ModItems.enderHand)
				.method_10434('P', ModItems.manaPearl)
				.method_10434('E', class_1802.field_8466)
				.method_10434('L', class_1802.field_8745)
				.method_10434('O', class_1802.field_8281)
				.method_10439("PLO")
				.method_10439("LEL")
				.method_10439("OL ")
				.method_10429("has_item", method_10426(class_1802.field_8466))
				.method_10429("has_alt_item", method_10426(class_1802.field_8449))
				.method_10431(consumer);

		class_2450.method_10448(ModItems.placeholder, 32)
				.method_10454(class_1802.field_8465)
				.method_10446(ModTags.Items.LIVINGROCK)
				.method_10442("has_dreamwood", method_10426(ModBlocks.dreamwood))
				.method_10442("has_crafty_crate", method_10426(ModBlocks.craftCrate))
				.method_10444(consumer);

		for (CratePattern pattern : CratePattern.values()) {
			if (pattern == CratePattern.NONE) {
				continue;
			}
			class_1792 item = class_2378.field_11142.method_17966(prefix(LibItemNames.CRAFT_PATTERN_PREFIX + pattern.method_15434().split("_", 2)[1])).get();
			String s = pattern.openSlots.stream().map(bool -> bool ? "R" : "P").collect(Collectors.joining());
			class_2447.method_10437(item)
					.method_10434('P', ModItems.placeholder)
					.method_10434('R', class_1802.field_8725)
					.method_10439(s.substring(0, 3))
					.method_10439(s.substring(3, 6))
					.method_10439(s.substring(6, 9))
					.method_10435("botania:craft_pattern")
					.method_10429("has_item", method_10426(ModItems.placeholder))
					.method_10429("has_crafty_crate", method_10426(ModBlocks.craftCrate))
					.method_10431(consumer);
		}

		class_2447.method_10437(ModItems.pestleAndMortar)
				.method_10434('B', class_1802.field_8428)
				.method_10434('S', class_1802.field_8600)
				.method_10433('W', class_3489.field_15537)
				.method_10439(" S")
				.method_10439("W ")
				.method_10439("B ")
				.method_10429("has_item", method_10420(class_3489.field_15537))
				.method_10431(consumer);
		class_2447.method_10437(ModItems.manaGun)
				.method_10434('S', ModBlocks.redstoneSpreader)
				.method_10433('D', ModTags.Items.GEMS_MANA_DIAMOND)
				.method_10434('T', class_1802.field_8626)
				.method_10433('W', ModTags.Items.LIVINGWOOD)
				.method_10433('M', ModTags.Items.RUNES_MANA)
				.method_10439("SMD")
				.method_10439(" WT")
				.method_10439("  W")
				.method_10429("has_item", method_10420(ModTags.Items.GEMS_MANA_DIAMOND))
				.method_10431(consumer);

		class_2447.method_10437(ModItems.dirtRod)
				.method_10434('D', class_1802.field_8831)
				.method_10434('T', ModItems.livingwoodTwig)
				.method_10433('E', ModTags.Items.RUNES_EARTH)
				.method_10439("  D")
				.method_10439(" T ")
				.method_10439("E  ")
				.method_10429("has_item", method_10420(ModTags.Items.RUNES_EARTH))
				.method_10431(consumer);
		class_2447.method_10437(ModItems.terraformRod)
				.method_10433('A', ModTags.Items.RUNES_AUTUMN)
				.method_10434('R', ModItems.dirtRod)
				.method_10433('S', ModTags.Items.RUNES_SPRING)
				.method_10433('T', ModTags.Items.INGOTS_TERRASTEEL)
				.method_10434('G', ModItems.grassSeeds)
				.method_10433('W', ModTags.Items.RUNES_WINTER)
				.method_10433('M', ModTags.Items.RUNES_SUMMER)
				.method_10439(" WT")
				.method_10439("ARS")
				.method_10439("GM ")
				.method_10429("has_item", method_10420(ModTags.Items.INGOTS_TERRASTEEL))
				.method_10431(consumer);

		// todo 1.16-fabric fuzzynbt for water bottle
		class_2447.method_10437(ModItems.waterRod)
				.method_10428('B', class_1856.method_8101(class_1844.method_8061(new class_1799(class_1802.field_8574), class_1847.field_8991)))
				.method_10433('R', ModTags.Items.RUNES_WATER)
				.method_10434('T', ModItems.livingwoodTwig)
				.method_10439("  B")
				.method_10439(" T ")
				.method_10439("R  ")
				.method_10429("has_item", method_10420(ModTags.Items.RUNES_WATER))
				.method_10431(consumer);

		class_2447.method_10437(ModItems.rainbowRod)
				.method_10434('P', ModItems.pixieDust)
				.method_10433('D', ModTags.Items.GEMS_DRAGONSTONE)
				.method_10433('E', ModTags.Items.INGOTS_ELEMENTIUM)
				.method_10439(" PD")
				.method_10439(" EP")
				.method_10439("E  ")
				.method_10429("has_item", method_10420(ModTags.Items.GEMS_DRAGONSTONE))
				.method_10431(consumer);
		class_2447.method_10437(ModItems.tornadoRod)
				.method_10433('R', ModTags.Items.RUNES_AIR)
				.method_10434('T', ModItems.livingwoodTwig)
				.method_10434('F', class_1802.field_8153)
				.method_10439("  F")
				.method_10439(" T ")
				.method_10439("R  ")
				.method_10429("has_item", method_10420(ModTags.Items.RUNES_AIR))
				.method_10431(consumer);
		class_2447.method_10437(ModItems.fireRod)
				.method_10433('R', ModTags.Items.RUNES_FIRE)
				.method_10434('T', ModItems.livingwoodTwig)
				.method_10434('F', class_1802.field_8183)
				.method_10439("  F")
				.method_10439(" T ")
				.method_10439("R  ")
				.method_10429("has_item", method_10420(ModTags.Items.RUNES_FIRE))
				.method_10431(consumer);
		class_2450.method_10447(ModItems.skyDirtRod)
				.method_10454(ModItems.dirtRod)
				.method_10454(ModItems.pixieDust)
				.method_10446(ModTags.Items.RUNES_AIR)
				.method_10442("has_item", method_10426(ModItems.pixieDust))
				.method_10444(consumer);

		class_2447.method_10437(ModItems.diviningRod)
				.method_10434('T', ModItems.livingwoodTwig)
				.method_10433('D', ModTags.Items.GEMS_MANA_DIAMOND)
				.method_10439(" TD")
				.method_10439(" TT")
				.method_10439("T  ")
				.method_10429("has_item", method_10420(ModTags.Items.GEMS_MANA_DIAMOND))
				.method_10431(consumer);
		class_2447.method_10437(ModItems.gravityRod)
				.method_10434('T', ModItems.dreamwoodTwig)
				.method_10433('D', ModTags.Items.GEMS_DRAGONSTONE)
				.method_10434('W', class_1802.field_8861)
				.method_10439(" TD")
				.method_10439(" WT")
				.method_10439("T  ")
				.method_10429("has_item", method_10420(ModTags.Items.GEMS_DRAGONSTONE))
				.method_10431(consumer);

		class_2447.method_10437(ModItems.missileRod)
				.method_10433('D', ModTags.Items.GEMS_DRAGONSTONE)
				.method_10434('T', ModItems.dreamwoodTwig)
				.method_10434('G', ModItems.lifeEssence)
				.method_10439("GDD")
				.method_10439(" TD")
				.method_10439("T G")
				.method_10429("has_item", method_10426(ModItems.lifeEssence))
				.method_10431(consumer);
		class_2447.method_10437(ModItems.cobbleRod)
				.method_10434('C', class_1802.field_20412)
				.method_10434('T', ModItems.livingwoodTwig)
				.method_10433('F', ModTags.Items.RUNES_FIRE)
				.method_10433('W', ModTags.Items.RUNES_WATER)
				.method_10439(" FC")
				.method_10439(" TW")
				.method_10439("T  ")
				.method_10429("has_item", method_10420(ModTags.Items.RUNES_FIRE))
				.method_10429("has_alt_item", method_10420(ModTags.Items.RUNES_WATER))
				.method_10431(consumer);
		class_2447.method_10437(ModItems.smeltRod)
				.method_10434('B', class_1802.field_8894)
				.method_10434('T', ModItems.livingwoodTwig)
				.method_10433('F', ModTags.Items.RUNES_FIRE)
				.method_10439(" BF")
				.method_10439(" TB")
				.method_10439("T  ")
				.method_10429("has_item", method_10420(ModTags.Items.RUNES_FIRE))
				.method_10431(consumer);
		class_2447.method_10437(ModItems.exchangeRod)
				.method_10433('R', ModTags.Items.RUNES_SLOTH)
				.method_10434('S', class_1802.field_20391)
				.method_10434('T', ModItems.livingwoodTwig)
				.method_10439(" SR")
				.method_10439(" TS")
				.method_10439("T  ")
				.method_10429("has_item", method_10420(ModTags.Items.RUNES_SLOTH))
				.method_10431(consumer);

		class_2447.method_10437(ModItems.laputaShard)
				.method_10434('P', class_1802.field_8434)
				.method_10433('A', ModTags.Items.RUNES_AIR)
				.method_10434('S', ModItems.lifeEssence)
				.method_10433('D', ModTags.Items.GEMS_DRAGONSTONE)
				.method_10433('E', ModTags.Items.RUNES_EARTH)
				.method_10433('F', ModTags.Items.MUNDANE_FLOATING_FLOWERS)
				.method_10439("SFS")
				.method_10439("PDP")
				.method_10439("ASE")
				.method_10429("has_item", method_10426(ModItems.lifeEssence))
				.method_10431(consumer);

		class_2447.method_10437(ModItems.craftingHalo)
				.method_10434('P', ModItems.manaPearl)
				.method_10434('C', class_1802.field_8465)
				.method_10433('I', ModTags.Items.INGOTS_MANASTEEL)
				.method_10439(" P ")
				.method_10439("ICI")
				.method_10439(" I ")
				.method_10429("has_item", method_10426(ModItems.manaPearl))
				.method_10431(consumer);
		class_2447.method_10437(ModItems.clip)
				.method_10434('D', ModBlocks.dreamwood)
				.method_10439(" D ")
				.method_10439("D D")
				.method_10439("DD ")
				.method_10429("has_item", method_10426(ModBlocks.dreamwood))
				.method_10431(consumer);
		class_2447.method_10437(ModItems.spellCloth)
				.method_10434('P', ModItems.manaPearl)
				.method_10434('C', ModItems.manaweaveCloth)
				.method_10439(" C ")
				.method_10439("CPC")
				.method_10439(" C ")
				.method_10429("has_item", method_10426(ModItems.manaweaveCloth))
				.method_10431(consumer);
		class_2447.method_10437(ModItems.flowerBag)
				.method_10433('P', ModTags.Items.PETALS)
				.method_10433('W', class_3489.field_15544)
				.method_10439("WPW")
				.method_10439("W W")
				.method_10439(" W ")
				.method_10429("has_item", method_10420(ModTags.Items.MYSTICAL_FLOWERS))
				.method_10431(consumer);
		class_2450.method_10447(ModItems.poolMinecart)
				.method_10454(class_1802.field_8045)
				.method_10454(ModBlocks.manaPool)
				.method_10442("has_item", method_10426(class_1802.field_8045))
				.method_10444(consumer);
		class_2447.method_10437(ModItems.blackHoleTalisman)
				.method_10434('A', ModItems.enderAirBottle)
				.method_10433('E', ModTags.Items.INGOTS_ELEMENTIUM)
				.method_10434('G', ModItems.lifeEssence)
				.method_10439(" G ")
				.method_10439("EAE")
				.method_10439(" E ")
				.method_10429("has_item", method_10426(ModItems.lifeEssence))
				.method_10431(consumer);
		class_2447.method_10437(ModItems.temperanceStone)
				.method_10433('R', ModTags.Items.RUNES_EARTH)
				.method_10434('S', class_1802.field_20391)
				.method_10439(" S ")
				.method_10439("SRS")
				.method_10439(" S ")
				.method_10429("has_item", method_10420(ModTags.Items.RUNES_EARTH))
				.method_10431(consumer);
		class_2447.method_10437(ModItems.incenseStick)
				.method_10434('B', class_1802.field_8183)
				.method_10434('T', ModItems.livingwoodTwig)
				.method_10434('G', class_1802.field_8070)
				.method_10439("  G")
				.method_10439(" B ")
				.method_10439("T  ")
				.method_10429("has_item", method_10426(class_1802.field_8070))
				.method_10431(consumer);
		class_2447.method_10437(ModItems.obedienceStick)
				.method_10434('T', ModItems.livingwoodTwig)
				.method_10433('M', ModTags.Items.INGOTS_MANASTEEL)
				.method_10439("  M")
				.method_10439(" T ")
				.method_10439("T  ")
				.method_10429("has_item", method_10420(ModTags.Items.INGOTS_MANASTEEL))
				.method_10431(consumer);
		class_2447.method_10437(ModItems.slimeBottle)
				.method_10434('S', class_1802.field_8777)
				.method_10433('E', ModTags.Items.INGOTS_ELEMENTIUM)
				.method_10434('G', ModBlocks.elfGlass)
				.method_10439("EGE")
				.method_10439("ESE")
				.method_10439(" E ")
				.method_10429("has_item", method_10420(ModTags.Items.INGOTS_ELEMENTIUM))
				.method_10431(consumer);
		class_2450.method_10447(ModItems.autocraftingHalo)
				.method_10454(ModItems.craftingHalo)
				.method_10446(ModTags.Items.GEMS_MANA_DIAMOND)
				.method_10442("has_item", method_10420(ModTags.Items.GEMS_MANA_DIAMOND))
				.method_10444(consumer);
		class_2447.method_10437(ModItems.sextant)
				.method_10434('T', ModItems.livingwoodTwig)
				.method_10433('I', ModTags.Items.INGOTS_MANASTEEL)
				.method_10439(" TI")
				.method_10439(" TT")
				.method_10439("III")
				.method_10429("has_item", method_10420(ModTags.Items.INGOTS_MANASTEEL))
				.method_10431(consumer);
		class_2447.method_10437(ModItems.baubleBox)
				.method_10434('C', class_1802.field_8106)
				.method_10434('G', class_1802.field_8695)
				.method_10433('M', ModTags.Items.INGOTS_MANASTEEL)
				.method_10439(" M ")
				.method_10439("MCG")
				.method_10439(" M ")
				.method_10429("has_item", method_10420(ModTags.Items.INGOTS_MANASTEEL))
				.method_10431(consumer);
		class_2447.method_10437(ModItems.astrolabe)
				.method_10434('D', ModBlocks.dreamwood)
				.method_10433('E', ModTags.Items.INGOTS_ELEMENTIUM)
				.method_10434('G', ModItems.lifeEssence)
				.method_10439(" EG")
				.method_10439("EEE")
				.method_10439("GED")
				.method_10429("has_item", method_10426(ModItems.lifeEssence))
				.method_10431(consumer);

	}

	private void registerTrinkets(Consumer<class_2444> consumer) {
		class_2447.method_10437(ModItems.tinyPlanet)
				.method_10434('P', ModItems.manaPearl)
				.method_10434('S', class_1802.field_20391)
				.method_10433('L', ModTags.Items.LIVINGROCK)
				.method_10439("LSL")
				.method_10439("SPS")
				.method_10439("LSL")
				.method_10429("has_item", method_10426(ModItems.manaPearl))
				.method_10431(consumer);
		class_2447.method_10437(ModItems.manaRing)
				.method_10434('T', ModItems.manaTablet)
				.method_10434('I', ModItems.manaSteel)
				.method_10439("TI ")
				.method_10439("I I")
				.method_10439(" I ")
				.method_10429("has_item", method_10426(ModItems.manaTablet))
				.method_10431(WrapperResult.ofType(ManaUpgradeRecipe.SERIALIZER, consumer));
		class_2447.method_10437(ModItems.auraRing)
				.method_10433('R', ModTags.Items.RUNES_MANA)
				.method_10433('I', ModTags.Items.INGOTS_MANASTEEL)
				.method_10439("RI ")
				.method_10439("I I")
				.method_10439(" I ")
				.method_10429("has_item", method_10420(ModTags.Items.RUNES_MANA))
				.method_10431(consumer);
		class_2450.method_10447(ModItems.manaRingGreater)
				.method_10446(ModTags.Items.INGOTS_TERRASTEEL)
				.method_10454(ModItems.manaRing)
				.method_10442("has_item", method_10426(ModItems.terrasteel))
				.method_10444(WrapperResult.ofType(ShapelessManaUpgradeRecipe.SERIALIZER, consumer));
		class_2450.method_10447(ModItems.auraRingGreater)
				.method_10446(ModTags.Items.INGOTS_TERRASTEEL)
				.method_10454(ModItems.auraRing)
				.method_10442("has_item", method_10420(ModTags.Items.INGOTS_TERRASTEEL))
				.method_10444(consumer);
		class_2447.method_10437(ModItems.travelBelt)
				.method_10433('A', ModTags.Items.RUNES_AIR)
				.method_10433('S', ModTags.Items.INGOTS_MANASTEEL)
				.method_10433('E', ModTags.Items.RUNES_EARTH)
				.method_10434('L', class_1802.field_8745)
				.method_10439("EL ")
				.method_10439("L L")
				.method_10439("SLA")
				.method_10429("has_item", method_10420(ModTags.Items.INGOTS_MANASTEEL))
				.method_10431(consumer);
		class_2447.method_10437(ModItems.knockbackBelt)
				.method_10433('A', ModTags.Items.RUNES_FIRE)
				.method_10433('S', ModTags.Items.INGOTS_MANASTEEL)
				.method_10433('E', ModTags.Items.RUNES_EARTH)
				.method_10434('L', class_1802.field_8745)
				.method_10439("AL ")
				.method_10439("L L")
				.method_10439("SLE")
				.method_10429("has_item", method_10420(ModTags.Items.INGOTS_MANASTEEL))
				.method_10431(consumer);
		class_2447.method_10437(ModItems.icePendant)
				.method_10433('R', ModTags.Items.RUNES_WATER)
				.method_10434('S', ModItems.manaString)
				.method_10433('W', ModTags.Items.RUNES_WINTER)
				.method_10433('M', ModTags.Items.INGOTS_MANASTEEL)
				.method_10439("WS ")
				.method_10439("S S")
				.method_10439("MSR")
				.method_10429("has_item", method_10420(ModTags.Items.INGOTS_MANASTEEL))
				.method_10431(consumer);
		class_2447.method_10437(ModItems.lavaPendant)
				.method_10434('S', ModItems.manaString)
				.method_10433('D', ModTags.Items.INGOTS_MANASTEEL)
				.method_10433('F', ModTags.Items.RUNES_FIRE)
				.method_10433('M', ModTags.Items.RUNES_SUMMER)
				.method_10439("MS ")
				.method_10439("S S")
				.method_10439("DSF")
				.method_10429("has_item", method_10420(ModTags.Items.INGOTS_MANASTEEL))
				.method_10431(consumer);
		class_2447.method_10437(ModItems.magnetRing)
				.method_10434('L', ModItems.lensMagnet)
				.method_10433('M', ModTags.Items.INGOTS_MANASTEEL)
				.method_10439("LM ")
				.method_10439("M M")
				.method_10439(" M ")
				.method_10429("has_item", method_10420(ModTags.Items.INGOTS_MANASTEEL))
				.method_10431(consumer);
		class_2447.method_10437(ModItems.waterRing)
				.method_10434('P', class_1802.field_8323)
				.method_10434('C', class_1802.field_8429)
				.method_10434('H', class_1802.field_8207)
				.method_10433('W', ModTags.Items.RUNES_WATER)
				.method_10433('M', ModTags.Items.INGOTS_MANASTEEL)
				.method_10439("WMP")
				.method_10439("MHM")
				.method_10439("CM ")
				.method_10429("has_item", method_10426(class_1802.field_8207))
				.method_10431(consumer);
		class_2447.method_10437(ModItems.miningRing)
				.method_10434('P', class_1802.field_8335)
				.method_10433('E', ModTags.Items.RUNES_EARTH)
				.method_10433('M', ModTags.Items.INGOTS_MANASTEEL)
				.method_10439("EMP")
				.method_10439("M M")
				.method_10439(" M ")
				.method_10429("has_item", method_10420(ModTags.Items.INGOTS_MANASTEEL))
				.method_10431(consumer);
		class_2447.method_10437(ModItems.divaCharm)
				.method_10434('P', ModItems.tinyPlanet)
				.method_10434('G', class_1802.field_8695)
				.method_10433('H', ModTags.Items.RUNES_PRIDE)
				.method_10434('L', ModItems.lifeEssence)
				.method_10439("LGP")
				.method_10439(" HG")
				.method_10439(" GL")
				.method_10429("has_item", method_10426(ModItems.lifeEssence))
				.method_10431(consumer);
		class_2447.method_10437(ModItems.flightTiara)
				.method_10434('E', ModItems.enderAirBottle)
				.method_10434('F', class_1802.field_8153)
				.method_10433('I', ModTags.Items.INGOTS_ELEMENTIUM)
				.method_10434('L', ModItems.lifeEssence)
				.method_10439("LLL")
				.method_10439("ILI")
				.method_10439("FEF")
				.method_10429("has_item", method_10426(ModItems.lifeEssence))
				.method_10438(consumer, "botania:flighttiara_0");

		// Normal quartz and not Tags.Items.QUARTZ because the recipes conflict.
		class_1792[] items = { class_1802.field_8155, ModItems.darkQuartz, ModItems.manaQuartz, ModItems.blazeQuartz,
				ModItems.lavenderQuartz, ModItems.redQuartz, ModItems.elfQuartz, ModItems.sunnyQuartz };
		for (int i = 0; i < items.length; i++) {
			int tiaraType = i + 1;
			class_2450.method_10447(ModItems.flightTiara)
					.method_10454(ModItems.flightTiara)
					.method_10454(items[i])
					.method_10452("botania:flight_tiara_wings")
					.method_10442("has_item", method_10426(ModItems.flightTiara))
					.method_10450(WrapperResult.transformJson(consumer, json -> json.getAsJsonObject("result").addProperty("nbt", "{variant:" + tiaraType + "}")
					), "botania:flighttiara_" + tiaraType);
		}
		class_2447.method_10437(ModItems.pixieRing)
				.method_10434('D', ModItems.pixieDust)
				.method_10433('E', ModTags.Items.INGOTS_ELEMENTIUM)
				.method_10439("DE ")
				.method_10439("E E")
				.method_10439(" E ")
				.method_10429("has_item", method_10426(ModItems.pixieDust))
				.method_10431(consumer);
		class_2447.method_10437(ModItems.superTravelBelt)
				.method_10434('S', ModItems.travelBelt)
				.method_10433('E', ModTags.Items.INGOTS_ELEMENTIUM)
				.method_10434('L', ModItems.lifeEssence)
				.method_10439("E  ")
				.method_10439(" S ")
				.method_10439("L E")
				.method_10429("has_item", method_10426(ModItems.lifeEssence))
				.method_10431(consumer);
		class_2447.method_10437(ModItems.reachRing)
				.method_10433('R', ModTags.Items.RUNES_PRIDE)
				.method_10433('E', ModTags.Items.INGOTS_ELEMENTIUM)
				.method_10439("RE ")
				.method_10439("E E")
				.method_10439(" E ")
				.method_10429("has_item", method_10420(ModTags.Items.INGOTS_ELEMENTIUM))
				.method_10431(consumer);
		class_2447.method_10437(ModItems.itemFinder)
				.method_10434('E', class_1802.field_8687)
				.method_10434('I', class_1802.field_8620)
				.method_10434('Y', class_1802.field_8449)
				.method_10439(" I ")
				.method_10439("IYI")
				.method_10439("IEI")
				.method_10429("has_item", method_10426(class_1802.field_8449))
				.method_10431(consumer);
		class_2447.method_10437(ModItems.superLavaPendant)
				.method_10434('P', ModItems.lavaPendant)
				.method_10434('B', class_1802.field_8894)
				.method_10434('G', ModItems.lifeEssence)
				.method_10434('N', class_1802.field_8729)
				.method_10439("BBB")
				.method_10439("BPB")
				.method_10439("NGN")
				.method_10429("has_item", method_10426(ModItems.lifeEssence))
				.method_10431(consumer);
		class_2447.method_10437(ModItems.bloodPendant)
				.method_10434('P', class_1802.field_8434)
				.method_10433('D', ModTags.Items.GEMS_MANA_DIAMOND)
				.method_10434('G', class_1802.field_8070)
				.method_10439(" P ")
				.method_10439("PGP")
				.method_10439("DP ")
				.method_10429("has_item", method_10426(class_1802.field_8070))
				.method_10431(consumer);
		class_2447.method_10437(ModItems.holyCloak)
				.method_10434('S', ModItems.lifeEssence)
				.method_10434('W', class_1802.field_19044)
				.method_10434('G', class_1802.field_8601)
				.method_10439("WWW")
				.method_10439("GWG")
				.method_10439("GSG")
				.method_10429("has_item", method_10426(ModItems.lifeEssence))
				.method_10431(consumer);
		class_2447.method_10437(ModItems.unholyCloak)
				.method_10434('R', class_1802.field_8725)
				.method_10434('S', ModItems.lifeEssence)
				.method_10434('W', class_1802.field_19059)
				.method_10439("WWW")
				.method_10439("RWR")
				.method_10439("RSR")
				.method_10429("has_item", method_10426(ModItems.lifeEssence))
				.method_10431(consumer);
		class_2447.method_10437(ModItems.balanceCloak)
				.method_10434('R', class_1802.field_8687)
				.method_10434('S', ModItems.lifeEssence)
				.method_10434('W', class_1802.field_19052)
				.method_10439("WWW")
				.method_10439("RWR")
				.method_10439("RSR")
				.method_10429("has_item", method_10426(ModItems.lifeEssence))
				.method_10431(consumer);
		class_2447.method_10437(ModItems.monocle)
				.method_10434('G', ModBlocks.manaGlass)
				.method_10433('I', ModTags.Items.INGOTS_MANASTEEL)
				.method_10434('N', class_1802.field_8397)
				.method_10439("GN")
				.method_10439("IN")
				.method_10439(" N")
				.method_10429("has_item", method_10420(ModTags.Items.INGOTS_MANASTEEL))
				.method_10431(consumer);
		class_2447.method_10437(ModItems.swapRing)
				.method_10434('C', class_1802.field_19060)
				.method_10433('M', ModTags.Items.INGOTS_MANASTEEL)
				.method_10439("CM ")
				.method_10439("M M")
				.method_10439(" M ")
				.method_10429("has_item", method_10420(ModTags.Items.INGOTS_MANASTEEL))
				.method_10431(consumer);
		class_2450.method_10447(ModItems.magnetRingGreater)
				.method_10446(ModTags.Items.INGOTS_TERRASTEEL)
				.method_10454(ModItems.magnetRing)
				.method_10442("has_item", method_10426(ModItems.magnetRing))
				.method_10444(consumer);
		class_2447.method_10437(ModItems.speedUpBelt)
				.method_10434('P', ModItems.grassSeeds)
				.method_10434('B', ModItems.travelBelt)
				.method_10434('S', class_1802.field_8479)
				.method_10434('M', class_1802.field_8895)
				.method_10439(" M ")
				.method_10439("PBP")
				.method_10439(" S ")
				.method_10429("has_item", method_10426(class_1802.field_8895))
				.method_10429("has_alt_item", method_10426(ModItems.travelBelt))
				.method_10431(consumer);
		class_2447.method_10437(ModItems.dodgeRing)
				.method_10433('R', ModTags.Items.RUNES_AIR)
				.method_10434('E', class_1802.field_8687)
				.method_10433('M', ModTags.Items.INGOTS_MANASTEEL)
				.method_10439("EM ")
				.method_10439("M M")
				.method_10439(" MR")
				.method_10429("has_item", method_10420(ModTags.Items.INGOTS_MANASTEEL))
				.method_10431(consumer);
		class_2447.method_10437(ModItems.invisibilityCloak)
				.method_10434('P', ModItems.manaPearl)
				.method_10434('C', class_1802.field_8434)
				.method_10434('W', class_1802.field_19044)
				.method_10434('G', ModBlocks.manaGlass)
				.method_10439("CWC")
				.method_10439("GWG")
				.method_10439("GPG")
				.method_10429("has_item", method_10426(ModItems.manaPearl))
				.method_10431(consumer);
		class_2447.method_10437(ModItems.cloudPendant)
				.method_10434('S', ModItems.manaString)
				.method_10433('D', ModTags.Items.INGOTS_MANASTEEL)
				.method_10433('F', ModTags.Items.RUNES_AIR)
				.method_10433('M', ModTags.Items.RUNES_AUTUMN)
				.method_10439("MS ")
				.method_10439("S S")
				.method_10439("DSF")
				.method_10429("has_item", method_10426(ModItems.manaString))
				.method_10431(consumer);
		class_2447.method_10437(ModItems.superCloudPendant)
				.method_10434('P', ModItems.cloudPendant)
				.method_10434('B', class_1802.field_8070)
				.method_10433('E', ModTags.Items.INGOTS_ELEMENTIUM)
				.method_10434('G', ModItems.lifeEssence)
				.method_10434('N', class_1802.field_19044)
				.method_10439("BEB")
				.method_10439("BPB")
				.method_10439("NGN")
				.method_10429("has_item", method_10426(ModItems.cloudPendant))
				.method_10429("has_alt_item", method_10426(ModItems.lifeEssence))
				.method_10431(consumer);
		class_2447.method_10437(ModItems.thirdEye)
				.method_10434('Q', class_1802.field_20402)
				.method_10434('R', class_1802.field_8071)
				.method_10433('S', ModTags.Items.RUNES_EARTH)
				.method_10433('D', ModTags.Items.GEMS_MANA_DIAMOND)
				.method_10434('E', class_1802.field_8449)
				.method_10439("RSR")
				.method_10439("QEQ")
				.method_10439("RDR")
				.method_10429("has_item", method_10420(ModTags.Items.GEMS_MANA_DIAMOND))
				.method_10431(consumer);
		class_2447.method_10437(ModItems.goddessCharm)
				.method_10433('P', ModTags.Items.PETALS_PINK)
				.method_10433('A', ModTags.Items.RUNES_WATER)
				.method_10433('S', ModTags.Items.RUNES_SPRING)
				.method_10433('D', ModTags.Items.GEMS_MANA_DIAMOND)
				.method_10439(" P ")
				.method_10439(" P ")
				.method_10439("ADS")
				.method_10429("has_item", method_10420(ModTags.Items.GEMS_MANA_DIAMOND))
				.method_10431(consumer);

	}

	private void registerCorporeaAndRedString(Consumer<class_2444> consumer) {
		class_2450.method_10447(ModItems.redString)
				.method_10454(class_1802.field_8276)
				.method_10454(class_1802.field_8793)
				.method_10454(ModItems.pixieDust)
				.method_10454(ModItems.enderAirBottle)
				.method_10452("botania:red_string")
				.method_10442("has_item", method_10426(ModItems.enderAirBottle))
				.method_10444(consumer);
		class_2450.method_10447(ModItems.redString)
				.method_10454(class_1802.field_8276)
				.method_10454(class_1802.field_8793)
				.method_10454(ModItems.pixieDust)
				.method_10454(ModItems.enderAirBottle)
				.method_10454(class_1802.field_17518)
				.method_10452("botania:red_string")
				.method_10442("has_item", method_10426(ModItems.enderAirBottle))
				.method_10450(consumer, "botania:red_string_alt");
		registerRedStringBlock(consumer, ModBlocks.redStringContainer, class_1856.method_8091(class_1802.field_8106), method_10426(class_1802.field_8106));
		registerRedStringBlock(consumer, ModBlocks.redStringDispenser, class_1856.method_8091(class_1802.field_8357), method_10426(class_1802.field_8357));
		registerRedStringBlock(consumer, ModBlocks.redStringFertilizer, class_1856.method_8091(ModItems.fertilizer), method_10426(ModItems.fertilizer));
		registerRedStringBlock(consumer, ModBlocks.redStringComparator, class_1856.method_8091(class_1802.field_8857), method_10426(class_1802.field_8857));
		registerRedStringBlock(consumer, ModBlocks.redStringRelay, class_1856.method_8091(ModBlocks.manaSpreader), method_10426(ModBlocks.manaSpreader));
		registerRedStringBlock(consumer, ModBlocks.redStringInterceptor, class_1856.method_8091(class_1802.field_8781), method_10426(class_1802.field_8781));
		class_2450.method_10447(ModItems.corporeaSpark)
				.method_10454(ModItems.spark)
				.method_10454(ModItems.pixieDust)
				.method_10454(ModItems.enderAirBottle)
				.method_10442("has_item", method_10426(ModItems.enderAirBottle))
				.method_10442("has_alt_item", method_10426(ModItems.pixieDust))
				.method_10444(consumer);
		class_2450.method_10447(ModItems.corporeaSparkMaster)
				.method_10454(ModItems.corporeaSpark)
				.method_10446(ModTags.Items.GEMS_DRAGONSTONE)
				.method_10442("has_item", method_10426(ModItems.corporeaSpark))
				.method_10444(consumer);
		class_2447.method_10437(ModBlocks.corporeaIndex)
				.method_10434('A', ModItems.enderAirBottle)
				.method_10434('S', ModItems.corporeaSpark)
				.method_10433('D', ModTags.Items.GEMS_DRAGONSTONE)
				.method_10434('O', class_1802.field_8281)
				.method_10439("AOA")
				.method_10439("OSO")
				.method_10439("DOD")
				.method_10429("has_item", method_10426(ModItems.corporeaSpark))
				.method_10431(consumer);
		class_2450.method_10447(ModBlocks.corporeaFunnel)
				.method_10454(class_1802.field_8878)
				.method_10454(ModItems.corporeaSpark)
				.method_10442("has_item", method_10426(ModItems.corporeaSpark))
				.method_10444(consumer);
		class_2450.method_10447(ModBlocks.corporeaInterceptor)
				.method_10454(class_1802.field_8793)
				.method_10454(ModItems.corporeaSpark)
				.method_10442("has_item", method_10426(ModItems.corporeaSpark))
				.method_10444(consumer);
		class_2447.method_10437(ModBlocks.corporeaCrystalCube)
				.method_10434('C', ModItems.corporeaSpark)
				.method_10434('G', ModBlocks.elfGlass)
				.method_10434('W', ModBlocks.dreamwood)
				.method_10439("C")
				.method_10439("G")
				.method_10439("W")
				.method_10429("has_item", method_10426(ModItems.corporeaSpark))
				.method_10431(consumer);
		class_2450.method_10447(ModBlocks.corporeaRetainer)
				.method_10454(class_1802.field_8106)
				.method_10454(ModItems.corporeaSpark)
				.method_10442("has_item", method_10426(ModItems.corporeaSpark))
				.method_10444(consumer);
		class_2450.method_10448(ModBlocks.corporeaBlock, 8)
				.method_10454(ModBlocks.livingrockBrick)
				.method_10454(ModItems.corporeaSpark)
				.method_10442("has_item", method_10426(ModItems.corporeaSpark))
				.method_10444(consumer);
		slabShape(ModBlocks.corporeaSlab, ModBlocks.corporeaBlock).method_10431(consumer);
		stairs(ModBlocks.corporeaStairs, ModBlocks.corporeaBlock).method_10431(consumer);
		class_2447.method_10436(ModBlocks.corporeaBrick, 4)
				.method_10434('R', ModBlocks.corporeaBlock)
				.method_10439("RR")
				.method_10439("RR")
				.method_10429("has_item", method_10426(ModBlocks.corporeaBlock))
				.method_10431(consumer);
		slabShape(ModBlocks.corporeaBrickSlab, ModBlocks.corporeaBrick).method_10431(consumer);
		stairs(ModBlocks.corporeaBrickStairs, ModBlocks.corporeaBrick).method_10431(consumer);
		wallShape(ModBlocks.corporeaBrickWall, ModBlocks.corporeaBrick, 6).method_10431(consumer);
	}

	private void registerLenses(Consumer<class_2444> consumer) {
		class_2447.method_10437(ModItems.lensNormal)
				.method_10433('S', ModTags.Items.INGOTS_MANASTEEL)
				.method_10428('G', class_1856.method_8091(class_1802.field_8280, class_1802.field_8141))
				.method_10439(" S ")
				.method_10439("SGS")
				.method_10439(" S ")
				.method_10429("has_item", method_10420(ModTags.Items.INGOTS_MANASTEEL))
				.method_10431(consumer);
		class_2450.method_10447(ModItems.lensSpeed)
				.method_10454(ModItems.lensNormal)
				.method_10446(ModTags.Items.RUNES_AIR)
				.method_10442("has_item", method_10426(ModItems.lensNormal))
				.method_10444(consumer);
		class_2450.method_10447(ModItems.lensPower)
				.method_10454(ModItems.lensNormal)
				.method_10446(ModTags.Items.RUNES_FIRE)
				.method_10442("has_item", method_10426(ModItems.lensNormal))
				.method_10444(consumer);
		class_2450.method_10447(ModItems.lensTime)
				.method_10454(ModItems.lensNormal)
				.method_10446(ModTags.Items.RUNES_EARTH)
				.method_10442("has_item", method_10426(ModItems.lensNormal))
				.method_10444(consumer);
		class_2450.method_10447(ModItems.lensEfficiency)
				.method_10454(ModItems.lensNormal)
				.method_10446(ModTags.Items.RUNES_WATER)
				.method_10442("has_item", method_10426(ModItems.lensNormal))
				.method_10444(consumer);
		class_2450.method_10447(ModItems.lensBounce)
				.method_10454(ModItems.lensNormal)
				.method_10446(ModTags.Items.RUNES_SUMMER)
				.method_10442("has_item", method_10426(ModItems.lensNormal))
				.method_10444(consumer);
		class_2450.method_10447(ModItems.lensGravity)
				.method_10454(ModItems.lensNormal)
				.method_10446(ModTags.Items.RUNES_WINTER)
				.method_10442("has_item", method_10426(ModItems.lensNormal))
				.method_10444(consumer);
		class_2447.method_10437(ModItems.lensMine)
				.method_10434('P', class_1802.field_8249)
				.method_10434('A', class_1802.field_8759)
				.method_10434('R', class_1802.field_8725)
				.method_10434('L', ModItems.lensNormal)
				.method_10439(" P ")
				.method_10439("ALA")
				.method_10439(" R ")
				.method_10429("has_item", method_10426(ModItems.lensNormal))
				.method_10431(consumer);
		class_2450.method_10447(ModItems.lensDamage)
				.method_10454(ModItems.lensNormal)
				.method_10446(ModTags.Items.RUNES_WRATH)
				.method_10442("has_item", method_10426(ModItems.lensNormal))
				.method_10444(consumer);
		class_2450.method_10447(ModItems.lensPhantom)
				.method_10454(ModItems.lensNormal)
				.method_10454(ModBlocks.abstrusePlatform)
				.method_10442("has_item", method_10426(ModItems.lensNormal))
				.method_10444(consumer);
		class_2450.method_10447(ModItems.lensMagnet)
				.method_10454(ModItems.lensNormal)
				.method_10454(class_1802.field_8620)
				.method_10454(class_1802.field_8695)
				.method_10442("has_item", method_10426(ModItems.lensNormal))
				.method_10444(consumer);
		class_2450.method_10447(ModItems.lensExplosive)
				.method_10454(ModItems.lensNormal)
				.method_10446(ModTags.Items.RUNES_ENVY)
				.method_10442("has_item", method_10426(ModItems.lensNormal))
				.method_10444(consumer);
		class_2447.method_10437(ModItems.lensInfluence)
				.method_10434('P', class_1802.field_8434)
				.method_10433('R', ModTags.Items.RUNES_AIR)
				.method_10434('L', ModItems.lensNormal)
				.method_10439("PRP")
				.method_10439("PLP")
				.method_10439("PPP")
				.method_10429("has_item", method_10426(ModItems.lensNormal))
				.method_10431(consumer);
		class_2447.method_10437(ModItems.lensWeight)
				.method_10434('P', class_1802.field_8434)
				.method_10433('R', ModTags.Items.RUNES_WATER)
				.method_10434('L', ModItems.lensNormal)
				.method_10439("PPP")
				.method_10439("PLP")
				.method_10439("PRP")
				.method_10429("has_item", method_10426(ModItems.lensNormal))
				.method_10431(consumer);
		class_2447.method_10437(ModItems.lensPaint)
				.method_10433('E', ModTags.Items.INGOTS_ELEMENTIUM)
				.method_10433('W', class_3489.field_15544)
				.method_10434('L', ModItems.lensNormal)
				.method_10439(" E ")
				.method_10439("WLW")
				.method_10439(" E ")
				.method_10429("has_item", method_10426(ModItems.lensNormal))
				.method_10431(consumer);
		class_2450.method_10447(ModItems.lensFire)
				.method_10454(ModItems.lensNormal)
				.method_10454(class_1802.field_8814)
				.method_10442("has_item", method_10426(ModItems.lensNormal))
				.method_10444(consumer);
		class_2450.method_10447(ModItems.lensPiston)
				.method_10454(ModItems.lensNormal)
				.method_10454(ModBlocks.pistonRelay)
				.method_10442("has_item", method_10426(ModItems.lensNormal))
				.method_10444(consumer);
		class_2447.method_10437(ModItems.lensLight)
				.method_10434('F', class_1802.field_8814)
				.method_10434('G', class_1802.field_8801)
				.method_10434('L', ModItems.lensNormal)
				.method_10439("GFG")
				.method_10439("FLF")
				.method_10439("GFG")
				.method_10429("has_item", method_10426(ModItems.lensNormal))
				.method_10431(consumer);
		class_2447.method_10437(ModItems.lensLight)
				.method_10434('F', class_1802.field_8814)
				.method_10434('G', class_1802.field_8801)
				.method_10434('L', ModItems.lensNormal)
				.method_10439("FGF")
				.method_10439("GLG")
				.method_10439("FGF")
				.method_10429("has_item", method_10426(ModItems.lensNormal))
				.method_10438(consumer, "botania:lens_light_alt");
		class_2447.method_10437(ModItems.lensMessenger)
				.method_10434('P', class_1802.field_8407)
				.method_10434('L', ModItems.lensNormal)
				.method_10439(" P ")
				.method_10439("PLP")
				.method_10439(" P ")
				.method_10429("has_item", method_10426(ModItems.lensNormal))
				.method_10431(consumer);

		class_2450.method_10447(ModItems.lensWarp)
				.method_10454(ModItems.lensNormal)
				.method_10454(ModItems.pixieDust)
				.method_10442("has_item", method_10426(ModItems.pixieDust))
				.method_10444(consumer);
		class_2450.method_10447(ModItems.lensRedirect)
				.method_10454(ModItems.lensNormal)
				.method_10446(ModTags.Items.LIVINGWOOD)
				.method_10446(ModTags.Items.INGOTS_ELEMENTIUM)
				.method_10442("has_item", method_10420(ModTags.Items.INGOTS_ELEMENTIUM))
				.method_10444(consumer);
		class_2450.method_10447(ModItems.lensFirework)
				.method_10454(ModItems.lensNormal)
				.method_10454(class_1802.field_8639)
				.method_10446(ModTags.Items.INGOTS_ELEMENTIUM)
				.method_10442("has_item", method_10420(ModTags.Items.INGOTS_ELEMENTIUM))
				.method_10444(consumer);
		class_2450.method_10447(ModItems.lensFlare)
				.method_10454(ModItems.lensNormal)
				.method_10454(ModBlocks.elfGlass)
				.method_10446(ModTags.Items.INGOTS_ELEMENTIUM)
				.method_10442("has_item", method_10420(ModTags.Items.INGOTS_ELEMENTIUM))
				.method_10444(consumer);
		class_2450.method_10447(ModItems.lensTripwire)
				.method_10454(ModItems.lensNormal)
				.method_10454(class_1802.field_8366)
				.method_10446(ModTags.Items.INGOTS_ELEMENTIUM)
				.method_10442("has_item", method_10420(ModTags.Items.INGOTS_ELEMENTIUM))
				.method_10444(consumer);
	}

	private void registerFloatingFlowers(Consumer<class_2444> consumer) {
		for (class_2248 block : new class_2248[] {
				ModSubtiles.pureDaisy, ModSubtiles.manastar, ModSubtiles.hydroangeas, ModSubtiles.endoflame,
				ModSubtiles.thermalily, ModSubtiles.rosaArcana, ModSubtiles.munchdew, ModSubtiles.entropinnyum,
				ModSubtiles.kekimurus, ModSubtiles.gourmaryllis, ModSubtiles.narslimmus, ModSubtiles.spectrolus,
				ModSubtiles.dandelifeon, ModSubtiles.rafflowsia, ModSubtiles.shulkMeNot, ModSubtiles.bellethorn,
				ModSubtiles.bellethornChibi, ModSubtiles.bergamute, ModSubtiles.dreadthorn, ModSubtiles.heiseiDream,
				ModSubtiles.tigerseye, ModSubtiles.jadedAmaranthus, ModSubtiles.orechid, ModSubtiles.fallenKanade,
				ModSubtiles.exoflame, ModSubtiles.agricarnation, ModSubtiles.agricarnationChibi, ModSubtiles.hopperhock,
				ModSubtiles.hopperhockChibi, ModSubtiles.tangleberrie, ModSubtiles.jiyuulia, ModSubtiles.rannuncarpus,
				ModSubtiles.rannuncarpusChibi, ModSubtiles.hyacidus, ModSubtiles.pollidisiac, ModSubtiles.clayconia,
				ModSubtiles.clayconiaChibi, ModSubtiles.loonium, ModSubtiles.daffomill, ModSubtiles.vinculotus,
				ModSubtiles.spectranthemum, ModSubtiles.medumone, ModSubtiles.marimorphosis, ModSubtiles.marimorphosisChibi,
				ModSubtiles.bubbell, ModSubtiles.bubbellChibi, ModSubtiles.solegnolia, ModSubtiles.solegnoliaChibi,
				ModSubtiles.orechidIgnem }) {
			createFloatingFlowerRecipe(consumer, block);
		}
	}

	private void registerConversions(Consumer<class_2444> consumer) {
		compression(ModItems.manaSteel, ModTags.Items.NUGGETS_MANASTEEL)
				.method_10430(consumer, prefix("conversions/manasteel_from_nuggets"));
		compression(ModItems.elementium, ModTags.Items.NUGGETS_ELEMENTIUM)
				.method_10430(consumer, prefix("conversions/elementium_from_nuggets"));
		compression(ModItems.terrasteel, ModTags.Items.NUGGETS_TERRASTEEL)
				.method_10430(consumer, prefix("conversions/terrasteel_from_nugget"));
		compression(ModBlocks.manasteelBlock, ModTags.Items.INGOTS_MANASTEEL).method_10431(consumer);
		compression(ModBlocks.terrasteelBlock, ModTags.Items.INGOTS_TERRASTEEL).method_10431(consumer);
		compression(ModBlocks.elementiumBlock, ModTags.Items.INGOTS_ELEMENTIUM).method_10431(consumer);
		compression(ModBlocks.manaDiamondBlock, ModTags.Items.GEMS_MANA_DIAMOND).method_10431(consumer);
		compression(ModBlocks.dragonstoneBlock, ModTags.Items.GEMS_DRAGONSTONE).method_10431(consumer);
		compression(ModBlocks.blazeBlock, class_1802.field_8894).method_10431(consumer);

		deconstructPetalBlock(consumer, ModItems.whitePetal, ModBlocks.petalBlockWhite);
		deconstructPetalBlock(consumer, ModItems.orangePetal, ModBlocks.petalBlockOrange);
		deconstructPetalBlock(consumer, ModItems.magentaPetal, ModBlocks.petalBlockMagenta);
		deconstructPetalBlock(consumer, ModItems.lightBluePetal, ModBlocks.petalBlockLightBlue);
		deconstructPetalBlock(consumer, ModItems.yellowPetal, ModBlocks.petalBlockYellow);
		deconstructPetalBlock(consumer, ModItems.limePetal, ModBlocks.petalBlockLime);
		deconstructPetalBlock(consumer, ModItems.pinkPetal, ModBlocks.petalBlockPink);
		deconstructPetalBlock(consumer, ModItems.grayPetal, ModBlocks.petalBlockGray);
		deconstructPetalBlock(consumer, ModItems.lightGrayPetal, ModBlocks.petalBlockSilver);
		deconstructPetalBlock(consumer, ModItems.cyanPetal, ModBlocks.petalBlockCyan);
		deconstructPetalBlock(consumer, ModItems.purplePetal, ModBlocks.petalBlockPurple);
		deconstructPetalBlock(consumer, ModItems.bluePetal, ModBlocks.petalBlockBlue);
		deconstructPetalBlock(consumer, ModItems.brownPetal, ModBlocks.petalBlockBrown);
		deconstructPetalBlock(consumer, ModItems.greenPetal, ModBlocks.petalBlockGreen);
		deconstructPetalBlock(consumer, ModItems.redPetal, ModBlocks.petalBlockRed);
		deconstructPetalBlock(consumer, ModItems.blackPetal, ModBlocks.petalBlockBlack);

		deconstruct(consumer, class_1802.field_8894, ModBlocks.blazeBlock, "blazeblock_deconstruct");
		deconstruct(consumer, ModItems.manaSteel, ModTags.Items.BLOCKS_MANASTEEL, "manasteel_block_deconstruct");
		deconstruct(consumer, ModItems.manaDiamond, ModBlocks.manaDiamondBlock, "manadiamond_block_deconstruct");
		deconstruct(consumer, ModItems.terrasteel, ModTags.Items.BLOCKS_TERRASTEEL, "terrasteel_block_deconstruct");
		deconstruct(consumer, ModItems.elementium, ModTags.Items.BLOCKS_ELEMENTIUM, "elementium_block_deconstruct");
		deconstruct(consumer, ModItems.dragonstone, ModBlocks.dragonstoneBlock, "dragonstone_block_deconstruct");
		deconstruct(consumer, ModItems.manasteelNugget, ModTags.Items.INGOTS_MANASTEEL, "manasteel_to_nuggets");
		deconstruct(consumer, ModItems.terrasteelNugget, ModTags.Items.INGOTS_TERRASTEEL, "terrasteel_to_nugget");
		deconstruct(consumer, ModItems.elementiumNugget, ModTags.Items.INGOTS_ELEMENTIUM, "elementium_to_nuggets");

		recombineSlab(consumer, ModBlocks.livingrock, ModFluffBlocks.livingrockSlab);
		recombineSlab(consumer, ModBlocks.livingrockBrick, ModFluffBlocks.livingrockBrickSlab);
		recombineSlab(consumer, ModBlocks.livingwood, ModFluffBlocks.livingwoodSlab);
		recombineSlab(consumer, ModBlocks.livingwoodPlanks, ModFluffBlocks.livingwoodPlankSlab);
		recombineSlab(consumer, ModBlocks.dreamwood, ModFluffBlocks.dreamwoodSlab);
		recombineSlab(consumer, ModBlocks.dreamwoodPlanks, ModFluffBlocks.dreamwoodPlankSlab);
		recombineSlab(consumer, ModBlocks.shimmerrock, ModFluffBlocks.shimmerrockSlab);
		recombineSlab(consumer, ModBlocks.shimmerwoodPlanks, ModFluffBlocks.shimmerwoodPlankSlab);
		recombineSlab(consumer, ModFluffBlocks.biomeStoneForest, ModFluffBlocks.biomeStoneForestSlab);
		recombineSlab(consumer, ModFluffBlocks.biomeBrickForest, ModFluffBlocks.biomeBrickForestSlab);
		recombineSlab(consumer, ModFluffBlocks.biomeCobblestoneForest, ModFluffBlocks.biomeCobblestoneForestSlab);
		recombineSlab(consumer, ModFluffBlocks.biomeStonePlains, ModFluffBlocks.biomeStonePlainsSlab);
		recombineSlab(consumer, ModFluffBlocks.biomeBrickPlains, ModFluffBlocks.biomeBrickPlainsSlab);
		recombineSlab(consumer, ModFluffBlocks.biomeCobblestonePlains, ModFluffBlocks.biomeCobblestonePlainsSlab);
		recombineSlab(consumer, ModFluffBlocks.biomeStoneMountain, ModFluffBlocks.biomeStoneMountainSlab);
		recombineSlab(consumer, ModFluffBlocks.biomeBrickMountain, ModFluffBlocks.biomeBrickMountainSlab);
		recombineSlab(consumer, ModFluffBlocks.biomeCobblestoneMountain, ModFluffBlocks.biomeCobblestoneMountainSlab);
		recombineSlab(consumer, ModFluffBlocks.biomeStoneFungal, ModFluffBlocks.biomeStoneFungalSlab);
		recombineSlab(consumer, ModFluffBlocks.biomeBrickFungal, ModFluffBlocks.biomeBrickFungalSlab);
		recombineSlab(consumer, ModFluffBlocks.biomeCobblestoneFungal, ModFluffBlocks.biomeCobblestoneFungalSlab);
		recombineSlab(consumer, ModFluffBlocks.biomeStoneSwamp, ModFluffBlocks.biomeStoneSwampSlab);
		recombineSlab(consumer, ModFluffBlocks.biomeBrickSwamp, ModFluffBlocks.biomeBrickSwampSlab);
		recombineSlab(consumer, ModFluffBlocks.biomeCobblestoneSwamp, ModFluffBlocks.biomeCobblestoneSwampSlab);
		recombineSlab(consumer, ModFluffBlocks.biomeStoneDesert, ModFluffBlocks.biomeStoneDesertSlab);
		recombineSlab(consumer, ModFluffBlocks.biomeBrickDesert, ModFluffBlocks.biomeBrickDesertSlab);
		recombineSlab(consumer, ModFluffBlocks.biomeCobblestoneDesert, ModFluffBlocks.biomeCobblestoneDesertSlab);
		recombineSlab(consumer, ModFluffBlocks.biomeStoneTaiga, ModFluffBlocks.biomeStoneTaigaSlab);
		recombineSlab(consumer, ModFluffBlocks.biomeBrickTaiga, ModFluffBlocks.biomeBrickTaigaSlab);
		recombineSlab(consumer, ModFluffBlocks.biomeCobblestoneTaiga, ModFluffBlocks.biomeCobblestoneTaigaSlab);
		recombineSlab(consumer, ModFluffBlocks.biomeStoneMesa, ModFluffBlocks.biomeStoneMesaSlab);
		recombineSlab(consumer, ModFluffBlocks.biomeBrickMesa, ModFluffBlocks.biomeBrickMesaSlab);
		recombineSlab(consumer, ModFluffBlocks.biomeCobblestoneMesa, ModFluffBlocks.biomeCobblestoneMesaSlab);
		recombineSlab(consumer, ModFluffBlocks.whitePavement, ModFluffBlocks.whitePavementSlab);
		recombineSlab(consumer, ModFluffBlocks.blackPavement, ModFluffBlocks.blackPavementSlab);
		recombineSlab(consumer, ModFluffBlocks.bluePavement, ModFluffBlocks.bluePavementSlab);
		recombineSlab(consumer, ModFluffBlocks.yellowPavement, ModFluffBlocks.yellowPavementSlab);
		recombineSlab(consumer, ModFluffBlocks.redPavement, ModFluffBlocks.redPavementSlab);
		recombineSlab(consumer, ModFluffBlocks.greenPavement, ModFluffBlocks.greenPavementSlab);
	}

	private void registerDecor(Consumer<class_2444> consumer) {
		class_2447.method_10436(ModBlocks.livingrockBrick, 4)
				.method_10433('R', ModTags.Items.LIVINGROCK)
				.method_10439("RR")
				.method_10439("RR")
				.method_10429("has_item", method_10420(ModTags.Items.LIVINGROCK))
				.method_10431(consumer);
		class_2447.method_10436(ModBlocks.livingrockBrickChiseled, 4)
				.method_10434('R', ModBlocks.livingrockBrick)
				.method_10439("RR")
				.method_10439("RR")
				.method_10429("has_item", method_10426(ModBlocks.livingrockBrick))
				.method_10431(consumer);
		class_2450.method_10448(ModBlocks.livingrockBrickCracked, 2)
				.method_10454(ModBlocks.livingrockBrick)
				.method_10454(class_1802.field_20412)
				.method_10442("has_item", method_10426(ModBlocks.livingrockBrick))
				.method_10444(consumer);
		class_2450.method_10447(ModBlocks.livingrockBrickMossy)
				.method_10454(ModBlocks.livingrockBrick)
				.method_10454(class_1802.field_8317)
				.method_10442("has_item", method_10426(ModBlocks.livingrockBrick))
				.method_10444(consumer);
		class_2450.method_10447(ModBlocks.livingwoodPlanksMossy)
				.method_10454(ModBlocks.livingwoodPlanks)
				.method_10454(class_1802.field_8317)
				.method_10442("has_item", method_10426(ModBlocks.livingwoodPlanks))
				.method_10444(consumer);
		class_2447.method_10436(ModBlocks.livingwoodFramed, 4)
				.method_10434('W', ModBlocks.livingwoodPlanks)
				.method_10439("WW")
				.method_10439("WW")
				.method_10429("has_item", method_10426(ModBlocks.livingwoodPlanks))
				.method_10431(consumer);
		class_2450.method_10447(ModBlocks.livingwoodGlimmering)
				.method_10446(ModTags.Items.LIVINGWOOD)
				.method_10454(class_1802.field_8601)
				.method_10442("has_item", method_10420(ModTags.Items.LIVINGWOOD))
				.method_10444(consumer);
		class_2450.method_10447(ModBlocks.dreamwoodPlanksMossy)
				.method_10454(ModBlocks.dreamwoodPlanks)
				.method_10454(class_1802.field_8317)
				.method_10442("has_item", method_10426(ModBlocks.dreamwoodPlanks))
				.method_10444(consumer);
		class_2447.method_10436(ModBlocks.dreamwoodFramed, 4)
				.method_10434('W', ModBlocks.dreamwoodPlanks)
				.method_10439("WW")
				.method_10439("WW")
				.method_10429("has_item", method_10426(ModBlocks.dreamwoodPlanks))
				.method_10431(consumer);
		class_2450.method_10447(ModBlocks.dreamwoodGlimmering)
				.method_10454(ModBlocks.dreamwood)
				.method_10454(class_1802.field_8601)
				.method_10442("has_item", method_10426(ModBlocks.dreamwood))
				.method_10444(consumer);
		class_2450.method_10447(ModBlocks.shimmerrock)
				.method_10446(ModTags.Items.LIVINGROCK)
				.method_10454(ModBlocks.bifrostPerm)
				.method_10442("has_item", method_10426(ModBlocks.bifrostPerm))
				.method_10442("has_alt_item", method_10426(ModItems.rainbowRod))
				.method_10444(consumer);
		class_2450.method_10447(ModBlocks.shimmerwoodPlanks)
				.method_10454(ModBlocks.dreamwoodPlanks)
				.method_10454(ModBlocks.bifrostPerm)
				.method_10442("has_item", method_10426(ModBlocks.bifrostPerm))
				.method_10442("has_alt_item", method_10426(ModItems.rainbowRod))
				.method_10444(consumer);

		registerForQuartz(consumer, LibBlockNames.QUARTZ_DARK, ModItems.darkQuartz);
		registerForQuartz(consumer, LibBlockNames.QUARTZ_MANA, ModItems.manaQuartz);
		registerForQuartz(consumer, LibBlockNames.QUARTZ_BLAZE, ModItems.blazeQuartz);
		registerForQuartz(consumer, LibBlockNames.QUARTZ_LAVENDER, ModItems.lavenderQuartz);
		registerForQuartz(consumer, LibBlockNames.QUARTZ_RED, ModItems.redQuartz);
		registerForQuartz(consumer, LibBlockNames.QUARTZ_ELF, ModItems.elfQuartz);
		registerForQuartz(consumer, LibBlockNames.QUARTZ_SUNNY, ModItems.sunnyQuartz);

		registerForWood(consumer, LibBlockNames.LIVING_WOOD);
		registerForWood(consumer, LibBlockNames.DREAM_WOOD);

		stairs(ModFluffBlocks.livingrockStairs, ModBlocks.livingrock).method_10431(consumer);
		slabShape(ModFluffBlocks.livingrockSlab, ModBlocks.livingrock).method_10431(consumer);
		wallShape(ModFluffBlocks.livingrockWall, ModBlocks.livingrock, 6).method_10431(consumer);

		stairs(ModFluffBlocks.livingrockBrickStairs, ModBlocks.livingrockBrick).method_10431(consumer);
		slabShape(ModFluffBlocks.livingrockBrickSlab, ModBlocks.livingrockBrick).method_10431(consumer);
		wallShape(ModFluffBlocks.livingrockBrickWall, ModBlocks.livingrockBrick, 6).method_10431(consumer);

		stairs(ModFluffBlocks.livingrockBrickMossyStairs, ModBlocks.livingrockBrickMossy).method_10431(consumer);
		slabShape(ModFluffBlocks.livingrockBrickMossySlab, ModBlocks.livingrockBrickMossy).method_10431(consumer);
		wallShape(ModFluffBlocks.livingrockBrickMossyWall, ModBlocks.livingrockBrickMossy, 6).method_10431(consumer);

		stairs(ModFluffBlocks.shimmerrockStairs, ModBlocks.shimmerrock).method_10431(consumer);
		slabShape(ModFluffBlocks.shimmerrockSlab, ModBlocks.shimmerrock).method_10431(consumer);
		stairs(ModFluffBlocks.livingwoodPlankStairs, ModBlocks.livingwoodPlanks).method_10431(consumer);
		slabShape(ModFluffBlocks.livingwoodPlankSlab, ModBlocks.livingwoodPlanks).method_10431(consumer);
		stairs(ModFluffBlocks.dreamwoodPlankStairs, ModBlocks.dreamwoodPlanks).method_10431(consumer);
		slabShape(ModFluffBlocks.dreamwoodPlankSlab, ModBlocks.dreamwoodPlanks).method_10431(consumer);
		stairs(ModFluffBlocks.shimmerwoodPlankStairs, ModBlocks.shimmerwoodPlanks).method_10431(consumer);
		slabShape(ModFluffBlocks.shimmerwoodPlankSlab, ModBlocks.shimmerwoodPlanks).method_10431(consumer);

		ringShape(ModBlocks.livingwoodPatternFramed, ModBlocks.livingwoodPlanks).method_10431(consumer);
		ringShape(ModBlocks.dreamwoodPatternFramed, ModBlocks.dreamwoodPlanks).method_10431(consumer);

		for (String variant : LibBlockNames.METAMORPHIC_VARIANTS) {
			registerForMetamorphic(consumer, variant);
		}

		class_1792[] pavementIngredients = { class_1802.field_8162, class_1802.field_8713, class_1802.field_8759, class_1802.field_8725, class_1802.field_8861, class_1802.field_8777 };
		for (int i = 0; i < pavementIngredients.length; i++) {
			registerForPavement(consumer, LibBlockNames.PAVEMENT_VARIANTS[i], pavementIngredients[i]);
		}

		wallShape(ModFluffBlocks.managlassPane, ModBlocks.manaGlass, 16).method_10431(consumer);
		wallShape(ModFluffBlocks.alfglassPane, ModBlocks.elfGlass, 16).method_10431(consumer);
		wallShape(ModFluffBlocks.bifrostPane, ModBlocks.bifrostPerm, 16).method_10431(consumer);

		class_2450.method_10447(ModBlocks.azulejo0)
				.method_10454(class_1802.field_8345)
				.method_10446(ModTags.Items.BLOCKS_QUARTZ)
				.method_10442("has_item", method_10426(class_1802.field_8345))
				.method_10444(consumer);

		List<class_1792> allAzulejos = IntStream.range(0, 16).mapToObj(i -> "azulejo_" + i)
				.map(ResourceLocationHelper::prefix)
				.map(class_2378.field_11142::method_17966)
				.map(Optional::get)
				.collect(Collectors.toList());
		for (int i = 0; i < allAzulejos.size(); i++) {
			int resultIndex = i + 1 == allAzulejos.size() ? 0 : i + 1;
			String recipeName = "azulejo_" + resultIndex;
			if (resultIndex == 0) {
				recipeName += "_alt";
			}
			class_2450.method_10447(allAzulejos.get(resultIndex))
					.method_10454(allAzulejos.get(i))
					.method_10442("has_azulejo", method_10426(ModBlocks.azulejo0))
					.method_10452("botania:azulejo_cycling")
					.method_10443(consumer, prefix(recipeName));
		}

		cosmeticBauble(consumer, ModItems.blackBowtie, ModItems.whitePetal);
		cosmeticBauble(consumer, ModItems.blackTie, ModItems.orangePetal);
		cosmeticBauble(consumer, ModItems.redGlasses, ModItems.magentaPetal);
		cosmeticBauble(consumer, ModItems.puffyScarf, ModItems.lightBluePetal);
		cosmeticBauble(consumer, ModItems.engineerGoggles, ModItems.yellowPetal);
		cosmeticBauble(consumer, ModItems.eyepatch, ModItems.limePetal);
		cosmeticBauble(consumer, ModItems.wickedEyepatch, ModItems.pinkPetal);
		cosmeticBauble(consumer, ModItems.redRibbons, ModItems.grayPetal);
		cosmeticBauble(consumer, ModItems.pinkFlowerBud, ModItems.lightGrayPetal);
		cosmeticBauble(consumer, ModItems.polkaDottedBows, ModItems.cyanPetal);
		cosmeticBauble(consumer, ModItems.blueButterfly, ModItems.purplePetal);
		cosmeticBauble(consumer, ModItems.catEars, ModItems.bluePetal);
		cosmeticBauble(consumer, ModItems.witchPin, ModItems.brownPetal);
		cosmeticBauble(consumer, ModItems.devilTail, ModItems.greenPetal);
		cosmeticBauble(consumer, ModItems.kamuiEye, ModItems.redPetal);
		cosmeticBauble(consumer, ModItems.googlyEyes, ModItems.blackPetal);
		cosmeticBauble(consumer, ModItems.fourLeafClover, class_1802.field_8446);
		cosmeticBauble(consumer, ModItems.clockEye, class_1802.field_8492);
		cosmeticBauble(consumer, ModItems.unicornHorn, class_1802.field_8669);
		cosmeticBauble(consumer, ModItems.devilHorns, class_1802.field_8273);
		cosmeticBauble(consumer, ModItems.hyperPlus, class_1802.field_8192);
		cosmeticBauble(consumer, ModItems.botanistEmblem, class_1802.field_8131);
		cosmeticBauble(consumer, ModItems.ancientMask, class_1802.field_8330);
		cosmeticBauble(consumer, ModItems.eerieMask, class_1802.field_8298);
		cosmeticBauble(consumer, ModItems.alienAntenna, class_1802.field_8851);
		cosmeticBauble(consumer, ModItems.anaglyphGlasses, class_1802.field_8632);
		cosmeticBauble(consumer, ModItems.orangeShades, class_1802.field_8296);
		cosmeticBauble(consumer, ModItems.grouchoGlasses, class_1802.field_8345);
		cosmeticBauble(consumer, ModItems.thickEyebrows, class_1802.field_8099);
		cosmeticBauble(consumer, ModItems.lusitanicShield, class_1802.field_8408);
		cosmeticBauble(consumer, ModItems.tinyPotatoMask, class_1802.field_8264);
		cosmeticBauble(consumer, ModItems.questgiverMark, class_1802.field_8226);
		cosmeticBauble(consumer, ModItems.thinkingHand, ModBlocks.tinyPotato);
	}

	private void registerSimpleArmorSet(Consumer<class_2444> consumer, class_1856 item, String variant,
			class_184 criterion) {
		class_1792 helmet = class_2378.field_11142.method_17966(prefix(variant + "_helmet")).get();
		class_1792 chestplate = class_2378.field_11142.method_17966(prefix(variant + "_chestplate")).get();
		class_1792 leggings = class_2378.field_11142.method_17966(prefix(variant + "_leggings")).get();
		class_1792 boots = class_2378.field_11142.method_17966(prefix(variant + "_boots")).get();
		class_2447.method_10437(helmet)
				.method_10428('S', item)
				.method_10439("SSS")
				.method_10439("S S")
				.method_10429("has_item", criterion)
				.method_10431(consumer);
		class_2447.method_10437(chestplate)
				.method_10428('S', item)
				.method_10439("S S")
				.method_10439("SSS")
				.method_10439("SSS")
				.method_10429("has_item", criterion)
				.method_10431(consumer);
		class_2447.method_10437(leggings)
				.method_10428('S', item)
				.method_10439("SSS")
				.method_10439("S S")
				.method_10439("S S")
				.method_10429("has_item", criterion)
				.method_10431(consumer);
		class_2447.method_10437(boots)
				.method_10428('S', item)
				.method_10439("S S")
				.method_10439("S S")
				.method_10429("has_item", criterion)
				.method_10431(consumer);
	}

	private void registerToolSetRecipes(Consumer<class_2444> consumer, class_1856 item, class_1856 stick,
			class_184 criterion, class_1935 sword, class_1935 pickaxe,
			class_1935 axe, class_1935 shovel, class_1935 shears) {
		class_2447.method_10437(pickaxe)
				.method_10428('S', item)
				.method_10428('T', stick)
				.method_10439("SSS")
				.method_10439(" T ")
				.method_10439(" T ")
				.method_10429("has_item", criterion)
				.method_10431(consumer);
		class_2447.method_10437(shovel)
				.method_10428('S', item)
				.method_10428('T', stick)
				.method_10439("S")
				.method_10439("T")
				.method_10439("T")
				.method_10429("has_item", criterion)
				.method_10431(consumer);
		class_2447.method_10437(axe)
				.method_10428('S', item)
				.method_10428('T', stick)
				.method_10439("SS")
				.method_10439("TS")
				.method_10439("T ")
				.method_10429("has_item", criterion)
				.method_10431(consumer);
		class_2447.method_10437(sword)
				.method_10428('S', item)
				.method_10428('T', stick)
				.method_10439("S")
				.method_10439("S")
				.method_10439("T")
				.method_10429("has_item", criterion)
				.method_10431(consumer);
		class_2447.method_10437(shears)
				.method_10428('S', item)
				.method_10439("S ")
				.method_10439(" S")
				.method_10429("has_item", criterion)
				.method_10431(consumer);

	}

	private void registerTerrasteelUpgradeRecipe(Consumer<class_2444> consumer, class_1935 output,
			class_1935 upgradedInput, class_3494<class_1792> runeInput) {
		class_2447.method_10437(output)
				.method_10434('T', ModItems.livingwoodTwig)
				.method_10433('S', ModTags.Items.INGOTS_TERRASTEEL)
				.method_10433('R', runeInput)
				.method_10434('A', upgradedInput)
				.method_10439("TRT")
				.method_10439("SAS")
				.method_10439(" S ")
				.method_10429("has_item", method_10420(ModTags.Items.INGOTS_TERRASTEEL))
				.method_10429("has_prev_tier", method_10426(upgradedInput))
				.method_10431(WrapperResult.ofType(ArmorUpgradeRecipe.SERIALIZER, consumer));
	}

	private void registerRedStringBlock(Consumer<class_2444> consumer, class_1935 output, class_1856 input, class_184 criterion) {
		class_2447.method_10437(output)
				.method_10433('R', ModTags.Items.LIVINGROCK)
				.method_10434('S', ModItems.redString)
				.method_10428('M', input)
				.method_10439("RRR")
				.method_10439("RMS")
				.method_10439("RRR")
				.method_10429("has_item", method_10426(ModItems.redString))
				.method_10429("has_base_block", criterion)
				.method_10431(consumer);
	}

	private void createFloatingFlowerRecipe(Consumer<class_2444> consumer, class_1935 input) {
		class_2960 inputName = class_2378.field_11142.method_10221(input.method_8389());
		class_1792 output = class_2378.field_11142.method_17966(new class_2960(inputName.method_12836(), "floating_" + inputName.method_12832())).get();
		class_2450.method_10447(output)
				.method_10446(ModTags.Items.FLOATING_FLOWERS)
				.method_10454(input)
				.method_10442("has_item", method_10426(input))
				.method_10444(consumer);
	}

	private void deconstruct(Consumer<class_2444> consumer, class_1935 output, class_1935 input, String name) {
		class_2450.method_10448(output, 9)
				.method_10442("has_item", method_10426(output))
				.method_10454(input)
				.method_10443(consumer, prefix("conversions/" + name));
	}

	private void deconstruct(Consumer<class_2444> consumer, class_1935 output, class_3494<class_1792> input, String name) {
		class_2450.method_10448(output, 9)
				.method_10442("has_item", method_10426(output))
				.method_10446(input)
				.method_10443(consumer, prefix("conversions/" + name));
	}

	private void deconstructPetalBlock(Consumer<class_2444> consumer, class_1935 output, class_1935 input) {
		class_2450.method_10448(output, 9)
				.method_10442("has_item", method_10426(output))
				.method_10454(input).method_10452("botania:petal_block_deconstruct")
				.method_10443(consumer, prefix("conversions/" + class_2378.field_11142.method_10221(input.method_8389()).method_12832() + "_deconstruct"));
	}

	private void recombineSlab(Consumer<class_2444> consumer, class_1935 fullBlock, class_1935 slab) {
		class_2447.method_10437(fullBlock)
				.method_10434('Q', slab)
				.method_10439("Q")
				.method_10439("Q")
				.method_10429("has_item", method_10426(fullBlock))
				.method_10430(consumer, prefix("slab_recombine/" + class_2378.field_11142.method_10221(fullBlock.method_8389()).method_12832()));
	}

	private void registerForQuartz(Consumer<class_2444> consumer, String variant, class_1935 baseItem) {
		class_2248 base = class_2378.field_11146.method_17966(prefix(variant)).get();
		class_2248 slab = class_2378.field_11146.method_17966(prefix(variant + LibBlockNames.SLAB_SUFFIX)).get();
		class_2248 stairs = class_2378.field_11146.method_17966(prefix(variant + LibBlockNames.STAIR_SUFFIX)).get();
		class_2248 chiseled = class_2378.field_11146.method_17966(prefix("chiseled_" + variant)).get();
		class_2248 pillar = class_2378.field_11146.method_17966(prefix(variant + "_pillar")).get();

		class_2447.method_10437(base)
				.method_10434('Q', baseItem)
				.method_10439("QQ")
				.method_10439("QQ")
				.method_10429("has_item", method_10426(baseItem))
				.method_10431(consumer);
		stairs(stairs, base).method_10431(consumer);
		slabShape(slab, base).method_10431(consumer);
		pillar(pillar, base).method_10431(consumer);
		chiseled(chiseled, slab).method_10429("has_base_item", method_10426(base)).method_10431(consumer);
	}

	private void registerForWood(Consumer<class_2444> consumer, String variant) {
		class_2248 base = class_2378.field_11146.method_17966(prefix(variant)).get();
		class_2248 planks = class_2378.field_11146.method_17966(prefix(variant + "_planks")).get();
		class_2248 slab = class_2378.field_11146.method_17966(prefix(variant + LibBlockNames.SLAB_SUFFIX)).get();
		class_2248 stairs = class_2378.field_11146.method_17966(prefix(variant + LibBlockNames.STAIR_SUFFIX)).get();
		class_2248 wall = class_2378.field_11146.method_17966(prefix(variant + LibBlockNames.WALL_SUFFIX)).get();
		class_2248 fence = class_2378.field_11146.method_17966(prefix(variant + LibBlockNames.FENCE_SUFFIX)).get();
		class_2248 fenceGate = class_2378.field_11146.method_17966(prefix(variant + LibBlockNames.FENCE_GATE_SUFFIX)).get();

		class_2450.method_10448(planks, 4).method_10454(base)
				.method_10442("has_item", method_10426(base)).method_10444(consumer);
		stairs(stairs, base).method_10431(consumer);
		slabShape(slab, base).method_10431(consumer);
		wallShape(wall, base, 6).method_10431(consumer);
		fence(fence, planks).method_10431(consumer);
		fenceGate(fenceGate, planks).method_10431(consumer);
	}

	private void registerForPavement(Consumer<class_2444> consumer, String color, @Nullable class_1792 mainInput) {
		String baseName = color + LibBlockNames.PAVEMENT_SUFFIX;
		class_2248 base = class_2378.field_11146.method_17966(prefix(baseName)).get();
		class_2248 stair = class_2378.field_11146.method_17966(prefix(baseName + LibBlockNames.STAIR_SUFFIX)).get();
		class_2248 slab = class_2378.field_11146.method_17966(prefix(baseName + LibBlockNames.SLAB_SUFFIX)).get();

		class_2450 builder = class_2450.method_10448(base, 3)
				.method_10446(ModTags.Items.LIVINGROCK)
				.method_10454(class_1802.field_20412)
				.method_10454(class_1802.field_8110)
				.method_10452("botania:pavement")
				.method_10442("has_item", method_10420(ModTags.Items.LIVINGROCK));
		if (mainInput != class_1802.field_8162) {
			builder.method_10454(mainInput);
		}
		builder.method_10444(consumer);

		slabShape(slab, base).method_10435("botania:pavement_slab").method_10431(consumer);
		stairs(stair, base).method_10435("botania:pavement_stairs").method_10431(consumer);
	}

	private void registerForMetamorphic(Consumer<class_2444> consumer, String variant) {
		class_2248 base = class_2378.field_11146.method_17966(prefix(LibBlockNames.METAMORPHIC_PREFIX + variant + "_stone")).get();
		class_2248 slab = class_2378.field_11146.method_17966(prefix(LibBlockNames.METAMORPHIC_PREFIX + variant + "_stone" + LibBlockNames.SLAB_SUFFIX)).get();
		class_2248 stair = class_2378.field_11146.method_17966(prefix(LibBlockNames.METAMORPHIC_PREFIX + variant + "_stone" + LibBlockNames.STAIR_SUFFIX)).get();
		class_2248 brick = class_2378.field_11146.method_17966(prefix(LibBlockNames.METAMORPHIC_PREFIX + variant + "_bricks")).get();
		class_2248 brickSlab = class_2378.field_11146.method_17966(prefix(LibBlockNames.METAMORPHIC_PREFIX + variant + "_bricks" + LibBlockNames.SLAB_SUFFIX)).get();
		class_2248 brickStair = class_2378.field_11146.method_17966(prefix(LibBlockNames.METAMORPHIC_PREFIX + variant + "_bricks" + LibBlockNames.STAIR_SUFFIX)).get();
		class_2248 brickWall = class_2378.field_11146.method_17966(prefix(LibBlockNames.METAMORPHIC_PREFIX + variant + "_bricks" + LibBlockNames.WALL_SUFFIX)).get();
		class_2248 chiseledBrick = class_2378.field_11146.method_17966(prefix("chiseled_" + LibBlockNames.METAMORPHIC_PREFIX + variant + "_bricks")).get();
		class_2248 cobble = class_2378.field_11146.method_17966(prefix(LibBlockNames.METAMORPHIC_PREFIX + variant + "_cobblestone")).get();
		class_2248 cobbleSlab = class_2378.field_11146.method_17966(prefix(LibBlockNames.METAMORPHIC_PREFIX + variant + "_cobblestone" + LibBlockNames.SLAB_SUFFIX)).get();
		class_2248 cobbleStair = class_2378.field_11146.method_17966(prefix(LibBlockNames.METAMORPHIC_PREFIX + variant + "_cobblestone" + LibBlockNames.STAIR_SUFFIX)).get();
		class_2248 cobbleWall = class_2378.field_11146.method_17966(prefix(LibBlockNames.METAMORPHIC_PREFIX + variant + "_cobblestone" + LibBlockNames.WALL_SUFFIX)).get();

		class_2066.class_2068 marimorphosis = method_10426(ModSubtiles.marimorphosis);
		slabShape(slab, base).method_10435("botania:metamorphic_stone_slab")
				.method_10429("has_flower_item", marimorphosis).method_10431(consumer);
		stairs(stair, base).method_10435("botania:metamorphic_stone_stairs")
				.method_10429("has_flower_item", marimorphosis).method_10431(consumer);

		brick(brick, base).method_10435("botania:metamorphic_brick")
				.method_10429("has_flower_item", marimorphosis).method_10431(consumer);
		slabShape(brickSlab, brick).method_10435("botania:metamorphic_brick_slab")
				.method_10429("has_flower_item", marimorphosis).method_10431(consumer);
		stairs(brickStair, brick).method_10435("botania:metamorphic_brick_stairs")
				.method_10429("has_flower_item", marimorphosis).method_10431(consumer);
		wallShape(brickWall, brick, 6).method_10435("botania:metamorphic_brick_wall")
				.method_10429("has_flower_item", marimorphosis).method_10431(consumer);
		brick(chiseledBrick, brickSlab).method_10429("has_base_item", method_10426(brick))
				.method_10429("has_flower_item", marimorphosis).method_10431(consumer);

		slabShape(cobbleSlab, cobble).method_10435("botania:metamorphic_cobble_slab")
				.method_10429("has_flower_item", marimorphosis).method_10431(consumer);
		stairs(cobbleStair, cobble).method_10435("botania:metamorphic_cobble_stairs")
				.method_10429("has_flower_item", marimorphosis).method_10431(consumer);
		wallShape(cobbleWall, cobble, 6).method_10435("botania:metamorphic_cobble_wall")
				.method_10429("has_flower_item", marimorphosis).method_10431(consumer);
	}

	private class_2447 compression(class_1935 output, class_3494<class_1792> input) {
		return class_2447.method_10437(output)
				.method_10433('I', input)
				.method_10439("III")
				.method_10439("III")
				.method_10439("III")
				.method_10429("has_item", method_10420(input));
	}

	private class_2447 compression(class_1935 output, class_1935 input) {
		return class_2447.method_10437(output)
				.method_10434('I', input)
				.method_10439("III")
				.method_10439("III")
				.method_10439("III")
				.method_10429("has_item", method_10426(input));
	}

	private class_2447 brick(class_1935 output, class_1935 input) {
		return class_2447.method_10436(output, 4)
				.method_10429("has_item", method_10426(input))
				.method_10434('Q', input)
				.method_10439("QQ")
				.method_10439("QQ");
	}

	private class_2447 stairs(class_1935 output, class_1935 input) {
		return class_2447.method_10436(output, 4)
				.method_10429("has_item", method_10426(input))
				.method_10434('Q', input)
				.method_10439("  Q")
				.method_10439(" QQ")
				.method_10439("QQQ");
	}

	private class_2447 slabShape(class_1935 output, class_1935 input) {
		return class_2447.method_10436(output, 6)
				.method_10429("has_item", method_10426(input))
				.method_10434('Q', input)
				.method_10439("QQQ");
	}

	private class_2447 pillar(class_1935 output, class_1935 input) {
		return class_2447.method_10436(output, 2)
				.method_10429("has_item", method_10426(input))
				.method_10434('Q', input)
				.method_10439("Q")
				.method_10439("Q");
	}

	private class_2447 chiseled(class_1935 output, class_1935 input) {
		return class_2447.method_10437(output)
				.method_10429("has_item", method_10426(input))
				.method_10434('Q', input)
				.method_10439("Q")
				.method_10439("Q");
	}

	private class_2447 wallShape(class_1935 output, class_1935 input, int amount) {
		return class_2447.method_10436(output, amount)
				.method_10429("has_item", method_10426(input))
				.method_10434('B', input)
				.method_10439("BBB")
				.method_10439("BBB");
	}

	private class_2447 fence(class_1935 output, class_1935 input) {
		return class_2447.method_10436(output, 3)
				.method_10429("has_item", method_10426(input))
				.method_10434('B', input)
				.method_10434('S', class_1802.field_8600)
				.method_10439("BSB")
				.method_10439("BSB");
	}

	private class_2447 fenceGate(class_1935 output, class_1935 input) {
		return class_2447.method_10436(output, 3)
				.method_10429("has_item", method_10426(input))
				.method_10434('B', input)
				.method_10434('S', class_1802.field_8600)
				.method_10439("SBS")
				.method_10439("SBS");
	}

	private class_2447 ringShape(class_1935 output, class_1935 input) {
		return class_2447.method_10436(output, 4)
				.method_10434('W', input)
				.method_10439(" W ")
				.method_10439("W W")
				.method_10439(" W ")
				.method_10429("has_item", method_10426(input));
	}

	private void cosmeticBauble(Consumer<class_2444> consumer, class_1935 output, class_1935 input) {
		class_2447.method_10437(output)
				.method_10434('P', input)
				.method_10434('S', ModItems.manaString)
				.method_10439("PPP")
				.method_10439("PSP")
				.method_10439("PPP")
				.method_10435("botania:cosmetic_bauble")
				.method_10429("has_item", method_10426(ModItems.manaString))
				.method_10431(consumer);
	}

	private void specialRecipe(Consumer<class_2444> consumer, class_1866<?> serializer) {
		class_2960 name = class_2378.field_17598.method_10221(serializer);
		class_2456.method_10476(serializer).method_10475(consumer, prefix("dynamic/" + name.method_12832()).toString());
	}

	@Override
	public String method_10321() {
		return "Botania crafting recipes";
	}
}
