/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.data.recipes;

import com.google.common.base.Preconditions;
import com.google.gson.JsonObject;
import vazkii.botania.api.recipe.StateIngredient;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.crafting.ModRecipeTypes;
import vazkii.botania.common.crafting.StateIngredientHelper;

import javax.annotation.Nullable;
import net.minecraft.class_1865;
import net.minecraft.class_2246;
import net.minecraft.class_2403;
import net.minecraft.class_2444;
import net.minecraft.class_2446;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3481;
import java.util.function.Consumer;

import static vazkii.botania.common.lib.ResourceLocationHelper.prefix;

public class PureDaisyProvider extends class_2446 implements BotaniaRecipeProvider {
	public PureDaisyProvider(class_2403 generator) {
		super(generator);
	}

	@Override
	public void registerRecipes(Consumer<class_2444> consumer) {

		consumer.accept(new FinishedRecipe(id("livingrock"), StateIngredientHelper.of(class_2246.field_10340), ModBlocks.livingrock.method_9564()));
		consumer.accept(new FinishedRecipe(id("livingwood"), StateIngredientHelper.of(class_3481.field_15475), ModBlocks.livingwood.method_9564()));

		consumer.accept(new FinishedRecipe(id("cobblestone"), StateIngredientHelper.of(class_2246.field_10515), class_2246.field_10445.method_9564()));
		consumer.accept(new FinishedRecipe(id("sand"), StateIngredientHelper.of(class_2246.field_10114), class_2246.field_10102.method_9564()));
		consumer.accept(new FinishedRecipe(id("packed_ice"), StateIngredientHelper.of(class_2246.field_10295), class_2246.field_10225.method_9564()));
		consumer.accept(new FinishedRecipe(id("blue_ice"), StateIngredientHelper.of(class_2246.field_10225), class_2246.field_10384.method_9564()));
		consumer.accept(new FinishedRecipe(id("obsidian"), StateIngredientHelper.of(ModBlocks.blazeBlock), class_2246.field_10540.method_9564()));
		consumer.accept(new FinishedRecipe(id("snow_block"), StateIngredientHelper.of(class_2246.field_10382), class_2246.field_10491.method_9564()));
	}

	@Override
	public String method_10321() {
		return "Botania Pure Daisy recipes";
	}

	private static class_2960 id(String path) {
		return prefix("pure_daisy/" + path);
	}

	private static class FinishedRecipe implements class_2444 {
		public static final int DEFAULT_TIME = 150;

		private final class_2960 id;
		private final StateIngredient input;
		private final class_2680 outputState;
		private final int time;

		private FinishedRecipe(class_2960 id, StateIngredient input, class_2680 state) {
			this(id, input, state, DEFAULT_TIME);
		}

		private FinishedRecipe(class_2960 id, StateIngredient input, class_2680 state, int time) {
			Preconditions.checkArgument(time >= 0, "Time must be nonnegative");
			this.id = id;
			this.input = input;
			this.outputState = state;
			this.time = time;
		}

		@Override
		public void method_10416(JsonObject json) {
			json.add("input", input.serialize());
			json.add("output", StateIngredientHelper.serializeBlockState(outputState));
			if (time != DEFAULT_TIME) {
				json.addProperty("time", time);
			}
		}

		@Override
		public class_2960 method_10417() {
			return id;
		}

		@Override
		public class_1865<?> method_17800() {
			return ModRecipeTypes.PURE_DAISY_SERIALIZER;
		}

		@Nullable
		@Override
		public JsonObject method_10415() {
			return null;
		}

		@Nullable
		@Override
		public class_2960 method_10418() {
			return null;
		}
	}
}
