/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.data.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;

import net.fabricmc.fabric.impl.tag.extension.TagDelegate;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2403;
import net.minecraft.class_2444;
import net.minecraft.class_2446;
import net.minecraft.class_2960;
import net.minecraft.class_3489;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.ModSubtiles;
import vazkii.botania.common.core.helper.ItemNBTHelper;
import vazkii.botania.common.crafting.ModRecipeTypes;
import vazkii.botania.common.item.ModItems;

import javax.annotation.Nullable;

import java.util.Arrays;
import java.util.function.Consumer;

import static vazkii.botania.common.lib.ResourceLocationHelper.prefix;

public class PetalProvider extends class_2446 implements BotaniaRecipeProvider {
	public PetalProvider(class_2403 gen) {
		super(gen);
	}

	@Override
	public String method_10321() {
		return "Botania petal apothecary recipes";
	}

	@Override
	public void registerRecipes(Consumer<class_2444> consumer) {
		class_1856 white = tagIngr("petals/white");
		class_1856 orange = tagIngr("petals/orange");
		class_1856 magenta = tagIngr("petals/magenta");
		class_1856 lightBlue = tagIngr("petals/light_blue");
		class_1856 yellow = tagIngr("petals/yellow");
		class_1856 lime = tagIngr("petals/lime");
		class_1856 pink = tagIngr("petals/pink");
		class_1856 gray = tagIngr("petals/gray");
		class_1856 lightGray = tagIngr("petals/light_gray");
		class_1856 cyan = tagIngr("petals/cyan");
		class_1856 purple = tagIngr("petals/purple");
		class_1856 blue = tagIngr("petals/blue");
		class_1856 brown = tagIngr("petals/brown");
		class_1856 green = tagIngr("petals/green");
		class_1856 red = tagIngr("petals/red");
		class_1856 black = tagIngr("petals/black");
		class_1856 runeWater = tagIngr("runes/water");
		class_1856 runeFire = tagIngr("runes/fire");
		class_1856 runeEarth = tagIngr("runes/earth");
		class_1856 runeAir = tagIngr("runes/air");
		class_1856 runeSpring = tagIngr("runes/spring");
		class_1856 runeSummer = tagIngr("runes/summer");
		class_1856 runeAutumn = tagIngr("runes/autumn");
		class_1856 runeWinter = tagIngr("runes/winter");
		class_1856 runeMana = tagIngr("runes/mana");
		class_1856 runeLust = tagIngr("runes/lust");
		class_1856 runeGluttony = tagIngr("runes/gluttony");
		class_1856 runeGreed = tagIngr("runes/greed");
		class_1856 runeSloth = tagIngr("runes/sloth");
		class_1856 runeWrath = tagIngr("runes/wrath");
		class_1856 runeEnvy = tagIngr("runes/envy");
		class_1856 runePride = tagIngr("runes/pride");

		class_1856 redstoneRoot = class_1856.method_8091(ModItems.redstoneRoot);
		class_1856 pixieDust = class_1856.method_8091(ModItems.pixieDust);
		class_1856 gaiaSpirit = class_1856.method_8091(ModItems.lifeEssence);

		consumer.accept(make(ModSubtiles.pureDaisy, white, white, white, white));
		consumer.accept(make(ModSubtiles.manastar, lightBlue, green, red, cyan));

		consumer.accept(make(ModSubtiles.endoflame, brown, brown, red, lightGray));
		consumer.accept(make(ModSubtiles.hydroangeas, blue, blue, cyan, cyan));
		consumer.accept(make(ModSubtiles.thermalily, red, orange, orange, runeEarth, runeFire));
		consumer.accept(make(ModSubtiles.rosaArcana, pink, pink, purple, purple, lime, runeMana));
		consumer.accept(make(ModSubtiles.munchdew, lime, lime, red, red, green, runeGluttony));
		consumer.accept(make(ModSubtiles.entropinnyum, red, red, gray, gray, white, white, runeWrath, runeFire));
		consumer.accept(make(ModSubtiles.kekimurus, white, white, orange, orange, brown, brown, runeGluttony, pixieDust));
		consumer.accept(make(ModSubtiles.gourmaryllis, lightGray, lightGray, yellow, yellow, red, runeFire, runeSummer));
		consumer.accept(make(ModSubtiles.narslimmus, lime, lime, green, green, black, runeSummer, runeWater));
		consumer.accept(make(ModSubtiles.spectrolus, red, red, green, green, blue, blue, white, white, runeWinter, runeAir, pixieDust));
		consumer.accept(make(ModSubtiles.rafflowsia, purple, purple, green, green, black, runeEarth, runePride, pixieDust));
		consumer.accept(make(ModSubtiles.shulkMeNot, purple, purple, magenta, magenta, lightGray, gaiaSpirit, runeEnvy, runeWrath));
		consumer.accept(make(ModSubtiles.dandelifeon, purple, purple, lime, green, runeWater, runeFire, runeEarth, runeAir, gaiaSpirit));

		consumer.accept(make(ModSubtiles.jadedAmaranthus, purple, lime, green, runeSpring, redstoneRoot));
		consumer.accept(make(ModSubtiles.bellethorn, red, red, red, cyan, cyan, redstoneRoot));
		consumer.accept(make(ModSubtiles.dreadthorn, black, black, black, cyan, cyan, redstoneRoot));
		consumer.accept(make(ModSubtiles.heiseiDream, magenta, magenta, purple, pink, runeWrath, pixieDust));
		consumer.accept(make(ModSubtiles.tigerseye, yellow, brown, orange, lime, runeAutumn));

		consumer.accept(make(ModSubtiles.orechid, gray, gray, yellow, green, red, runePride, runeGreed, redstoneRoot, pixieDust));

		consumer.accept(make(ModSubtiles.orechidIgnem, red, red, white, white, pink, runePride, runeGreed, redstoneRoot, pixieDust));
		consumer.accept(make(ModSubtiles.fallenKanade, white, white, yellow, yellow, orange, runeSpring));
		consumer.accept(make(ModSubtiles.exoflame, red, red, gray, lightGray, runeFire, runeSummer));
		consumer.accept(make(ModSubtiles.agricarnation, lime, lime, green, yellow, runeSpring, redstoneRoot));
		consumer.accept(make(ModSubtiles.hopperhock, gray, gray, lightGray, lightGray, runeAir, redstoneRoot));
		consumer.accept(make(ModSubtiles.tangleberrie, cyan, cyan, gray, lightGray, runeAir, runeEarth));
		consumer.accept(make(ModSubtiles.jiyuulia, pink, pink, purple, lightGray, runeWater, runeAir));
		consumer.accept(make(ModSubtiles.rannuncarpus, orange, orange, yellow, runeEarth, redstoneRoot));
		consumer.accept(make(ModSubtiles.hyacidus, purple, purple, magenta, magenta, green, runeWater, runeAutumn, redstoneRoot));
		consumer.accept(make(ModSubtiles.pollidisiac, red, red, pink, pink, orange, runeLust, runeFire));
		consumer.accept(make(ModSubtiles.clayconia, lightGray, lightGray, gray, cyan, runeEarth));
		consumer.accept(make(ModSubtiles.loonium, green, green, green, green, gray, runeSloth, runeGluttony, runeEnvy, redstoneRoot, pixieDust));
		consumer.accept(make(ModSubtiles.daffomill, white, white, brown, yellow, runeAir, redstoneRoot));
		consumer.accept(make(ModSubtiles.vinculotus, black, black, purple, purple, green, runeWater, runeSloth, runeLust, redstoneRoot));
		consumer.accept(make(ModSubtiles.spectranthemum, white, white, lightGray, lightGray, cyan, runeEnvy, runeWater, redstoneRoot, pixieDust));
		consumer.accept(make(ModSubtiles.medumone, brown, brown, gray, gray, runeEarth, redstoneRoot));
		consumer.accept(make(ModSubtiles.marimorphosis, gray, yellow, green, red, runeEarth, runeFire, redstoneRoot));
		consumer.accept(make(ModSubtiles.bubbell, cyan, cyan, lightBlue, lightBlue, blue, blue, runeWater, runeSummer, pixieDust));
		consumer.accept(make(ModSubtiles.solegnolia, brown, brown, red, blue, redstoneRoot));
		consumer.accept(make(ModSubtiles.bergamute, orange, green, green, redstoneRoot));

		consumer.accept(make(ModBlocks.motifDaybloom, yellow, yellow, orange, lightBlue));
		consumer.accept(make(ModBlocks.motifNightshade, black, black, purple, gray));

		class_1799 stack = new class_1799(class_1802.field_8575);
		ItemNBTHelper.setString(stack, "SkullOwner", "Vazkii");
		class_1856[] inputs = new class_1856[16];
		Arrays.fill(inputs, pink);
		consumer.accept(new FinishedRecipe(idFor(prefix("vazkii_head")), stack, inputs));
	}

	private static class_1856 tagIngr(String tag) {
		return class_1856.method_8106(new TagDelegate<>(prefix(tag), class_3489::method_15106));
	}

	private static FinishedRecipe make(class_1935 item, class_1856... ingredients) {
		return new FinishedRecipe(idFor(class_2378.field_11142.method_10221(item.method_8389())), new class_1799(item), ingredients);
	}

	private static class_2960 idFor(class_2960 name) {
		return new class_2960(name.method_12836(), "petal_apothecary/" + name.method_12832());
	}

	private static class FinishedRecipe implements class_2444 {
		private final class_2960 id;
		private final class_1799 output;
		private final class_1856[] inputs;

		private FinishedRecipe(class_2960 id, class_1799 output, class_1856... inputs) {
			this.id = id;
			this.output = output;
			this.inputs = inputs;
		}

		@Override
		public void method_10416(JsonObject json) {
			json.add("output", ItemNBTHelper.serializeStack(output));
			JsonArray ingredients = new JsonArray();
			for (class_1856 ingr : inputs) {
				ingredients.add(ingr.method_8089());
			}
			json.add("ingredients", ingredients);
		}

		@Override
		public class_2960 method_10417() {
			return id;
		}

		@Override
		public class_1865<?> method_17800() {
			return ModRecipeTypes.PETAL_SERIALIZER;
		}

		@Nullable
		@Override
		public JsonObject method_10415() {
			return null;
		}

		@Nullable
		@Override
		public class_2960 method_10418() {
			return null;
		}
	}
}
