/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.data.recipes;

import com.google.gson.JsonObject;
import net.minecraft.class_1767;
import net.minecraft.class_1769;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2378;
import net.minecraft.class_2403;
import net.minecraft.class_2444;
import net.minecraft.class_2446;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3489;
import net.minecraft.item.*;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.ModFluffBlocks;
import vazkii.botania.common.block.ModSubtiles;
import vazkii.botania.common.core.helper.ItemNBTHelper;
import vazkii.botania.common.crafting.ModRecipeTypes;
import vazkii.botania.common.crafting.StateIngredientHelper;
import vazkii.botania.common.item.ModItems;

import javax.annotation.Nullable;

import java.util.Arrays;
import java.util.function.Consumer;

import static vazkii.botania.common.lib.ResourceLocationHelper.prefix;

public class ManaInfusionProvider extends class_2446 implements BotaniaRecipeProvider {
	public ManaInfusionProvider(class_2403 gen) {
		super(gen);
	}

	@Override
	public String method_10321() {
		return "Botania mana pool recipes";
	}

	@Override
	public void registerRecipes(Consumer<class_2444> consumer) {
		consumer.accept(new FinishedRecipe(id("manasteel"), new class_1799(ModItems.manaSteel), class_1856.method_8091(class_1802.field_8620), 3000));
		consumer.accept(new FinishedRecipe(id("manasteel_block"), new class_1799(ModBlocks.manasteelBlock), ingr(class_2246.field_10085), 27000));

		consumer.accept(new FinishedRecipe(id("mana_pearl"), new class_1799(ModItems.manaPearl), ingr(class_1802.field_8634), 6000));

		consumer.accept(new FinishedRecipe(id("mana_diamond"), new class_1799(ModItems.manaDiamond), class_1856.method_8091(class_1802.field_8477), 10000));
		consumer.accept(new FinishedRecipe(id("mana_diamond_block"), new class_1799(ModBlocks.manaDiamondBlock), ingr(class_2246.field_10201), 90000));

		class_1856 dust = class_1856.method_8091(class_1802.field_8054, class_1802.field_8725, class_1802.field_8601, class_1802.field_8479);
		consumer.accept(new FinishedRecipe(id("mana_powder_dust"), new class_1799(ModItems.manaPowder), dust, 500));
		class_1856 dyeIngredient = class_1856.method_8091(Arrays.stream(class_1767.values()).map(class_1769::method_7803).toArray(class_1792[]::new));
		consumer.accept(new FinishedRecipe(id("mana_powder_dye"), new class_1799(ModItems.manaPowder), dyeIngredient, 400));

		consumer.accept(new FinishedRecipe(id("piston_relay"), new class_1799(ModBlocks.pistonRelay), ingr(class_2246.field_10560), 15000));
		consumer.accept(new FinishedRecipe(id("mana_cookie"), new class_1799(ModItems.manaCookie), ingr(class_1802.field_8423), 20000));
		consumer.accept(new FinishedRecipe(id("grass_seeds"), new class_1799(ModItems.grassSeeds), ingr(class_2246.field_10479), 2500));
		consumer.accept(new FinishedRecipe(id("podzol_seeds"), new class_1799(ModItems.podzolSeeds), ingr(class_2246.field_10428), 2500));

		consumer.accept(new FinishedRecipe(id("mycel_seeds"), new class_1799(ModItems.mycelSeeds), class_1856.method_8091(class_2246.field_10559, class_2246.field_10251), 6500));

		consumer.accept(new FinishedRecipe(id("mana_quartz"), new class_1799(ModItems.manaQuartz), ingr(class_1802.field_8155), 250));
		consumer.accept(new FinishedRecipe(id("tiny_potato"), new class_1799(ModBlocks.tinyPotato), ingr(class_1802.field_8567), 1337));

		consumer.accept(new FinishedRecipe(id("mana_glass"), new class_1799(ModBlocks.manaGlass), ingr(class_2246.field_10033), 150));
		consumer.accept(new FinishedRecipe(id("mana_string"), new class_1799(ModItems.manaString), ingr(class_1802.field_8276), 5000));

		consumer.accept(new FinishedRecipe(id("mana_bottle"), new class_1799(ModItems.manaBottle), ingr(class_1802.field_8469), 5000));

		consumer.accept(FinishedRecipe.alchemy(id("rotten_flesh_to_leather"), new class_1799(class_1802.field_8745), ingr(class_1802.field_8511), 600));

		cycle(consumer, 40, "botania:log_cycle", class_2246.field_10431, class_2246.field_10037, class_2246.field_10511, class_2246.field_10306, class_2246.field_10533, class_2246.field_10010);
		cycle(consumer, 120, "botania:sapling_cycle", class_2246.field_10394, class_2246.field_10217, class_2246.field_10575, class_2246.field_10276, class_2246.field_10385, class_2246.field_10160);

		consumer.accept(FinishedRecipe.alchemy(id("glowstone_deconstruct"), new class_1799(class_1802.field_8601, 4), ingr(class_2246.field_10171), 25));
		consumer.accept(FinishedRecipe.alchemy(id("quartz_deconstruct"), new class_1799(class_1802.field_8155, 4), ingr(class_2246.field_10153), 25));
		consumer.accept(FinishedRecipe.alchemy(id("dark_quartz_deconstruct"), new class_1799(ModItems.darkQuartz, 4), ingr(ModFluffBlocks.darkQuartz), 25));
		consumer.accept(FinishedRecipe.alchemy(id("mana_quartz_deconstruct"), new class_1799(ModItems.manaQuartz, 4), ingr(ModFluffBlocks.manaQuartz), 25));
		consumer.accept(FinishedRecipe.alchemy(id("blaze_quartz_deconstruct"), new class_1799(ModItems.blazeQuartz, 4), ingr(ModFluffBlocks.blazeQuartz), 25));
		consumer.accept(FinishedRecipe.alchemy(id("lavender_quartz_deconstruct"), new class_1799(ModItems.lavenderQuartz, 4), ingr(ModFluffBlocks.lavenderQuartz), 25));
		consumer.accept(FinishedRecipe.alchemy(id("red_quartz_deconstruct"), new class_1799(ModItems.redQuartz, 4), ingr(ModFluffBlocks.redQuartz), 25));
		consumer.accept(FinishedRecipe.alchemy(id("elf_quartz_deconstruct"), new class_1799(ModItems.elfQuartz, 4), ingr(ModFluffBlocks.elfQuartz), 25));

		consumer.accept(FinishedRecipe.alchemy(id("chiseled_stone_bricks"), new class_1799(class_2246.field_10552, 1), ingr(class_2246.field_10056), 150));
		consumer.accept(FinishedRecipe.alchemy(id("ice"), new class_1799(class_2246.field_10295), ingr(class_2246.field_10491), 2250));

		consumer.accept(FinishedRecipe.alchemy(id("vine_to_lily_pad"), new class_1799(class_2246.field_10588), ingr(class_2246.field_10597), 320));
		consumer.accept(FinishedRecipe.alchemy(id("lily_pad_to_vine"), new class_1799(class_2246.field_10597), ingr(class_2246.field_10588), 320));

		cycle(consumer, 200, "botania:fish_cycle", class_1802.field_8429, class_1802.field_8209, class_1802.field_8846, class_1802.field_8323);
		cycle(consumer, 6000, "botania:crop_cycle", class_1802.field_8116, class_1802.field_8317, class_1802.field_8567, class_1802.field_8179, class_1802.field_8309, class_1802.field_8188, class_1802.field_8706);

		consumer.accept(FinishedRecipe.alchemy(id("potato_unpoison"), new class_1799(class_1802.field_8567), ingr(class_1802.field_8635), 1200));
		consumer.accept(FinishedRecipe.alchemy(id("blaze_rod_to_nether_wart"), new class_1799(class_1802.field_8790), ingr(class_1802.field_8894), 4000));

		cycle(consumer, 200, "", class_1802.field_8054, class_1802.field_8145);

		consumer.accept(FinishedRecipe.alchemy(id("book_to_name_tag"), new class_1799(class_1802.field_8448), ingr(class_1802.field_8674), 16000));

		consumer.accept(FinishedRecipe.alchemy(id("wool_deconstruct"), new class_1799(class_1802.field_8276, 3), class_1856.method_8106(class_3489.field_15544), 100));

		consumer.accept(FinishedRecipe.alchemy(id("cactus_to_slime"), new class_1799(class_1802.field_8777), ingr(class_2246.field_10029), 1200));
		consumer.accept(FinishedRecipe.alchemy(id("slime_to_cactus"), new class_1799(class_2246.field_10029), ingr(class_1802.field_8777), 1200));

		consumer.accept(FinishedRecipe.alchemy(id("ender_pearl_from_ghast_tear"), new class_1799(class_1802.field_8634), ingr(class_1802.field_8070), 28000));

		cycle(consumer, 300, "", class_1802.field_8601, class_1802.field_8725);

		consumer.accept(FinishedRecipe.alchemy(id("cobble_to_sand"), new class_1799(class_2246.field_10102), ingr(class_2246.field_10445), 50));
		consumer.accept(FinishedRecipe.alchemy(id("terracotta_to_red_sand"), new class_1799(class_2246.field_10534), ingr(class_2246.field_10415), 50));

		consumer.accept(FinishedRecipe.alchemy(id("clay_deconstruct"), new class_1799(class_1802.field_8696, 4), ingr(class_2246.field_10460), 25));
		consumer.accept(FinishedRecipe.alchemy(id("brick_deconstruct"), new class_1799(class_1802.field_8621, 4), ingr(class_2246.field_10104), 25));

		consumer.accept(FinishedRecipe.alchemy(id("coarse_dirt"), new class_1799(class_2246.field_10253), ingr(class_2246.field_10566), 120));

		consumer.accept(FinishedRecipe.alchemy(id("stone_to_andesite"), new class_1799(class_2246.field_10115), ingr(class_2246.field_10340), 200));
		consumer.accept(FinishedRecipe.alchemy(id("andesite_to_diorite"), new class_1799(class_2246.field_10508), ingr(class_2246.field_10115), 200));
		consumer.accept(FinishedRecipe.alchemy(id("diorite_to_granite"), new class_1799(class_2246.field_10474), ingr(class_2246.field_10508), 200));
		consumer.accept(FinishedRecipe.alchemy(id("granite_to_andesite"), new class_1799(class_2246.field_10115), ingr(class_2246.field_10474), 200));

		cycle(consumer, 500, "botania:shrub_cycle", class_2246.field_10112, class_2246.field_10428, class_2246.field_10479);

		// NB: No wither rose is intentional
		cycle(consumer, 400, "botania:flower_cycle", class_2246.field_10182, class_2246.field_10449, class_2246.field_10086, class_2246.field_10226, class_2246.field_10573, class_2246.field_10270, class_2246.field_10048,
				class_2246.field_10156, class_2246.field_10315, class_2246.field_10554, class_2246.field_9995, class_2246.field_10548,
				class_2246.field_10583, class_2246.field_10378, class_2246.field_10430, class_2246.field_10003);

		consumer.accept(FinishedRecipe.alchemy(id("chorus_fruit_to_flower"), new class_1799(class_2246.field_10528), ingr(class_1802.field_8882), 10000));

		cycle(consumer, 240, "botania:berry_cycle", class_1802.field_8279, class_1802.field_16998);

		consumer.accept(mini(ModSubtiles.agricarnationChibi, ModSubtiles.agricarnation));
		consumer.accept(mini(ModSubtiles.clayconiaChibi, ModSubtiles.clayconia));
		consumer.accept(mini(ModSubtiles.bellethornChibi, ModSubtiles.bellethorn));
		consumer.accept(mini(ModSubtiles.bubbellChibi, ModSubtiles.bubbell));
		consumer.accept(mini(ModSubtiles.hopperhockChibi, ModSubtiles.hopperhock));
		consumer.accept(mini(ModSubtiles.marimorphosisChibi, ModSubtiles.marimorphosis));
		consumer.accept(mini(ModSubtiles.rannuncarpusChibi, ModSubtiles.rannuncarpus));
		consumer.accept(mini(ModSubtiles.solegnoliaChibi, ModSubtiles.solegnolia));

		consumer.accept(FinishedRecipe.alchemy(id("hydroangeas_motif"), new class_1799(ModBlocks.motifHydroangeas), ingr(ModSubtiles.hydroangeas), 2500));

		consumer.accept(FinishedRecipe.conjuration(id("redstone_dupe"), new class_1799(class_1802.field_8725, 2), ingr(class_1802.field_8725), 5000));
		consumer.accept(FinishedRecipe.conjuration(id("glowstone_dupe"), new class_1799(class_1802.field_8601, 2), ingr(class_1802.field_8601), 5000));
		consumer.accept(FinishedRecipe.conjuration(id("quartz_dupe"), new class_1799(class_1802.field_8155, 2), ingr(class_1802.field_8155), 2500));
		consumer.accept(FinishedRecipe.conjuration(id("coal_dupe"), new class_1799(class_1802.field_8713, 2), ingr(class_1802.field_8713), 2100));
		consumer.accept(FinishedRecipe.conjuration(id("snowball_dupe"), new class_1799(class_1802.field_8543, 2), ingr(class_1802.field_8543), 200));
		consumer.accept(FinishedRecipe.conjuration(id("netherrack_dupe"), new class_1799(class_2246.field_10515, 2), ingr(class_2246.field_10515), 200));
		consumer.accept(FinishedRecipe.conjuration(id("soul_sand_dupe"), new class_1799(class_2246.field_10114, 2), ingr(class_2246.field_10114), 1500));
		consumer.accept(FinishedRecipe.conjuration(id("gravel_dupe"), new class_1799(class_2246.field_10255, 2), ingr(class_2246.field_10255), 720));

		consumer.accept(FinishedRecipe.conjuration(id("oak_leaves_dupe"), new class_1799(class_2246.field_10503, 2), ingr(class_2246.field_10503), 2000));
		consumer.accept(FinishedRecipe.conjuration(id("birch_leaves_dupe"), new class_1799(class_2246.field_10539, 2), ingr(class_2246.field_10539), 2000));
		consumer.accept(FinishedRecipe.conjuration(id("spruce_leaves_dupe"), new class_1799(class_2246.field_9988, 2), ingr(class_2246.field_9988), 2000));
		consumer.accept(FinishedRecipe.conjuration(id("jungle_leaves_dupe"), new class_1799(class_2246.field_10335, 2), ingr(class_2246.field_10335), 2000));
		consumer.accept(FinishedRecipe.conjuration(id("acacia_leaves_dupe"), new class_1799(class_2246.field_10098, 2), ingr(class_2246.field_10098), 2000));
		consumer.accept(FinishedRecipe.conjuration(id("dark_oak_leaves_dupe"), new class_1799(class_2246.field_10035, 2), ingr(class_2246.field_10035), 2000));

		consumer.accept(FinishedRecipe.conjuration(id("grass"), new class_1799(class_2246.field_10479, 2), ingr(class_2246.field_10479), 800));
	}

	private static void cycle(Consumer<class_2444> consumer, int cost, String group, class_1935... items) {
		for (int i = 0; i < items.length; i++) {
			class_1856 in = ingr(items[i]);
			class_1799 out = new class_1799(i == items.length - 1 ? items[0] : items[i + 1]);
			String id = String.format("%s_to_%s", class_2378.field_11142.method_10221(items[i].method_8389()).method_12832(), class_2378.field_11142.method_10221(out.method_7909()).method_12832());
			consumer.accept(FinishedRecipe.alchemy(id(id), out, in, cost, group));
		}
	}

	private static FinishedRecipe mini(class_1935 mini, class_1935 full) {
		return FinishedRecipe.alchemy(id(class_2378.field_11142.method_10221(mini.method_8389()).method_12832()), new class_1799(mini), ingr(full), 2500, "botania:flower_shrinking");
	}

	private static class_2960 id(String s) {
		return prefix("mana_infusion/" + s);
	}

	private static class_1856 ingr(class_1935 i) {
		return class_1856.method_8091(i);
	}

	private static class FinishedRecipe implements class_2444 {
		private final class_2960 id;
		private final class_1856 input;
		private final class_1799 output;
		private final int mana;
		private final String group;
		@Nullable
		private final class_2680 catalyst;

		public static FinishedRecipe conjuration(class_2960 id, class_1799 output, class_1856 input, int mana) {
			return new FinishedRecipe(id, output, input, mana, "", ModBlocks.conjurationCatalyst.method_9564());
		}

		public static FinishedRecipe alchemy(class_2960 id, class_1799 output, class_1856 input, int mana) {
			return alchemy(id, output, input, mana, "");
		}

		public static FinishedRecipe alchemy(class_2960 id, class_1799 output, class_1856 input, int mana, String group) {
			return new FinishedRecipe(id, output, input, mana, group, ModBlocks.alchemyCatalyst.method_9564());
		}

		public FinishedRecipe(class_2960 id, class_1799 output, class_1856 input, int mana) {
			this(id, output, input, mana, "");
		}

		public FinishedRecipe(class_2960 id, class_1799 output, class_1856 input, int mana, String group) {
			this(id, output, input, mana, group, null);
		}

		public FinishedRecipe(class_2960 id, class_1799 output, class_1856 input, int mana, String group, @Nullable class_2680 catalyst) {
			this.id = id;
			this.input = input;
			this.output = output;
			this.mana = mana;
			this.group = group;
			this.catalyst = catalyst;
		}

		@Override
		public void method_10416(JsonObject json) {
			json.add("input", input.method_8089());
			json.add("output", ItemNBTHelper.serializeStack(output));
			json.addProperty("mana", mana);
			if (!group.isEmpty()) {
				json.addProperty("group", group);
			}
			if (catalyst != null) {
				json.add("catalyst", StateIngredientHelper.serializeBlockState(catalyst));
			}
		}

		@SuppressWarnings("unchecked")
		private static <T extends Comparable<T>> String getName(class_2769<T> prop, Comparable<?> val) {
			return prop.method_11901((T) val);
		}

		@Override
		public class_2960 method_10417() {
			return id;
		}

		@Override
		public class_1865<?> method_17800() {
			return ModRecipeTypes.MANA_INFUSION_SERIALIZER;
		}

		@Nullable
		@Override
		public JsonObject method_10415() {
			return null;
		}

		@Nullable
		@Override
		public class_2960 method_10418() {
			return null;
		}
	}
}
