/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.data.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.brew.Brew;
import vazkii.botania.common.brew.ModBrews;
import vazkii.botania.common.crafting.ModRecipeTypes;
import vazkii.botania.common.item.ModItems;

import javax.annotation.Nullable;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_2246;
import net.minecraft.class_2403;
import net.minecraft.class_2444;
import net.minecraft.class_2446;
import net.minecraft.class_2960;
import net.minecraft.class_3489;
import java.util.function.Consumer;

import static vazkii.botania.common.lib.ResourceLocationHelper.prefix;

public class BrewProvider extends class_2446 implements BotaniaRecipeProvider {
	public BrewProvider(class_2403 gen) {
		super(gen);
	}

	@Override
	public String method_10321() {
		return "Botania Brew recipes";
	}

	@Override
	public void registerRecipes(Consumer<class_2444> consumer) {
		consumer.accept(new FinishedRecipe(idFor("speed"), ModBrews.speed, class_1856.method_8091(class_1802.field_8790), class_1856.method_8091(class_1802.field_8479), class_1856.method_8091(class_1802.field_8725)));
		consumer.accept(new FinishedRecipe(idFor("strength"), ModBrews.strength, class_1856.method_8091(class_1802.field_8790), class_1856.method_8091(class_1802.field_8183), class_1856.method_8091(class_1802.field_8601)));
		consumer.accept(new FinishedRecipe(idFor("haste"), ModBrews.haste, class_1856.method_8091(class_1802.field_8790), class_1856.method_8091(class_1802.field_8479), class_1856.method_8091(class_1802.field_8397)));
		consumer.accept(new FinishedRecipe(idFor("healing"), ModBrews.healing, class_1856.method_8091(class_1802.field_8790), class_1856.method_8091(class_1802.field_8597), class_1856.method_8091(class_1802.field_8567)));
		consumer.accept(new FinishedRecipe(idFor("jump_boost"), ModBrews.jumpBoost, class_1856.method_8091(class_1802.field_8790), class_1856.method_8091(class_1802.field_8153), class_1856.method_8091(class_1802.field_8179)));
		consumer.accept(new FinishedRecipe(idFor("regeneration"), ModBrews.regen, class_1856.method_8091(class_1802.field_8790), class_1856.method_8091(class_1802.field_8070), class_1856.method_8091(class_1802.field_8601)));
		consumer.accept(new FinishedRecipe(idFor("weak_regeneration"), ModBrews.regenWeak, class_1856.method_8091(class_1802.field_8790), class_1856.method_8091(class_1802.field_8070), class_1856.method_8091(class_1802.field_8725)));
		consumer.accept(new FinishedRecipe(idFor("resistance"), ModBrews.resistance, class_1856.method_8091(class_1802.field_8790), class_1856.method_8091(class_1802.field_8620), class_1856.method_8091(class_1802.field_8745)));
		consumer.accept(new FinishedRecipe(idFor("fire_resistance"), ModBrews.fireResistance, class_1856.method_8091(class_1802.field_8790), class_1856.method_8091(class_1802.field_8135), class_1856.method_8091(class_2246.field_10515)));
		consumer.accept(new FinishedRecipe(idFor("water_breathing"), ModBrews.waterBreathing, class_1856.method_8091(class_1802.field_8790), class_1856.method_8091(class_1802.field_8434), class_1856.method_8091(class_1802.field_8601)));
		consumer.accept(new FinishedRecipe(idFor("invisibility"), ModBrews.invisibility, class_1856.method_8091(class_1802.field_8790), class_1856.method_8091(class_1802.field_8543), class_1856.method_8091(class_1802.field_8601)));
		consumer.accept(new FinishedRecipe(idFor("night_vision"), ModBrews.nightVision, class_1856.method_8091(class_1802.field_8790), class_1856.method_8091(class_1802.field_8680), class_1856.method_8091(class_1802.field_8071)));
		consumer.accept(new FinishedRecipe(idFor("absorption"), ModBrews.absorption, class_1856.method_8091(class_1802.field_8790), class_1856.method_8091(class_1802.field_8463), class_1856.method_8091(class_1802.field_8567)));

		consumer.accept(new FinishedRecipe(idFor("overload"), ModBrews.overload, class_1856.method_8091(class_1802.field_8790), class_1856.method_8091(class_1802.field_8183), class_1856.method_8091(class_1802.field_8479), class_1856.method_8091(class_1802.field_8601), class_1856.method_8091(ModItems.manaSteel), class_1856.method_8091(class_1802.field_8680)));
		consumer.accept(new FinishedRecipe(idFor("soul_cross"), ModBrews.soulCross, class_1856.method_8091(class_1802.field_8790), class_1856.method_8091(class_2246.field_10114), class_1856.method_8091(class_1802.field_8407), class_1856.method_8091(class_1802.field_8279), class_1856.method_8091(class_1802.field_8606)));
		consumer.accept(new FinishedRecipe(idFor("feather_feet"), ModBrews.featherfeet, class_1856.method_8091(class_1802.field_8790), class_1856.method_8091(class_1802.field_8153), class_1856.method_8091(class_1802.field_8745), class_1856.method_8106(class_3489.field_15544)));
		consumer.accept(new FinishedRecipe(idFor("emptiness"), ModBrews.emptiness, class_1856.method_8091(class_1802.field_8790), class_1856.method_8091(class_1802.field_8054), class_1856.method_8091(class_1802.field_8511), class_1856.method_8091(class_1802.field_8606), class_1856.method_8091(class_1802.field_8276), class_1856.method_8091(class_1802.field_8634)));
		consumer.accept(new FinishedRecipe(idFor("bloodthirst"), ModBrews.bloodthirst, class_1856.method_8091(class_1802.field_8790), class_1856.method_8091(class_1802.field_8711), class_1856.method_8091(class_1802.field_8759), class_1856.method_8091(class_1802.field_8814), class_1856.method_8091(class_1802.field_8620)));
		consumer.accept(new FinishedRecipe(idFor("allure"), ModBrews.allure, class_1856.method_8091(class_1802.field_8790), class_1856.method_8091(class_1802.field_8429), class_1856.method_8091(class_1802.field_8155), class_1856.method_8091(class_1802.field_8071)));
		consumer.accept(new FinishedRecipe(idFor("clear"), ModBrews.clear, class_1856.method_8091(class_1802.field_8790), class_1856.method_8091(class_1802.field_8155), class_1856.method_8091(class_1802.field_8687), class_1856.method_8091(class_1802.field_8497)));
	}

	private static class_2960 idFor(String s) {
		return prefix("brew/" + s);
	}

	private static class FinishedRecipe implements class_2444 {
		private final class_2960 id;
		private final Brew brew;
		private final class_1856[] inputs;

		private FinishedRecipe(class_2960 id, Brew brew, class_1856... inputs) {
			this.id = id;
			this.brew = brew;
			this.inputs = inputs;
		}

		@Override
		public void method_10416(JsonObject json) {
			json.addProperty("brew", BotaniaAPI.instance().getBrewRegistry().method_10221(brew).toString());
			JsonArray ingredients = new JsonArray();
			for (class_1856 ingr : inputs) {
				ingredients.add(ingr.method_8089());
			}
			json.add("ingredients", ingredients);
		}

		@Override
		public class_2960 method_10417() {
			return id;
		}

		@Override
		public class_1865<?> method_17800() {
			return ModRecipeTypes.BREW_SERIALIZER;
		}

		@Nullable
		@Override
		public JsonObject method_10415() {
			return null;
		}

		@Nullable
		@Override
		public class_2960 method_10418() {
			return null;
		}
	}
}
