/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.data;

import net.fabricmc.fabric.api.tool.attribute.v1.FabricToolTags;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2378;
import net.minecraft.class_2403;
import net.minecraft.class_2471;
import net.minecraft.class_2474;
import net.minecraft.class_3481;
import net.minecraft.class_3489;
import net.minecraft.class_3494;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.item.lens.ItemLens;
import vazkii.botania.common.lib.LibMisc;
import vazkii.botania.common.lib.ModTags;

import javax.annotation.Nonnull;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

import static vazkii.botania.common.lib.ResourceLocationHelper.prefix;

public class ItemTagProvider extends class_2471 {
	public ItemTagProvider(class_2403 generatorIn, BlockTagProvider blockTagProvider) {
		super(generatorIn, blockTagProvider);
	}

	@Override
	protected void method_10514() {
		this.method_10505(class_3481.field_15463, class_3489.field_15529);
		this.method_10505(class_3481.field_15469, class_3489.field_15535);
		this.method_10505(class_3481.field_15459, class_3489.field_15526);
		this.method_10505(class_3481.field_15504, class_3489.field_15560);
		this.method_10505(class_3481.field_16584, class_3489.field_16585);

		this.method_10512((class_3494.class_5123<class_1792>) FabricToolTags.SHEARS).method_26795(ModItems.elementiumShears, ModItems.manasteelShears);

		this.method_10505(ModTags.Blocks.MUNDANE_FLOATING_FLOWERS, ModTags.Items.MUNDANE_FLOATING_FLOWERS);
		this.method_10505(ModTags.Blocks.SPECIAL_FLOATING_FLOWERS, ModTags.Items.SPECIAL_FLOATING_FLOWERS);
		this.method_10505(ModTags.Blocks.FLOATING_FLOWERS, ModTags.Items.FLOATING_FLOWERS);
		this.method_10505(ModTags.Blocks.DOUBLE_MYSTICAL_FLOWERS, ModTags.Items.DOUBLE_MYSTICAL_FLOWERS);
		this.method_10505(ModTags.Blocks.MYSTICAL_FLOWERS, ModTags.Items.MYSTICAL_FLOWERS);

		this.method_10505(ModTags.Blocks.MISC_SPECIAL_FLOWERS, ModTags.Items.MISC_SPECIAL_FLOWERS);
		this.method_10505(ModTags.Blocks.GENERATING_SPECIAL_FLOWERS, ModTags.Items.GENERATING_SPECIAL_FLOWERS);
		this.method_10505(ModTags.Blocks.FUNCTIONAL_SPECIAL_FLOWERS, ModTags.Items.FUNCTIONAL_SPECIAL_FLOWERS);
		this.method_10505(ModTags.Blocks.SPECIAL_FLOWERS, ModTags.Items.SPECIAL_FLOWERS);
		this.method_10505(ModTags.Blocks.MINI_FLOWERS, ModTags.Items.MINI_FLOWERS);
		this.method_10512(ModTags.Items.CONTRIBUTOR_HEADFLOWERS)
				.method_26792(ModTags.Items.SPECIAL_FLOWERS)
				.method_26795(ModBlocks.motifDaybloom.method_8389(), ModBlocks.motifNightshade.method_8389());

		this.method_10512(class_3489.field_20343).method_26792(ModTags.Items.DOUBLE_MYSTICAL_FLOWERS);
		this.method_10512(class_3489.field_15543).method_26792(ModTags.Items.MYSTICAL_FLOWERS).method_26792(ModTags.Items.SPECIAL_FLOWERS);

		this.method_10512(ModTags.Items.BURST_VIEWERS).method_26793(ModItems.monocle);
		this.method_10512(ModTags.Items.TERRA_PICK_BLACKLIST).method_26795(ModItems.auraRing, ModItems.auraRingGreater, ModItems.terrasteelHelm);
		class_2474.class_5124<class_1792> builder = this.method_10512(ModTags.Items.LENS);
		class_2378.field_11142.method_10220().filter(i -> i instanceof ItemLens && class_2378.field_11142.method_10221(i).method_12836().equals(LibMisc.MOD_ID))
				.sorted(Comparator.comparing(class_2378.field_11142::method_10221))
				.forEach(builder::method_26793);

		this.method_10512(class_3489.field_24481).method_26795(ModBlocks.alchemyCatalyst.method_8389(), ModItems.cacophonium, ModItems.divaCharm,
				ModBlocks.hourglass.method_8389(), ModBlocks.manaPylon.method_8389(), ModItems.monocle);
		this.method_10512(class_3489.field_15541).method_26795(ModItems.recordGaia1, ModItems.recordGaia2);

		this.method_10512(ModTags.Items.DUSTS_MANA).method_26793(ModItems.manaPowder);

		this.method_10512(ModTags.Items.GEMS_DRAGONSTONE).method_26793(ModItems.dragonstone);
		this.method_10512(ModTags.Items.GEMS_MANA_DIAMOND).method_26793(ModItems.manaDiamond);

		this.method_10512(ModTags.Items.INGOTS_ELEMENTIUM).method_26793(ModItems.elementium);
		this.method_10512(ModTags.Items.INGOTS_MANASTEEL).method_26793(ModItems.manaSteel);
		this.method_10512(ModTags.Items.INGOTS_TERRASTEEL).method_26793(ModItems.terrasteel);

		this.method_10512(ModTags.Items.NUGGETS_ELEMENTIUM).method_26793(ModItems.elementiumNugget);
		this.method_10512(ModTags.Items.NUGGETS_MANASTEEL).method_26793(ModItems.manasteelNugget);
		this.method_10512(ModTags.Items.NUGGETS_TERRASTEEL).method_26793(ModItems.terrasteelNugget);

		this.method_10505(ModTags.Blocks.BLOCKS_ELEMENTIUM, ModTags.Items.BLOCKS_ELEMENTIUM);
		this.method_10505(ModTags.Blocks.BLOCKS_MANASTEEL, ModTags.Items.BLOCKS_MANASTEEL);
		this.method_10505(ModTags.Blocks.BLOCKS_QUARTZ, ModTags.Items.BLOCKS_QUARTZ);
		this.method_10505(ModTags.Blocks.BLOCKS_TERRASTEEL, ModTags.Items.BLOCKS_TERRASTEEL);
		// todo 1.16-fabric this.copy(Tags.Blocks.STORAGE_BLOCKS, Tags.Items.STORAGE_BLOCKS);
		this.method_10505(ModTags.Blocks.LIVINGWOOD, ModTags.Items.LIVINGWOOD);
		this.method_10505(ModTags.Blocks.LIVINGROCK, ModTags.Items.LIVINGROCK);

		this.method_10512(ModTags.Items.DISPOSABLE).method_26795(class_1802.field_8831, class_1802.field_8858, class_1802.field_8110, class_1802.field_20412, class_1802.field_8328);
		this.method_10512(ModTags.Items.SEMI_DISPOSABLE).method_26795(class_1802.field_20407, class_1802.field_20401, class_1802.field_20394);
		/* todo 1.16-fabric
			.addOptional(new Identifier("quark", "basalt"))
			.addOptional(new Identifier("quark", "jasper"))
			.addOptional(new Identifier("quark", "limestone"))
			.addOptional(new Identifier("quark", "marble"))
			.addOptional(new Identifier("quark", "slate"));
		
		*/

		List<class_3494.class_5123<class_1792>> runes = Arrays.asList(
				ModTags.Items.RUNES_WATER, ModTags.Items.RUNES_FIRE, ModTags.Items.RUNES_EARTH, ModTags.Items.RUNES_AIR,
				ModTags.Items.RUNES_SPRING, ModTags.Items.RUNES_SUMMER, ModTags.Items.RUNES_AUTUMN, ModTags.Items.RUNES_WINTER,
				ModTags.Items.RUNES_MANA, ModTags.Items.RUNES_LUST, ModTags.Items.RUNES_GLUTTONY, ModTags.Items.RUNES_GREED,
				ModTags.Items.RUNES_SLOTH, ModTags.Items.RUNES_WRATH, ModTags.Items.RUNES_ENVY, ModTags.Items.RUNES_PRIDE
		);
		class_5124<class_1792> allRunes = this.method_10512(ModTags.Items.RUNES);
		for (class_3494.class_5123<class_1792> item : runes) {
			this.method_10512(item).method_26793(field_11482.method_10223(
					prefix("rune_" + item.method_26791().method_12832().split("/")[1])));
			allRunes.method_26792(item);
		}

		class_5124<class_1792> allPetals = this.method_10512(ModTags.Items.PETALS);
		for (class_1767 color : class_1767.values()) {
			class_3494.class_5123<class_1792> petalTag = ModTags.Items.getPetalTag(color);
			this.method_10512(petalTag).method_26795(ModItems.getPetal(color), ModBlocks.getMushroom(color).method_8389());
			allPetals.method_26792(petalTag);
		}

		this.method_10512(ModTags.Items.LOONIUM_BLACKLIST).method_26795(ModItems.lexicon, ModItems.overgrowthSeed,
				ModItems.blackLotus, ModItems.blackerLotus).method_26792(class_3489.field_15541);
		this.method_10512(ModTags.Items.MAGNET_RING_BLACKLIST);
	}

	@Nonnull
	@Override
	public String method_10321() {
		return "Botania item tags";
	}
}
