/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.data;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;

import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2403;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import vazkii.botania.common.Botania;
import vazkii.botania.data.recipes.*;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;

public class DataGenerators {
	private static Path inferOutputPath() {
		return Paths.get("../src/generated/resources").toAbsolutePath().normalize();
	}

	public static void registerCommands(CommandDispatcher<class_2168> disp) {
		if (!FabricLoader.getInstance().isDevelopmentEnvironment()) {
			return;
		}

		LiteralArgumentBuilder<class_2168> command = class_2170.method_9247("botania_gendata")
				.then(class_2170.method_9247("confirm").executes(ctx -> {
					Path p = inferOutputPath();
					ctx.getSource().method_9226(new class_2585("Generating data into " + p + "..."), false);
					try {
						gatherData(p);
						ctx.getSource().method_9226(new class_2585("Done"), false);
						return Command.SINGLE_SUCCESS;
					} catch (IOException e) {
						Botania.LOGGER.error("Failed to generate data", e);
						ctx.getSource().method_9213(new class_2585("Failed, see logs"));
						return 0;
					}
				}))
				.executes(ctx -> {
					Path p = inferOutputPath();
					class_2561 yes = new class_2585("[yes]")
							.method_27694(s -> s.method_10977(class_124.field_1060)
									.method_10958(new class_2558(class_2558.class_2559.field_11745, "/botania_gendata confirm")));
					class_2561 msg = new class_2585(String.format("Will generate data into [%s]. Ok? ", p)).method_10852(yes);
					ctx.getSource().method_9226(msg, false);
					return Command.SINGLE_SUCCESS;
				});
		disp.register(command);
	}

	private static void gatherData(Path output) throws IOException {
		class_2403 generator = new class_2403(output, Collections.emptyList());
		generator.method_10314(new BlockLootProvider(generator));
		BlockTagProvider blockTagProvider = new BlockTagProvider(generator);
		generator.method_10314(blockTagProvider);
		generator.method_10314(new ItemTagProvider(generator, blockTagProvider));
		generator.method_10314(new EntityTagProvider(generator));
		generator.method_10314(new StonecuttingProvider(generator));
		generator.method_10314(new RecipeProvider(generator));
		generator.method_10314(new SmeltingProvider(generator));
		generator.method_10314(new ElvenTradeProvider(generator));
		generator.method_10314(new ManaInfusionProvider(generator));
		generator.method_10314(new PureDaisyProvider(generator));
		generator.method_10314(new BrewProvider(generator));
		generator.method_10314(new PetalProvider(generator));
		generator.method_10314(new RuneProvider(generator));
		generator.method_10314(new TerraPlateProvider(generator));
		/* todo 1.16-fabric
		if (evt.includeClient()) {
			generator.install(new BlockstateProvider(generator, evt.getExistingFileHelper()));
			generator.install(new FloatingFlowerModelProvider(generator, evt.getExistingFileHelper()));
			generator.install(new ItemModelProvider(generator, evt.getExistingFileHelper()));
		}
		*/
		generator.method_10315();
	}

}
