/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.data;

import net.minecraft.block.*;
import net.minecraft.class_1767;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2349;
import net.minecraft.class_2354;
import net.minecraft.class_2378;
import net.minecraft.class_2403;
import net.minecraft.class_2466;
import net.minecraft.class_2482;
import net.minecraft.class_2510;
import net.minecraft.class_2544;
import net.minecraft.class_3481;
import vazkii.botania.common.block.*;
import vazkii.botania.common.lib.LibMisc;
import vazkii.botania.common.lib.ModTags;

import javax.annotation.Nonnull;

import java.util.Arrays;
import java.util.Comparator;
import java.util.function.Predicate;

import static vazkii.botania.common.block.ModSubtiles.*;

public class BlockTagProvider extends class_2466 {
	private static final Predicate<class_2248> BOTANIA_BLOCK = b -> LibMisc.MOD_ID.equals(class_2378.field_11146.method_10221(b).method_12836());

	public BlockTagProvider(class_2403 generator) {
		super(generator);
	}

	@Override
	protected void method_10514() {
		method_10512(class_3481.field_15463).method_26793(ModBlocks.ghostRail);
		method_10512(class_3481.field_15469).method_26795(getModBlocks(b -> b instanceof class_2482));
		method_10512(class_3481.field_15459).method_26795(getModBlocks(b -> b instanceof class_2510));
		method_10512(class_3481.field_15504).method_26795(getModBlocks(b -> b instanceof class_2544));
		method_10512(class_3481.field_16584).method_26795(getModBlocks(b -> b instanceof class_2354));
		method_10512(class_3481.field_25147).method_26795(getModBlocks(b -> b instanceof class_2349));
		method_10512(class_3481.field_17753).method_26793(ModBlocks.infrangiblePlatform);
		method_10512(class_3481.field_17754).method_26793(ModBlocks.infrangiblePlatform);

		method_10512(ModTags.Blocks.MUNDANE_FLOATING_FLOWERS).method_26795(
				Arrays.stream(class_1767.values())
						.map(ModBlocks::getFloatingFlower)
						.sorted(Comparator.comparing(class_2378.field_11146::method_10221))
						.toArray(class_2248[]::new)
		);

		method_10512(ModTags.Blocks.SPECIAL_FLOATING_FLOWERS).method_26795(field_11482.method_10220().filter(BOTANIA_BLOCK)
				.filter(b -> b instanceof BlockFloatingSpecialFlower)
				.sorted(Comparator.comparing(class_2378.field_11146::method_10221))
				.toArray(class_2248[]::new)
		);

		method_10512(ModTags.Blocks.FLOATING_FLOWERS).method_26792(ModTags.Blocks.MUNDANE_FLOATING_FLOWERS)
				.method_26792(ModTags.Blocks.SPECIAL_FLOATING_FLOWERS);

		method_10512(ModTags.Blocks.MYSTICAL_FLOWERS).method_26795(
				Arrays.stream(class_1767.values())
						.map(ModBlocks::getFlower)
						.sorted(Comparator.comparing(class_2378.field_11146::method_10221))
						.toArray(class_2248[]::new)
		);

		method_10512(ModTags.Blocks.DOUBLE_MYSTICAL_FLOWERS).method_26795(
				Arrays.stream(class_1767.values())
						.map(ModBlocks::getDoubleFlower)
						.sorted(Comparator.comparing(class_2378.field_11146::method_10221))
						.toArray(class_2248[]::new)
		);

		method_10512(ModTags.Blocks.MISC_SPECIAL_FLOWERS).method_26795(manastar, pureDaisy, bergamute);
		method_10512(ModTags.Blocks.GENERATING_SPECIAL_FLOWERS).method_26795(
				dandelifeon, endoflame, entropinnyum,
				gourmaryllis, hydroangeas, kekimurus,
				munchdew, narslimmus, rafflowsia, rosaArcana,
				shulkMeNot, spectrolus, thermalily
		);
		method_10512(ModTags.Blocks.FUNCTIONAL_SPECIAL_FLOWERS).method_26795(
				agricarnation, agricarnationChibi, bellethorn, bellethornChibi,
				bubbell, bubbellChibi, clayconia, clayconiaChibi,
				daffomill, dreadthorn, exoflame, fallenKanade, heiseiDream,
				hopperhock, hopperhockChibi, hyacidus, jadedAmaranthus,
				jiyuulia, loonium, marimorphosis, marimorphosisChibi,
				medumone, orechid, orechidIgnem, pollidisiac, rannuncarpus, rannuncarpusChibi,
				solegnolia, solegnoliaChibi, spectranthemum, tangleberrie, tigerseye, vinculotus
		);
		method_10512(ModTags.Blocks.SPECIAL_FLOWERS).method_26792(ModTags.Blocks.MISC_SPECIAL_FLOWERS)
				.method_26792(ModTags.Blocks.GENERATING_SPECIAL_FLOWERS)
				.method_26792(ModTags.Blocks.FUNCTIONAL_SPECIAL_FLOWERS);

		method_10512(ModTags.Blocks.MINI_FLOWERS).method_26795(
				getModBlocks(b -> b instanceof BlockSpecialFlower && field_11482.method_10221(b).method_12832().endsWith("_chibi"))
		);

		method_10512(class_3481.field_20338).method_26792(ModTags.Blocks.DOUBLE_MYSTICAL_FLOWERS);
		method_10512(class_3481.field_15480).method_26792(ModTags.Blocks.MYSTICAL_FLOWERS).method_26792(ModTags.Blocks.SPECIAL_FLOWERS);

		method_10512(class_3481.field_15490).method_26795(ModBlocks.elfGlass, ModBlocks.manaGlass, ModBlocks.bifrost, ModBlocks.bifrostPerm);
		method_10512(class_3481.field_22275).method_26795(ModBlocks.manasteelBlock, ModBlocks.terrasteelBlock, ModBlocks.elementiumBlock,
				ModBlocks.manaDiamondBlock, ModBlocks.dragonstoneBlock);

		// todo 1.16-fabric getOrCreateTagBuilder(Tags.Blocks.DIRT).add(getModBlocks(b -> b instanceof BlockAltGrass));
		method_10512(ModTags.Blocks.BLOCKS_ELEMENTIUM).method_26793(ModBlocks.elementiumBlock);
		method_10512(ModTags.Blocks.BLOCKS_MANASTEEL).method_26793(ModBlocks.manasteelBlock);
		method_10512(ModTags.Blocks.BLOCKS_QUARTZ).method_26795(
				ModFluffBlocks.darkQuartz, ModFluffBlocks.manaQuartz, ModFluffBlocks.blazeQuartz,
				ModFluffBlocks.lavenderQuartz, ModFluffBlocks.redQuartz, ModFluffBlocks.elfQuartz, ModFluffBlocks.sunnyQuartz
		);
		method_10512(ModTags.Blocks.BLOCKS_TERRASTEEL).method_26793(ModBlocks.terrasteelBlock);

		method_10512(ModTags.Blocks.LIVINGROCK).method_26793(ModBlocks.livingrock);
		method_10512(ModTags.Blocks.LIVINGWOOD).method_26793(ModBlocks.livingwood);

		method_10512(ModTags.Blocks.CORPOREA_SPARK_OVERRIDE).method_26795(
				ModBlocks.corporeaBlock, ModBlocks.corporeaBrick, ModBlocks.corporeaBrickSlab, ModBlocks.corporeaBrickStairs,
				ModBlocks.corporeaBrickWall, ModBlocks.corporeaCrystalCube, ModBlocks.corporeaFunnel, ModBlocks.corporeaIndex,
				ModBlocks.corporeaInterceptor, ModBlocks.corporeaSlab, ModBlocks.corporeaStairs);

		method_10512(class_3481.field_15466); // We aren't calling vanilla's generation, so need to add a dummy so that using this below doesn't error out.
		method_10512(ModTags.Blocks.TERRAFORMABLE)
				.method_26795(class_2246.field_10115, class_2246.field_10508, class_2246.field_10474, class_2246.field_10277, class_2246.field_10340, class_2246.field_10093, class_2246.field_10346, class_2246.field_10289)
				.method_26795(class_2246.field_10566, class_2246.field_10219, class_2246.field_10253, class_2246.field_10520, class_2246.field_10402)
				.method_26795(class_2246.field_10219, class_2246.field_10255, class_2246.field_10477)
				.method_26792(class_3481.field_15466);
		method_10512(ModTags.Blocks.GAIA_BREAK_BLACKLIST).method_26795(class_2246.field_10327, ModBlocks.manaPylon, ModBlocks.naturaPylon, ModBlocks.gaiaPylon);
		method_10512(ModTags.Blocks.MAGNET_RING_BLACKLIST).method_26795(ModBlocks.manaPool, ModBlocks.creativePool, ModBlocks.dilutedPool,
				ModBlocks.fabulousPool, ModBlocks.terraPlate, ModBlocks.runeAltar);

		method_10512(ModTags.Blocks.TERRA_PLATE_BASE).method_26795(ModBlocks.livingrock, ModBlocks.shimmerrock);
		method_10512(ModTags.Blocks.LAPIS_BLOCKS).method_26793(class_2246.field_10441);
	}

	@Nonnull
	private class_2248[] getModBlocks(Predicate<class_2248> predicate) {
		return field_11482.method_10220().filter(BOTANIA_BLOCK)
				.filter(predicate)
				.sorted(Comparator.comparing(class_2378.field_11146::method_10221))
				.toArray(class_2248[]::new);
	}

	@Nonnull
	@Override
	public String method_10321() {
		return "Botania block tags";
	}
}
