/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;

import net.fabricmc.fabric.api.tool.attribute.v1.FabricToolTags;
import net.minecraft.class_101;
import net.minecraft.class_104;
import net.minecraft.class_141;
import net.minecraft.class_173;
import net.minecraft.class_1893;
import net.minecraft.class_1935;
import net.minecraft.class_201;
import net.minecraft.class_2035;
import net.minecraft.class_2073;
import net.minecraft.class_2096;
import net.minecraft.class_212;
import net.minecraft.class_223;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2320;
import net.minecraft.class_2378;
import net.minecraft.class_2403;
import net.minecraft.class_2405;
import net.minecraft.class_2408;
import net.minecraft.class_2482;
import net.minecraft.class_2756;
import net.minecraft.class_2771;
import net.minecraft.class_2960;
import net.minecraft.class_3837;
import net.minecraft.class_44;
import net.minecraft.class_4559;
import net.minecraft.class_52;
import net.minecraft.class_5341;
import net.minecraft.class_55;
import net.minecraft.class_60;
import net.minecraft.class_61;
import net.minecraft.class_65;
import net.minecraft.class_77;
import net.minecraft.class_79;
import net.minecraft.class_83;
import net.minecraft.loot.*;
import vazkii.botania.api.subtile.TileEntityGeneratingFlower;
import vazkii.botania.common.block.BlockAltGrass;
import vazkii.botania.common.block.BlockModDoubleFlower;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.ModSubtiles;
import vazkii.botania.common.block.subtile.generating.*;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.lib.LibBlockNames;
import vazkii.botania.common.lib.LibMisc;

import javax.annotation.Nonnull;

import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

import static vazkii.botania.common.lib.ResourceLocationHelper.prefix;

public class BlockLootProvider implements class_2405 {
	private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
	private static final class_5341.class_210 SILK_TOUCH = class_223.method_945(class_2073.class_2074.method_8973()
			.method_8978(new class_2035(class_1893.field_9099, class_2096.class_2100.method_9053(1))));

	private final class_2403 generator;
	private final Map<class_2248, Function<class_2248, class_52.class_53>> functionTable = new HashMap<>();

	public BlockLootProvider(class_2403 generator) {
		this.generator = generator;

		for (class_2248 b : class_2378.field_11146) {
			class_2960 id = class_2378.field_11146.method_10221(b);
			if (!LibMisc.MOD_ID.equals(id.method_12836())) {
				continue;
			}
			if (b instanceof class_2482) {
				functionTable.put(b, BlockLootProvider::genSlab);
			} else if (b instanceof BlockModDoubleFlower) {
				functionTable.put(b, BlockLootProvider::genDoubleFlower);
			} else if (b instanceof BlockAltGrass) {
				functionTable.put(b, BlockLootProvider::genAltGrass);
			} else if (id.method_12832().matches(LibBlockNames.METAMORPHIC_PREFIX + "\\w+" + "_stone")) {
				functionTable.put(b, BlockLootProvider::genMetamorphicStone);
			}
		}

		// Empty
		functionTable.put(ModBlocks.bifrost, BlockLootProvider::empty);
		functionTable.put(ModBlocks.cocoon, BlockLootProvider::empty);
		functionTable.put(ModBlocks.fakeAir, BlockLootProvider::empty);
		functionTable.put(ModBlocks.manaFlame, BlockLootProvider::empty);
		functionTable.put(ModBlocks.pistonRelay, BlockLootProvider::empty);

		// Redirects
		functionTable.put(ModBlocks.cacophonium, b -> genRegular(class_2246.field_10179));
		functionTable.put(ModBlocks.enchantedSoil, b -> genRegular(class_2246.field_10566));
		functionTable.put(ModBlocks.enchanter, b -> genRegular(class_2246.field_10441));
		functionTable.put(ModBlocks.mossyAltar, b -> genRegular(ModBlocks.defaultAltar));

		// Special
		functionTable.put(ModBlocks.cellBlock, BlockLootProvider::genCellBlock);
		functionTable.put(ModBlocks.root, BlockLootProvider::genRoot);
		functionTable.put(ModBlocks.solidVines, BlockLootProvider::genSolidVine);
		functionTable.put(ModBlocks.tinyPotato, BlockLootProvider::genTinyPotato);

		// Flower NBT saving
		functionTable.put(ModSubtiles.gourmaryllis, b -> genCopyNbt(b, SubTileGourmaryllis.TAG_LAST_FOODS, SubTileGourmaryllis.TAG_LAST_FOOD_COUNT, SubTileGourmaryllis.TAG_STREAK_LENGTH));
		functionTable.put(ModSubtiles.gourmaryllisFloating, b -> genCopyNbt(b, SubTileGourmaryllis.TAG_LAST_FOODS, SubTileGourmaryllis.TAG_LAST_FOOD_COUNT, SubTileGourmaryllis.TAG_STREAK_LENGTH));
		functionTable.put(ModSubtiles.hydroangeas, b -> genCopyNbt(b, SubTileHydroangeas.TAG_COOLDOWN, TileEntityGeneratingFlower.TAG_PASSIVE_DECAY_TICKS));
		functionTable.put(ModSubtiles.hydroangeasFloating, b -> genCopyNbt(b, SubTileHydroangeas.TAG_COOLDOWN, TileEntityGeneratingFlower.TAG_PASSIVE_DECAY_TICKS));
		functionTable.put(ModSubtiles.munchdew, b -> genCopyNbt(b, SubTileMunchdew.TAG_COOLDOWN));
		functionTable.put(ModSubtiles.munchdewFloating, b -> genCopyNbt(b, SubTileMunchdew.TAG_COOLDOWN));
		functionTable.put(ModSubtiles.rafflowsia, b -> genCopyNbt(b, SubTileRafflowsia.TAG_LAST_FLOWERS, SubTileRafflowsia.TAG_LAST_FLOWER_TIMES));
		functionTable.put(ModSubtiles.rafflowsiaFloating, b -> genCopyNbt(b, SubTileRafflowsia.TAG_LAST_FLOWERS, SubTileRafflowsia.TAG_LAST_FLOWER_TIMES));
		functionTable.put(ModSubtiles.spectrolus, b -> genCopyNbt(b, SubTileSpectrolus.TAG_NEXT_COLOR));
		functionTable.put(ModSubtiles.spectrolusFloating, b -> genCopyNbt(b, SubTileSpectrolus.TAG_NEXT_COLOR));
		functionTable.put(ModSubtiles.thermalily, b -> genCopyNbt(b, SubTileHydroangeas.TAG_COOLDOWN));
		functionTable.put(ModSubtiles.thermalilyFloating, b -> genCopyNbt(b, SubTileHydroangeas.TAG_COOLDOWN));
	}

	@Override
	public void method_10319(class_2408 cache) throws IOException {
		Map<class_2960, class_52.class_53> tables = new HashMap<>();

		for (class_2248 b : class_2378.field_11146) {
			class_2960 id = class_2378.field_11146.method_10221(b);
			if (!LibMisc.MOD_ID.equals(id.method_12836())) {
				continue;
			}
			Function<class_2248, class_52.class_53> func = functionTable.getOrDefault(b, BlockLootProvider::genRegular);
			tables.put(id, func.apply(b));
		}

		for (Map.Entry<class_2960, class_52.class_53> e : tables.entrySet()) {
			Path path = getPath(generator.method_10313(), e.getKey());
			class_2405.method_10320(GSON, cache, class_60.method_372(e.getValue().method_334(class_173.field_1172).method_338()), path);
		}
	}

	private static Path getPath(Path root, class_2960 id) {
		return root.resolve("data/" + id.method_12836() + "/loot_tables/blocks/" + id.method_12832() + ".json");
	}

	private static class_52.class_53 empty(class_2248 b) {
		return class_52.method_324();
	}

	private static class_52.class_53 genCopyNbt(class_2248 b, String... tags) {
		class_79.class_80<?> entry = class_77.method_411(b);
		class_3837.class_3838 func = class_3837.method_16848(class_3837.class_3840.field_17027);
		for (String tag : tags) {
			func = func.method_16856(tag, "BlockEntityTag." + tag);
		}
		class_55.class_56 pool = class_55.method_347().method_352(class_44.method_289(1)).method_351(entry)
				.method_356(class_201.method_871())
				.method_353(func);
		return class_52.method_324().method_336(pool);
	}

	private static class_52.class_53 genCellBlock(class_2248 b) {
		class_2073.class_2074 silkPred = class_2073.class_2074.method_8973()
				.method_8978(new class_2035(class_1893.field_9099, class_2096.class_2100.method_9053(1)));
		class_79.class_80<?> silk = class_77.method_411(b)
				.method_421(class_223.method_945(silkPred));
		return class_52.method_324().method_336(class_55.method_347().method_352(class_44.method_289(1)).method_351(silk));
	}

	private static class_52.class_53 genTinyPotato(class_2248 b) {
		class_79.class_80<?> entry = class_77.method_411(b)
				.method_438(class_101.method_473(class_101.class_102.field_1023));
		class_55.class_56 pool = class_55.method_347().method_352(class_44.method_289(1)).method_351(entry)
				.method_356(class_201.method_871());
		return class_52.method_324().method_336(pool);
	}

	private static class_52.class_53 genMetamorphicStone(class_2248 b) {
		String cobbleName = class_2378.field_11146.method_10221(b).method_12832().replaceAll("_stone", "_cobblestone");
		class_2248 cobble = class_2378.field_11146.method_17966(prefix(cobbleName)).get();
		return genSilkDrop(b, cobble);
	}

	private static class_52.class_53 genSilkDrop(class_1935 silkDrop, class_1935 normalDrop) {
		class_79.class_80<?> cobbleDrop = class_77.method_411(normalDrop).method_421(class_201.method_871());
		class_79.class_80<?> stoneDrop = class_77.method_411(silkDrop).method_421(SILK_TOUCH);

		return class_52.method_324().method_336(
				class_55.method_347().method_352(class_44.method_289(1))
						.method_351(stoneDrop.method_417(cobbleDrop)));
	}

	private static class_52.class_53 genSolidVine(class_2248 b) {
		class_79.class_80<?> entry = class_83.method_428(new class_2960("blocks/vine"));
		return class_52.method_324().method_336(class_55.method_347().method_352(class_44.method_289(1)).method_351(entry));
	}

	private static class_52.class_53 genRoot(class_2248 b) {
		class_79.class_80<?> entry = class_77.method_411(ModItems.livingroot)
				.method_438(class_141.method_621(class_61.method_377(2, 4)))
				.method_438(class_104.method_478());
		return class_52.method_324().method_336(class_55.method_347().method_352(class_44.method_289(1)).method_351(entry));
	}

	private static class_52.class_53 genSlab(class_2248 b) {
		class_79.class_80<?> entry = class_77.method_411(b)
				.method_438(class_141.method_621(class_44.method_289(2))
						.method_524(class_212.method_900(b).method_22584(class_4559.class_4560.method_22523().method_22525(class_2482.field_11501, class_2771.field_12682))))
				.method_438(class_104.method_478());
		return class_52.method_324().method_336(class_55.method_347().method_352(class_44.method_289(1)).method_351(entry));
	}

	private static class_52.class_53 genDoubleFlower(class_2248 b) {
		class_79.class_80<?> entry = class_77.method_411(b)
				.method_421(class_212.method_900(b).method_22584(class_4559.class_4560.method_22523().method_22525(class_2320.field_10929, class_2756.field_12607)))
				.method_421(class_223.method_945(class_2073.class_2074.method_8973().method_8975(FabricToolTags.SHEARS)));
		class_55.class_56 pool = class_55.method_347().method_352(class_44.method_289(1)).method_351(entry)
				.method_356(class_201.method_871());
		return class_52.method_324().method_336(pool);
	}

	private static class_52.class_53 genAltGrass(class_2248 b) {
		class_79.class_80<?> silk = class_77.method_411(b)
				.method_421(SILK_TOUCH);
		class_79.class_80<?> dirt = class_77.method_411(class_2246.field_10566)
				.method_421(class_201.method_871());
		class_79.class_80<?> entry = class_65.method_386(silk, dirt);
		class_55.class_56 pool = class_55.method_347().method_352(class_44.method_289(1)).method_351(entry);
		return class_52.method_324().method_336(pool);
	}

	private static class_52.class_53 genRegular(class_2248 b) {
		class_79.class_80<?> entry = class_77.method_411(b);
		class_55.class_56 pool = class_55.method_347().method_352(class_44.method_289(1)).method_351(entry)
				.method_356(class_201.method_871());
		return class_52.method_324().method_336(pool);
	}

	@Nonnull
	@Override
	public String method_10321() {
		return "Botania block loot tables";
	}
}
