/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.world;

import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2498;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3494;
import net.minecraft.class_3614;
import net.minecraft.class_3965;
import vazkii.botania.common.Botania;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.tile.TileManaFlame;
import vazkii.botania.common.core.handler.ConfigHandler;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.item.equipment.tool.ToolCommons;
import vazkii.botania.common.network.PacketGogWorld;

public final class SkyblockWorldEvents {

	private SkyblockWorldEvents() {}

	private static final class_2960 PEBBLE_SOURCES = new class_2960("gardenofglass:pebble_sources");

	public static void syncGogStatus(class_1297 e) {
		if (e instanceof class_3222) {
			boolean isGog = SkyblockChunkGenerator.isWorldSkyblock(e.field_6002);
			if (isGog) {
				PacketGogWorld.send((class_3222) e);
			}
		}
	}

	public static void onPlayerJoin(class_3222 player) {
		class_1937 world = player.field_6002;
		if (SkyblockChunkGenerator.isWorldSkyblock(world)) {
			SkyblockSavedData data = SkyblockSavedData.get((class_3218) world);
			if (!data.skyblocks.containsValue(class_156.field_25140)) {
				IslandPos islandPos = data.getSpawn();
				((class_3218) world).method_8554(islandPos.getCenter(), 0);
				spawnPlayer(player, islandPos);
				Botania.LOGGER.info("Created the spawn GoG island");
			}
		}
	}

	public static class_1269 onPlayerInteract(class_1657 player, class_1937 world, class_1268 hand, class_3965 hit) {
		if (Botania.gardenOfGlassLoaded) {
			class_1799 equipped = player.method_5998(hand);

			if (equipped.method_7960() && player.method_5715()) {
				class_2680 state = world.method_8320(hit.method_17777());
				class_2248 block = state.method_26204();

				class_3494<class_2248> tag = world.method_8514().method_30215().method_30213(PEBBLE_SOURCES);
				if (tag.method_15141(block)) {
					class_2498 st = state.method_26231();
					player.method_5783(st.method_10595(), st.method_10597() * 0.4F, st.method_10599() + (float) (Math.random() * 0.2 - 0.1));

					if (world.field_9236) {
						player.method_6104(hand);
					} else if (Math.random() < 0.8) {
						player.method_7328(new class_1799(ModItems.pebble), false);
					}

					return class_1269.field_5812;
				}
			} else if (!equipped.method_7960() && equipped.method_7909() == class_1802.field_8428) {
				class_3965 rtr = ToolCommons.raytraceFromEntity(player, 4.5F, true);
				if (rtr.method_17783() == class_239.class_240.field_1332) {
					class_2338 pos = rtr.method_17777();
					if (world.method_8320(pos).method_26207() == class_3614.field_15920) {
						if (!world.field_9236) {
							equipped.method_7934(1);

							if (equipped.method_7960()) {
								player.method_6122(hand, new class_1799(ModItems.waterBowl));
							} else {
								player.field_7514.method_7398(player.field_6002, new class_1799(ModItems.waterBowl));
							}
						}

						return class_1269.field_5812;
					}
				}
			}
		}
		return class_1269.field_5811;
	}

	public static void spawnPlayer(class_1657 player, IslandPos islandPos) {
		class_2338 pos = islandPos.getCenter();
		createSkyblock(player.field_6002, pos);

		if (player instanceof class_3222) {
			class_3222 pmp = (class_3222) player;
			pmp.method_5859(pos.method_10263() + 0.5, pos.method_10264() + 1.6, pos.method_10260() + 0.5);
			pmp.method_26284(pmp.field_6002.method_27983(), pos, 0, true, false);
			if (ConfigHandler.COMMON.gogSpawnWithLexicon.getValue()) {
				player.field_7514.method_7394(new class_1799(ModItems.lexicon));
			}
		}
	}

	public static void createSkyblock(class_1937 world, class_2338 pos) {
		for (int i = 0; i < 3; i++) {
			for (int j = 0; j < 4; j++) {
				for (int k = 0; k < 3; k++) {
					world.method_8501(pos.method_10069(-1 + i, -1 - j, -1 + k), j == 0 ? class_2246.field_10219.method_9564() : class_2246.field_10566.method_9564());
				}
			}
		}
		world.method_8501(pos.method_10069(-1, -2, 0), class_2246.field_10382.method_9564());
		world.method_8501(pos.method_10069(1, 2, 1), ModBlocks.manaFlame.method_9564());
		int r = 70 + world.field_9229.nextInt(185);
		int g = 70 + world.field_9229.nextInt(185);
		int b = 70 + world.field_9229.nextInt(185);
		int color = r << 16 | g << 8 | b;
		((TileManaFlame) world.method_8321(pos.method_10069(1, 2, 1))).setColor(color);

		int[][] rootPositions = new int[][] {
				{ -1, -3, -1 },
				{ -2, -4, -1 },
				{ -2, -4, -2 },
				{ +1, -4, -1 },
				{ +1, -5, -1 },
				{ +2, -5, -1 },
				{ +2, -6, +0 },
				{ +0, -4, +2 },
				{ +0, -5, +2 },
				{ +0, -5, +3 },
				{ +0, -6, +3 },
		};
		for (int[] root : rootPositions) {
			world.method_8501(pos.method_10069(root[0], root[1], root[2]), ModBlocks.root.method_9564());
		}

		world.method_8501(pos.method_10087(4), class_2246.field_9987.method_9564());
	}

}
