/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.world;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_1966;
import net.minecraft.class_2378;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2794;
import net.minecraft.class_2893;
import net.minecraft.class_2902;
import net.minecraft.class_3215;
import net.minecraft.class_3233;
import net.minecraft.class_4543;
import net.minecraft.class_4966;
import net.minecraft.class_5138;
import net.minecraft.class_5284;
import net.minecraft.world.gen.*;
import net.minecraft.world.gen.chunk.*;

import java.util.function.Supplier;

import static vazkii.botania.common.lib.ResourceLocationHelper.prefix;

public class SkyblockChunkGenerator extends class_2794 {
	// [VanillaCopy] overworld chunk generator codec
	public static final Codec<SkyblockChunkGenerator> field_24746 = RecordCodecBuilder.create(
			(instance) -> instance.group(
					class_1966.field_24713.fieldOf("biome_source").forGetter((gen) -> gen.field_24747),
					Codec.LONG.fieldOf("seed").stable().forGetter((gen) -> gen.seed),
					class_5284.field_24781.fieldOf("settings").forGetter((gen) -> gen.settings)
			).apply(instance, instance.stable(SkyblockChunkGenerator::new)));

	public static void init() {
		class_2378.method_10230(class_2378.field_25097, prefix("skyblock"), SkyblockChunkGenerator.field_24746);
	}

	private final long seed;
	private final Supplier<class_5284> settings;

	public SkyblockChunkGenerator(class_1966 provider, long seed, Supplier<class_5284> settings) {
		super(provider, provider, settings.get().method_28007(), seed);
		this.seed = seed;
		this.settings = settings;
	}

	public static boolean isWorldSkyblock(class_1937 world) {
		return world.method_8398() instanceof class_3215
				&& ((class_3215) world.method_8398()).method_12129() instanceof SkyblockChunkGenerator;
	}

	@Override
	protected Codec<? extends class_2794> method_28506() {
		return field_24746;
	}

	@Override
	public class_2794 method_27997(long newSeed) {
		return new SkyblockChunkGenerator(this.field_24747.method_27985(newSeed), newSeed, settings);
	}

	@Override
	public void method_12088(class_1936 world, class_5138 structureManager, class_2791 chunk) {

	}

	@Override
	public void method_12110(class_3233 region, class_2791 chunk) {

	}

	@Override
	public void method_12108(long seed, class_4543 biomes, class_2791 chunk, class_2893.class_2894 stage) {}

	@Override
	public void method_12102(class_3233 region, class_5138 structureManager) {}

	@Override
	public int method_16397(int x, int z, class_2902.class_2903 heightmapType) {
		return 0;
	}

	@Override
	public class_1922 method_26261(int p_230348_1_, int p_230348_2_) {
		return new class_4966(new class_2680[0]);
	}
}
