/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.world;

import vazkii.botania.common.block.ModBlocks;

import java.util.Random;
import net.minecraft.class_1767;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2794;
import net.minecraft.class_3031;
import net.minecraft.class_5281;

public class MysticalMushroomFeature extends class_3031<MysticalMushroomConfig> {
	public MysticalMushroomFeature() {
		super(MysticalMushroomConfig.CODEC);
	}

	@Override
	public boolean generate(class_5281 world, class_2794 generator, Random rand, class_2338 pos, MysticalMushroomConfig config) {
		boolean any = false;
		for (int i = 0; i < config.getMushroomPatchSize(); i++) {
			int x = pos.method_10263() + rand.nextInt(16) + 8;
			int z = pos.method_10260() + rand.nextInt(16) + 8;
			int y = rand.nextInt(26) + 4;
			class_2338 pos3 = new class_2338(x, y, z);
			class_1767 color = class_1767.method_7791(rand.nextInt(16));
			class_2680 mushroom = ModBlocks.getMushroom(color).method_9564();
			if (world.method_22347(pos3) && mushroom.method_26184(world, pos3)) {
				world.method_8652(pos3, mushroom, 2);
				any = true;
			}
		}
		return any;
	}
}
