/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.world;

import vazkii.botania.common.block.BlockModFlower;
import vazkii.botania.common.block.ModBlocks;

import javax.annotation.Nonnull;
import net.minecraft.class_1767;
import net.minecraft.class_2248;
import net.minecraft.class_2320;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2794;
import net.minecraft.class_2902;
import net.minecraft.class_3031;
import net.minecraft.class_5281;
import java.util.Random;

public class MysticalFlowerFeature extends class_3031<MysticalFlowerConfig> {
	public MysticalFlowerFeature() {
		super(MysticalFlowerConfig.CODEC);
	}

	@Override
	public boolean generate(@Nonnull class_5281 world, @Nonnull class_2794 generator, @Nonnull Random rand, @Nonnull class_2338 pos, @Nonnull MysticalFlowerConfig config) {
		boolean any = false;
		int dist = Math.min(8, Math.max(1, config.getPatchRadius()));
		for (int i = 0; i < config.getPatchCount(); i++) {
			if (rand.nextInt(config.getPatchChance()) == 0) {
				int x = pos.method_10263() + rand.nextInt(16);
				int z = pos.method_10260() + rand.nextInt(16);
				int y = world.method_8624(class_2902.class_2903.field_13203, x, z);

				class_1767 color = class_1767.method_7791(rand.nextInt(16));
				class_2680 flower = ModBlocks.getFlower(color).method_9564();

				for (int j = 0; j < config.getPatchDensity() * config.getPatchChance(); j++) {
					int x1 = x + rand.nextInt(dist * 2) - dist;
					int y1 = y + rand.nextInt(4) - rand.nextInt(4);
					int z1 = z + rand.nextInt(dist * 2) - dist;
					class_2338 pos2 = new class_2338(x1, y1, z1);
					if (world.method_22347(pos2) && (!world.method_8597().method_27998() || y1 < 127) && flower.method_26184(world, pos2)) {
						world.method_8652(pos2, flower, 2);
						any = true;
						if (rand.nextDouble() < config.getTallChance()
								&& ((BlockModFlower) flower.method_26204()).method_9651(world, pos2, world.method_8320(pos2), false)) {
							class_2248 block = ModBlocks.getDoubleFlower(color);
							if (block instanceof class_2320) {
								((class_2320) block).method_10021(world, pos2, 3);
							}
						}
					}
				}
			}
		}

		return any;
	}
}
