/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.world;

import com.google.common.collect.ImmutableSet;

import net.fabricmc.fabric.api.biome.v1.BiomeModifications;
import net.minecraft.class_1959;
import net.minecraft.class_2378;
import net.minecraft.class_2893;
import net.minecraft.class_2975;
import net.minecraft.class_2998;
import net.minecraft.class_3031;
import net.minecraft.class_3284;
import net.minecraft.class_5458;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.core.handler.ConfigHandler;

import java.util.Set;

import static vazkii.botania.common.lib.ResourceLocationHelper.prefix;

public class ModFeatures {
	public static final class_3031<MysticalFlowerConfig> MYSTICAL_FLOWERS = new MysticalFlowerFeature();
	public static final class_3031<MysticalMushroomConfig> MYSTICAL_MUSHROOMS = new MysticalMushroomFeature();
	public static final class_2975<?, ?> MYSTICAL_FLOWERS_CONF = MYSTICAL_FLOWERS
			.method_23397(new MysticalFlowerConfig(2, 2, 6, 16, 0.05))
			.method_23388(class_3284.field_14250.method_23475(class_2998.field_13436));
	public static final class_2975<?, ?> MYSTICAL_MUSHROOMS_CONF = MYSTICAL_MUSHROOMS
			.method_23397(new MysticalMushroomConfig(40))
			.method_23388(class_3284.field_14250.method_23475(class_2998.field_13436));

	// todo 1.16.2 blacklist, this is about the closest to the old one?
	public static final Set<class_1959.class_1961> TYPE_BLACKLIST = ImmutableSet.of(
			class_1959.class_1961.field_9366,
			class_1959.class_1961.field_9360,
			class_1959.class_1961.field_9362,
			class_1959.class_1961.field_9365
	);

	public static void registerFeatures() {
		class_2378<class_3031<?>> r = class_2378.field_11138;

		ModBlocks.register(r, "mystical_flowers", MYSTICAL_FLOWERS);
		ModBlocks.register(r, "mystical_mushrooms", MYSTICAL_MUSHROOMS);

		class_2378.method_10230(class_5458.field_25929, prefix("mystical_flowers"), MYSTICAL_FLOWERS_CONF);
		class_2378.method_10230(class_5458.field_25929, prefix("mystical_mushrooms"), MYSTICAL_MUSHROOMS_CONF);

		if (ConfigHandler.COMMON.worldgenEnabled.getValue()) {
			BiomeModifications.addFeature(ctx -> {
				class_1959.class_1961 category = ctx.getBiome().method_8688();
				return !TYPE_BLACKLIST.contains(category);
			},
					class_2893.class_2895.field_13178,
					class_5458.field_25929.method_29113(MYSTICAL_FLOWERS_CONF).get());
			BiomeModifications.addFeature(ctx -> {
				return ctx.getBiome().method_8688() != class_1959.class_1961.field_9360;
			}, class_2893.class_2895.field_13178,
					class_5458.field_25929.method_29113(MYSTICAL_MUSHROOMS_CONF).get());
		}

	}

}
