/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.world;

import net.minecraft.class_2338;
import net.minecraft.class_2487;

public final class IslandPos {
	private final int x;
	private final int z;

	public IslandPos(int x, int z) {
		this.x = x;
		this.z = z;
	}

	public class_2338 getCenter() {
		return new class_2338(x << 8, 64, z << 8);
	}

	public static IslandPos fromTag(class_2487 tag) {
		return new IslandPos(tag.method_10550("IslandX"), tag.method_10550("IslandZ"));
	}

	public class_2487 toTag() {
		class_2487 tag = new class_2487();
		tag.method_10569("IslandX", x);
		tag.method_10569("IslandZ", z);
		return tag;
	}

	@Override
	public boolean equals(Object o) {
		if (this == o) {
			return true;
		} else if (!(o instanceof IslandPos)) {
			return false;
		}
		IslandPos islandPos = (IslandPos) o;
		return this.x == islandPos.x && this.z == islandPos.z;
	}

	@Override
	public int hashCode() {
		int result = x;
		result = 31 * result + z;
		return result;
	}
}
