/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.network;

import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_2378;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_634;
import net.minecraft.class_638;
import vazkii.botania.common.lib.LibMisc;

import java.util.UUID;

import static vazkii.botania.common.lib.ResourceLocationHelper.prefix;

import io.netty.buffer.Unpooled;

// This should only be used for non-living entities. Vanilla's MobSpawn packet handles modded living entities fine.
// [VanillaCopy] Format is basically same as EntitySpawnS2CPacket.
public class PacketSpawnEntity {
	public static final class_2960 ID = prefix("sp");

	public static class_2596<?> make(class_1297 e) {
		if (!class_2378.field_11145.method_10221(e.method_5864()).method_12836().equals(LibMisc.MOD_ID)) {
			throw new IllegalArgumentException("Only should be used by Botania entities");
		}

		class_2540 buf = new class_2540(Unpooled.buffer());
		buf.method_10804(e.method_5628());
		buf.method_10797(e.method_5667());
		buf.method_10804(class_2378.field_11145.method_10206(e.method_5864()));
		buf.writeDouble(e.method_23317());
		buf.writeDouble(e.method_23318());
		buf.writeDouble(e.method_23321());
		buf.writeByte(class_3532.method_15375(e.field_5965 * 256.0F / 360.0F));
		buf.writeByte(class_3532.method_15375(e.field_6031 * 256.0F / 360.0F));

		class_243 velocity = e.method_18798();
		buf.writeShort((int) (class_3532.method_15350(velocity.field_1352, -3.9D, 3.9D) * 8000.0D));
		buf.writeShort((int) (class_3532.method_15350(velocity.field_1351, -3.9D, 3.9D) * 8000.0D));
		buf.writeShort((int) (class_3532.method_15350(velocity.field_1350, -3.9D, 3.9D) * 8000.0D));

		return ServerPlayNetworking.createS2CPacket(ID, buf);
	}

	public static class Handler {
		public static void handle(class_310 client, class_634 handler, class_2540 buf, PacketSender responseSender) {
			int id = buf.method_10816();
			UUID uuid = buf.method_10790();
			class_1299<?> type = class_2378.field_11145.method_10200(buf.method_10816());
			double x = buf.readDouble();
			double y = buf.readDouble();
			double z = buf.readDouble();
			float pitch = (buf.readByte() * 360) / 256.0F;
			float yaw = (buf.readByte() * 360) / 256.0F;
			double dx = buf.readShort() / 8000.0;
			double dy = buf.readShort() / 8000.0;
			double dz = buf.readShort() / 8000.0;

			client.execute(() -> {
				class_638 world = client.field_1687;
				class_1297 e = type.method_5883(world);
				if (e != null) {
					e.method_18003(x, y, z);
					e.method_24203(x, y, z);
					e.field_5965 = pitch;
					e.field_6031 = yaw;
					e.method_5838(id);
					e.method_5826(uuid);
					e.method_5750(dx, dy, dz);
					world.method_2942(id, e);
				}
			});
		}
	}

}
