/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.network;

import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.class_1799;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.server.MinecraftServer;
import vazkii.botania.common.core.handler.EquipmentHandler;
import vazkii.botania.common.item.equipment.bauble.ItemCloudPendant;
import vazkii.botania.common.item.equipment.bauble.ItemTravelBelt;

import static vazkii.botania.common.lib.ResourceLocationHelper.prefix;

public class PacketJump {
	public static final class_2960 ID = prefix("jmp");

	public static void send() {
		ClientPlayNetworking.send(ID, PacketHandler.EMPTY_BUF);
	}

	public static void handle(MinecraftServer server, class_3222 player, class_3244 handler, class_2540 buf, PacketSender responseSender) {
		server.execute(() -> {
			class_1799 amuletStack = EquipmentHandler.findOrEmpty(s -> s.method_7909() instanceof ItemCloudPendant, player);
			if (!amuletStack.method_7960()) {
				player.method_7322(0.3F);
				player.field_6017 = 0;

				class_1799 belt = EquipmentHandler.findOrEmpty(s -> s.method_7909() instanceof ItemTravelBelt, player);
				if (!belt.method_7960()) {
					player.field_6017 = -((ItemTravelBelt) belt.method_7909()).fallBuffer * ((ItemCloudPendant) amuletStack.method_7909()).getMaxAllowedJumps();
				}
			}
		});
	}
}
