/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.network;

import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_634;
import vazkii.botania.mixin.AccessorItemEntity;

import static vazkii.botania.common.lib.ResourceLocationHelper.prefix;

import io.netty.buffer.Unpooled;

public class PacketItemAge {
	public static final class_2960 ID = prefix("ia");

	public static void send(class_3222 player, int entityId, int age) {
		class_2540 buf = new class_2540(Unpooled.buffer());
		buf.method_10804(entityId);
		buf.method_10804(age);
		ServerPlayNetworking.send(player, ID, buf);
	}

	public static class Handler {
		public static void handle(class_310 client, class_634 handler, class_2540 buf, PacketSender responseSender) {
			int entityId = buf.method_10816();
			int age = buf.method_10816();
			client.execute(() -> {
				class_1297 e = class_310.method_1551().field_1687.method_8469(entityId);
				if (e instanceof class_1542) {
					((AccessorItemEntity) e).setAge(age);
				}
			});
		}
	}

}
