/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.network;

import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.class_1799;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.server.MinecraftServer;
import vazkii.botania.api.corporea.CorporeaHelper;
import vazkii.botania.common.block.tile.corporea.TileCorporeaIndex;

import static vazkii.botania.common.lib.ResourceLocationHelper.prefix;

import io.netty.buffer.Unpooled;

public class PacketIndexKeybindRequest {
	public static final class_2960 ID = prefix("idx");

	public static void send(class_1799 stack) {
		class_2540 buf = new class_2540(Unpooled.buffer());
		buf.method_10793(stack);
		ClientPlayNetworking.send(ID, buf);
	}

	public static void handle(MinecraftServer server, class_3222 player, class_3244 handler, class_2540 buf, PacketSender responseSender) {
		class_1799 stack = buf.method_10819();
		server.execute(() -> {
			if (player.method_7325()) {
				return;
			}

			boolean checkNBT = stack.method_7969() != null && !stack.method_7969().isEmpty();
			for (TileCorporeaIndex index : TileCorporeaIndex.InputHandler.getNearbyIndexes(player)) {
				if (index.getSpark() != null) {
					index.performPlayerRequest(player, CorporeaHelper.instance().createMatcher(stack, checkNBT), stack.method_7947());
				}
			}
		});
	}
}
