/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.network;

import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_634;
import net.minecraft.class_638;
import vazkii.botania.client.core.SkyblockWorldInfo;

import static vazkii.botania.common.lib.ResourceLocationHelper.prefix;

public class PacketGogWorld {
	public static final class_2960 ID = prefix("gog");

	public static void send(class_3222 player) {
		ServerPlayNetworking.send(player, ID, PacketHandler.EMPTY_BUF);
	}

	public static class Handler {
		public static void handle(class_310 client, class_634 handler, class_2540 buf, PacketSender responseSender) {
			client.execute(() -> {
				class_638.class_5271 info = client.field_1687.method_28104();
				if (info instanceof SkyblockWorldInfo) {
					((SkyblockWorldInfo) info).markGardenOfGlass();
				}
			});
		}
	}
}
